import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class does the moves associated to
   the plaid PET polytopes.*/

public class PlaidPolytopeMoves {

    /**Here's the lattice action*/


    public static Polytope shift(int a1,int a2,int a3,Polytope X) {
	Polytope Y=new Polytope();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) {
	    Y.V[i]=shift(a1,a2,a3,X.V[i]);
	}

	if((10+a1)%2==1) {
	  Y.type[1]=X.type[2];
  	  Y.type[2]=X.type[1];
	}
	else {
	  Y.type[1]=X.type[1];
  	  Y.type[2]=X.type[2];
	}

	for(int i=0;i<6;++i) Y.code[i]=X.code[i];
	return(Y);
    }

    public static Vector4 shift(int a1,int a2,int a3,Vector4 V) {
	Vector4 W=new Vector4();
	W=new Vector4();
	W.x[0]=V.x[0]+2*a1;
	W.x[1]=V.x[1]+a1*V.x[3]+2*a2;
	W.x[2]=V.x[2]+a1*V.x[3]+2*a3;
	W.x[3]=V.x[3];
	return(W);
    }




    public static double[] shift(int a1,int a2,int a3,double[] U) {
	Vector4 V=new Vector4(U[0],U[1],U[2],U[3]);
	V=shift(a1,a2,a3,V);
	double[] UU={V.x[0],V.x[1],V.x[2],V.x[3]};
	return(UU);
    }


    /**Here is the plaid PET dynamics. The
       direction should be 1 or 2 to move.
       The forward map is direction=2*/

    public static Polytope map(int direction,Polytope X) {
	if(direction==0) return(X);
	if(X.type[1]==X.type[2]) return(X);
	Polytope Y=new Polytope();
	Y.count=X.count;
	int k=X.type[direction];
	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=map(k,X.V[i]);
	}
	Y.type[1]=X.type[1];
	Y.type[2]=X.type[2];
	return(Y);
    }

    public static Vector4 map(int k,Vector4 V) {
	if(k==0) return map0(V);
	if(k==1) return map1(V);
	if(k==2) return map2(V);
	if(k==3) return map3(V);
	return null;
    }

    public static Vector4 map0(Vector4 V) {
	Vector4 W=new Vector4();
	W.x[0]=V.x[0]-2;
	W.x[1]=V.x[1];
	W.x[2]=V.x[2]-2*V.x[3];	
        W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4 map1(Vector4 V) {
	Vector4 W=new Vector4();
	W.x[0]=V.x[0]-2*V.x[3];
	W.x[1]=V.x[1]-2*V.x[3];
	W.x[2]=V.x[2]-2*V.x[3];	
        W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4 map2(Vector4 V) {
	Vector4 W=new Vector4();
	W.x[0]=V.x[0]+2;
	W.x[1]=V.x[1];
	W.x[2]=V.x[2]+2*V.x[3];
	W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4 map3(Vector4 V) {
	Vector4 W=new Vector4();
	W.x[0]=V.x[0]+2*V.x[3];
	W.x[1]=V.x[1]+2*V.x[3];
	W.x[2]=V.x[2]+2*V.x[3];
 	W.x[3]=V.x[3];
	return(W);
    }






}



