import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors up to length 20*/


public class Vector {
    double[] x=new double[20];
    boolean done;
    int size;

    public Vector(){
	done=false;
    }


    /*constructors*/

    public Vector(double[] X) {
	size=X.length;
	for(int i=0;i<size;++i) x[i]=X[i];
	done=false;
    }

    public Vector(Vector V) {
	size=V.size;
	for(int i=0;i<size;++i) x[i]=V.x[i];
	done=V.done;
    }

    public Vector(int s) {
	this.size=s;
	for(int i=0;i<size;++i) this.x[i]=0;
	done=false;
    }


    public Vector(double a,double b,double c,double d) {
	double[] e={a,b,c,d};
	for(int i=0;i<4;++i) this.x[i]=e[i];
	this.size=4;
	done=false;
    }


    /**a random vector*/

    public static Vector random(int s) {
	Vector m=new Vector();
	m.size=s;
	for(int i=0;i<s;++i) {
	  m.x[i]=Math.random();
	}
	return(m);
    }

    /**A random vector with integer entries between -N and N*/

    public static Vector randomInt(int s,int N) {
	Vector m=random(s);
	for(int i=0;i<s;++i) {
	  m.x[i]=Math.floor(2*N*m.x[i]-N);
	}
	return(m);
    }
    /**This takes a projection from R4 to R3.  It works with the
       Vector4 class*/

    public static Vector project(int j,Vector4 V) {
	Vector W=new Vector(3);
	int count=0;
	for(int i=0;i<4;++i) {
	    if(i!=j) {
		W.x[count]=V.x[i];
		++count;
	    }
	}
	return W;
    }

    /**Here are some general routines**/


    public static Vector plus(Vector v1,Vector v2) {
	if(v1.size!=v2.size) return(null);
	Vector w=new Vector();
	for(int i=0;i<v1.size;++i) w.x[i]=v1.x[i]+v2.x[i];
	w.size=v1.size;
	return(w);
    }

    public static Vector minus(Vector v1,Vector v2) {
	if(v1.size!=v2.size) return(null);
	Vector w=new Vector();
	for(int i=0;i<v1.size;++i) w.x[i]=v1.x[i]-v2.x[i];
	w.size=v1.size;
	return(w);
    }

    public static Vector scale(double r,Vector v) {
	Vector w=new Vector();
	for(int i=0;i<v.size;++i) w.x[i]=r*v.x[i];
	w.size=v.size;
	return(w);
    }

    public static double dot(Vector v,Vector w) {
	int s=v.size;
	double d=0;
	for(int i=0;i<s;++i) d=d+v.x[i]*w.x[i];
	return(d);
    }

    public double norm() {
	return(Math.sqrt(dot(this,this)));
    }

    public double norm2() {
	double s=0;
	for(int i=0;i<size;++i) {
	    double t=Math.abs(x[i]);
	    if(s<t) s=t;
	}
	return(s);
    }



    public static double dist(Vector v,Vector w) {
	Vector x=minus(v,w);
	return(x.norm());
    }

    /**normalizes to make the first nonzero entry =1*/

    public static Vector normalize(Vector V) {
	for(int i=0;i<V.size;++i) {
	    if(Math.abs(V.x[i])>.000001) return scale(1/V.x[i],V);
	}
	return V;
    }


    /**This does Gram schmidt to a pair of vectors**/

    public static Vector[] ortho(Vector[] V) {
	Vector[] W=new Vector[2];
	W[0]=new Vector(V[0]);
	double x=W[0].norm();
	W[0]=scale(1/x,W[0]);
	W[1]=new Vector(V[1]);
	W[1]=minus(W[1],scale(dot(W[0],W[1]),W[0]));
	return(W);
    }


    /**This takes the minimum of two vectors*/

    public static Vector min(Vector V1,Vector V2) {
	if(V1.size!=V2.size) return(null);
	Vector W=new Vector(V1.size);
	for(int i=0;i<V1.size;++i) W.x[i]=Math.min(V1.x[i],V2.x[i]);
	return(W);
    }

    /**This takes the maximum of two vectors*/

    public static Vector max(Vector V1,Vector V2) {
	if(V1.size!=V2.size) return(null);
	Vector W=new Vector(V1.size);
	for(int i=0;i<V1.size;++i) W.x[i]=Math.max(V1.x[i],V2.x[i]);
	return(W);
    }



    public void print() {
	for(int i=0;i<size;++i)	{
	    double d=nearInt(x[i]);
	    System.out.print(d+" ");
	}
	System.out.println("");
    }


    public static double nearInt(double s) {
	for(int i=-1000;i<1000;++i) {
	    if(Math.abs(s-i)<.000000000001) return(i);
	}
	return(s);
    }


    public static double latticeDist(Vector V) {
	double max=0;
	for(int i=0;i<4;++i) {
	    double test=latticeDist(V.x[i]);
	    if(max<test) max=test;
	}
	return(max);
    }


    public static double latticeDist(double x) {
	double min=1;
	for(int i=-10;i<10;++i) {
	    double test=Math.abs(x-i);
	    if(test<min) min=test;
	}
	return(min);
    }



}




