

/************************************/
/**This is a horizontal  arrow slider.
   The values go from 0 to 1*/

function ArrowSlider(Z,COL1,COL2,min,max,step,S) {
   this.Z=Z;
   this.Z[0]=Z[0]+25;
   this.Z[2]=Z[2]-50;
   this.COL1=COL1; 
   this.COL2=COL2; 
   this.TEXT=true;
   this.min=min;
   this.max=max;
   this.step=step;
   this.S=S;
   this.on=1;
   this.press=0;
   this.WHOLE=true;
   this.ACTIVE=true;
   this.val=this.min;
   this.arrowSliderRender=arrowSliderRender;
   this.arrowSliderPress=arrowSliderPress;
   this.arrowSliderDetect=arrowSliderDetect;
}

/**detects points in slider*/

function arrowSliderPress(x,y) {
  if(this.ACTIVE==false) return;
   this.press=1;
   if(x<this.Z[0]-25) return;
   if(x>this.Z[0]+this.Z[2]+25) return;
   if(y>this.Z[1]+this.Z[3]) return;
   if(y<this.Z[1]) return;

   if(x<this.Z[0]-5) {
     if(this.WHOLE==true)  {
       this.val=this.val-this.step;
       if(this.val<this.min) this.val=this.min;
       return;
     }
     if(this.val==Math.floor(this.val)) --this.val;
     if(this.WHOLE==false)  this.val=Math.floor(this.val);
     if(this.val<this.min) this.val=this.min;
     return;
   }

   if(x>this.Z[0]+this.Z[2]+5) {
      if(this.WHOLE==true)  {
         this.val=this.val+this.step;
	 if(this.val>this.max) this.val=this.max;
         return;
     }

     if(this.WHOLE==false)  this.val=1+Math.floor(this.val);
     if(this.val>this.max) this.val=this.max;
     return;
   }

   var t=(x-this.Z[0])/this.Z[2];
   t=(1-t)*this.min+t*this.max;
   if(this.WHOLE==true) t=this.step*Math.floor(t/this.step);
   var temp=t;
   if(temp<this.min) temp=this.min;
   if(temp>this.max) temp=this.max;
   if(temp==undefined) return;
   this.val=temp;
}


function arrowSliderDetect(x,y) {
   this.press=1;
   if(x<this.Z[0]-35) return false;
   if(x>this.Z[0]+this.Z[2]+35) return false;
   if(y<this.Z[1]) return false;
   if(y>this.Z[1]+this.Z[3]) return false;
   return true;
}

/**Draws the slider*/

function arrowSliderRender(CANVAS) {
   var draw = CANVAS.getContext('2d'); 
   var z=this.Z;
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle = this.COL1;
   draw.fillRect(this.Z[0],this.Z[1],this.Z[2],this.Z[3]);
   var P=new Poly([z[0]-35,z[1]+z[3]/2,z[0]-5,z[1],z[0]-5,z[1]+z[3]],3,this.COL1);
   P.polyRenderUnscaled(CANVAS);
   P=new Poly([z[0]+z[2]+35,z[1]+z[3]/2,z[0]+z[2]+5,z[1],z[0]+z[2]+5,z[1]+z[3]],3,this.COL1);
   P.polyRenderUnscaled(CANVAS);
   draw.fillStyle = this.COL2;
   var x=(this.val-this.min)/(this.max-this.min);
   x=x*this.Z[2];
   draw.fillRect(this.Z[0],this.Z[1],x,this.Z[3]);
   draw.font = '14pt Helvetica'; 
   draw.fillStyle='#fff';
   var SS= this.S + " "+ this.val.toString();
   if(this.TEXT==true) draw.fillText(SS,this.Z[0]+5,this.Z[1]+this.Z[3]-5);
   draw.lineWidth=1;  
   draw.strokeStyle = '#fff';
   draw.strokeRect(this.Z[0],this.Z[1],this.Z[2],this.Z[3]);
}
