function ColorSelector(x,y) {
  this.X=x;
  this.Y=y;
  this.SHOW=new Button([x,y+460,30,40],'#f80',"");
  this.R=[];
  this.G=[];
  this.B=[];
  this.RR=[];
  this.GG=[];
  this.BB=[];
  this.r=15;
  this.g=15;
  this.b=0;
  for(var i=0;i<16;++i) {
    this.R[i]=new Button([x,y+    9*i,20,9],'#f40',"");
    this.G[i]=new Button([x,y+150+9*i,20,9],'#0f0',"");
    this.B[i]=new Button([x,y+300+9*i,20,9],'#04f',"");
    this.RR[i]=new Button([x+20,y+    9*i,10,9],'#fff',"");
    this.GG[i]=new Button([x+20,y+150+9*i,10,9],'#fff',"");
    this.BB[i]=new Button([x+20,y+300+9*i,10,9],'#fff',"");
  }

  this.colorSelectorRender=colorSelectorRender;
  this.colorSelectorProcess=colorSelectorProcess;
  this.getColor=getColor;
  this.detectPress=detectPress;

}

function colorSelectorRender(CAN) {
  for(var i=0;i<16;++i) {
    this.R[i].buttonRender(CAN);
    this.G[i].buttonRender(CAN);
    this.B[i].buttonRender(CAN);
  }
  this.RR[this.r].buttonRender(CAN);
  this.GG[this.g].buttonRender(CAN);
  this.BB[this.b].buttonRender(CAN);
  this.SHOW.COL=this.getColor();
  this.SHOW.buttonRender(CAN);
}

function colorSelectorProcess(x,y) {
  for(var i=0;i<16;++i) {
    if(this.R[i].buttonPress(x,y)==true) this.r=i;
    if(this.G[i].buttonPress(x,y)==true) this.g=i;
    if(this.B[i].buttonPress(x,y)==true) this.b=i;
  }
}


function getColor() {
  var rr=(this.r).toString(16);
  var gg=(this.g).toString(16);
  var bb=(this.b).toString(16);
  var s='#'+rr+gg+bb;
  return s;
}

function detectPress(x,y) {
  if(x<this.X) return false;
  if(x>this.X+30) return false;
  if(y<this.Y) return false;
  if(y>this.Y+500) return false;
  return true;
}
