



function Complex(x,y) {
  this.x=x;
  this.y=y;
  this.conjugate=conjugate;
  this.norm=norm;
  this.negate=negate;
  this.norm2=norm2;
  this.print=print;
}

function cxAdd(a,b) {
  var z=new Complex(a.x+b.x,a.y+b.y);
  return z;
}

function cxSub(a,b) {
  var z=new Complex(a.x-b.x,a.y-b.y);
  return z;
}

function cxTim(a,b) {
  var x=a.x*b.x-a.y*b.y;
  var y=a.x*b.y+a.y*b.x;
  var z=new Complex(x,y);
  return z;
}

function cxDiv(a,b) {
  return cxTim(a,cxInv(b));
}

function cxDist(a,b) {
  var c=cxSub(a,b);
  return c.norm();
}

function conjugate() {
  var z=new Complex(this.x,-this.y);
  return z;
}

function negate() {
  var x=new Complex(-this.x,-this.y);
  return x;
}

function norm() {
  return Math.sqrt(this.norm2());
}

function norm2() {
  var z=cxTim(this,this.conjugate());
  return z.x;
}

function cxInv(z) {
  var d=z.norm2();
  var w=new Complex(z.x/d,-z.y/d); 
  return w;
}

function cis(t) {
  var x=Math.cos(t);
  var y=Math.sin(t);
  var z=new Complex(x,y);
  return z;
}

function area(z0,z1,z2) {
  var w1=cxSub(z1,z0);
  var w2=cxSub(z2,z0);
  var w3=cxTim(w1,w2.conjugate());
  return .5*w3.y;
}

function isFolded(z0,z1,z2) {
  var d=area(z0,z1,z2);
  if(d*d>.0000001) return false;
  var d01=cxDist(z0,z1);
  var d02=cxDist(z0,z2);
  var d12=cxDist(z1,z2);
  if(d02<Math.max(d01,d12)) return true;
  return false;
}

function disjoint(z0,z1,w0,w1) {
  var a0=area(z0,z1,w0);
  var a1=area(z0,z1,w1);
  if(a0*a1>0) return true;
  a0=area(w0,w1,z0);
  a1=area(w0,w1,z1);
  if(a0*a1>0) return true;
  var mid=cxTim(new Complex(.5,0),cxAdd(z0,z1));
  var a0=cxDist(mid,z0);
  var a1=cxDist(mid,z1);
  var b0=cxDist(mid,w0);
  var b1=cxDist(mid,w1);
  if(Math.max(a0,a1)<Math.min(b0,b1)) return true;
  return false;
}



function print() {
  console.log("Complex "+this.x+"+"+this.y+ "I");
}

