



function Config(n) {
  this.X=[];
  this.Y=[];
  this.COLOR=[];
  this.n=n;
  for(var i=0;i<n;++i) {
    this.X[i]=-1+2*Math.random();
    this.Y[i]=-1+2*Math.random();
    this.COLOR[i]=colors1(i%30);
  }
  this.CELL=[];
  this.STRUCTURE=[];
  this.COLOR[-1]='#468';
  this.renderPoint=renderPoint;
  this.copy=copy;
  this.perturb=perturb;
  this.infinitySwap=infinitySwap;
  this.update0=update0;
  this.update=update;
  this.energy=energy;
  this.toVectors=toVectors;
  this.renderCells=renderCells;
  this.setCells=setCells;
  this.autoFit=autoFit;
  this.selectDisk=selectDisk;
  this.rotate=rotate;
  this.SELECT=0;
  this.CHANGE=false;
}


function copy() {
  var TEMP=new Config(this.n);
  for(var i=0;i<this.n;++i) {
    TEMP.X[i]=this.X[i];
    TEMP.Y[i]=this.Y[i];
    TEMP.COLOR[i]=this.COLOR[i];
  }
  TEMP.COLOR[-1]=this.COLOR[-1];
  TEMP.STRUCTURE=this.STRUCTURE;
  return TEMP;
}

function perturb(size) {
  var TEMP=this.copy();
  for(var i=0;i<this.n;++i) {
      TEMP.X[i]=TEMP.X[i]+2*size*Math.random()-size;
      TEMP.Y[i]=TEMP.Y[i]+2*size*Math.random()-size;
  }
  return TEMP;
}

function update0(exp,size) {
  var TEMP=this.perturb(size);
  var test1=this.energy(exp);
  var test2=TEMP.energy(exp);
  if(test1<test2) return this;
  return TEMP;
}

function update(exp) {
  var TEMP=this.copy();  
  var size=50*Math.random();
  size=Math.pow(.5,size);
  var TEMP=TEMP.update0(exp,size);
  return TEMP;
}

function energy(s) {
  var tot=0;
  var X=[];
  var y=[];
  var d=0;
  for(var i=0;i<this.n;++i) {
    for(var j=i+1;j<this.n;++j) {
      X=toSphere(this.X[i],this.Y[i]);
      Y=toSphere(this.X[j],this.Y[j]);
      d=vectorDist(X,Y);
      if(s<0) tot=tot-Math.pow(d,-s);
      if(s>0) tot=tot+Math.pow(d,-s);
      if(s==0) tot=tot-Math.log(d);
    }
  }
  for(var i=0;i<this.n;++i) { 
       X=toSphere(this.X[i],this.Y[i]);
       Y=new Vector([0,0,1]);
       d=vectorDist(X,Y);
       if(s<0) tot=tot-Math.pow(d,-s);
       if(s>0) tot=tot+Math.pow(d,-s);
       if(s==0) tot=tot-Math.log(d);
  }
  return tot;
}


function renderPoint(CAN) {
  for(var i=0;i<this.n;++i) { 
     drawDisk(CAN,this.X[i],this.Y[i],.02,'#fff');
  }

}


function renderCells(CAN) {

  var draw = CAN.getContext('2d');
  draw.fillStyle=this.COLOR[-1];
  draw.fillRect(400,60,640,640);
  this.setCells(); 
  if(FIT.on==1) this.autoFit();

  for(var i=0;i<this.n;++i) {
    try{this.CELL[i].polyRender(CAN,true);}
    catch(e){}
  } 
  draw.strokeStyle='#fff';
  draw.lineWidth=4;
  draw.strokeRect(400,60,640,640); 
  draw.lineWidth=1;
}


function setCells() {
  var Y=this.toVectors();
  for(var i=0;i<this.n;++i) {
     var X=Y[i];
     Y[i]=new Vector([0,0,1]);
     this.STRUCTURE[i]=delauneyIndices(X,Y,this.STRUCTURE[i]);
     if(this.STRUCTURE[i]!=undefined) {
        this.CELL[i]=cheapCell(X,Y,this.STRUCTURE[i]);
        Y[i]=X;
        this.CELL[i].COLOR=this.COLOR[i];
        
     }
  }
}

function toVectors() {
  var A=[];
  for(var i=0;i<this.n;++i) {
    A[i]=toSphere(this.X[i],this.Y[i]);
  }
  return A;
}



function autoFit() {
  var min0=+1000;
  var min1=+1000;
  var max0=-1000;
  var max1=-1000;

  for(var i=0;i<this.n;++i) {
    if(this.CELL[i]!=undefined) {
     for(var j=0;j<this.CELL[i].n;++j) {
        var x=this.CELL[i].Z[2*j+0];
        var y=this.CELL[i].Z[2*j+1];
        if(min0>x) min0=x;
        if(max0<x) max0=x;
        if(min1>y) min1=y;
        if(max1<y) max1=y;
     }
    }
  }
  var mid0=(min0+max0)/2;
  var mid1=(min1+max1)/2;
  var d0=mid0-min0;
  var d1=mid1-min1;
  var d=Math.max(d0,d1);
  doFit([mid0,mid1,d],[720,380,300]);
}


function infinitySwap(k) {
  if(k==this.n) return;
  var W=[];
  for(var i=0;i<this.n;++i) {
    W[i]=toSphere(this.X[i],this.Y[i]);
  } 
  var A=[];
  var INF=new Vector([0,0,1]);
  for(var i=0;i<this.n;++i) {
    if(i!=k) A[i]=swap(INF,W[k],W[i]);
    A[k]=W[k];
  }

  for(var i=0;i<this.n;++i) {
    var temp=fromSphere(A[i]);
    this.X[i]=temp[0];
    this.Y[i]=temp[1];
  }
 
  var c1=this.COLOR[k];
  var c2=this.COLOR[-1];
  this.COLOR[k]=c2;
  this.COLOR[-1]=c1;
}

function rotate(k) {
  var A=this.copy();
  var x=[];
  var y=[];
  var c=Math.cos(2*Math.PI/k);
  var s=Math.sin(2*Math.PI/k);
  for(var i=0;i<this.n;++i) {
    A.X[i]= c*this.X[i]+s*this.Y[i];
    A.Y[i]=-s*this.X[i]+c*this.Y[i];
  }
  return A;
}


function dist(x1,y1,x2,y2) {
  var t=(x1-x2)*(x1-x2)+(y1-y2)*(y1-y2);
  t=Math.sqrt(t);
  return t;
}


function selectDisk(x,y) {
  var min=10000;
  var index=0;
  for(var i=0;i<this.n;++i) { 
    var test=dist(x,y,this.X[i],this.Y[i]);
    if(test<min) {
      min=test;
      index=i;
    }
  }
  this.SELECT=index;
  return(index);
}



function colors1(i) {
  var COL=['#f60','#25f','#0d0','#f0f','#60f',
           '#f00','#00f','#0b0','#d0d','#40d',
           '#d00','#00d','#090','#b0b','#409',
           '#b00','#00b','#070','#909','#477',
           '#900','#58b','#060','#808','#f06',
           '#f80','#0bb','#0b5','#60a','#d04'];
 return COL[i];
}


