

function switchSlice(x,y) {
  for(var j=0;j<3;++j) {
    if(SWITCH[j].buttonPress(x,y)==true) forceSwitch(j);
  }
}

function forceSwitch(k) {
    SWITCH[0].on=0;
    SWITCH[1].on=0;
    SWITCH[2].on=0;
    SWITCH[k].on=1;
    SLICE=k;
}

function switchBig(x,y) {
  for(var i=0;i<2;++i) {
    if(BIG[i].buttonPress(x,y)==true) {
      CHOICE=i;
      BIG[i].on=1;
      BIG[1-i].on=0;
    }
  }
}


function setAnimation(x,y) {
  if(ANIMATE.buttonPress(x,y)==false) return;
  ANIMATE.buttonToggle(x,y);
   if(ANIMATE.on==1) startWorker();
   if(ANIMATE.on==0) stopWorker();
}



function sendParameter() {
  var x=RE.getRational();
  if(x==false) return; 
  x=reduce(x);
  console.log(x[0]+" "+x[1]);
  if((x[0]*x[1])%2==1) return;
  if(x[0]>=x[1]) return;
  PLAID=new PlaidModel(x);
  PLAID.plaidCompute();
  SURFACE=new Surface();
  ZVAL.max=PLAID.p+PLAID.q-1;
  ZVAL.val=0;
  YVAL.max=PLAID.p+PLAID.q-1;
  YVAL.val=1;
  XVAL.max=PLAID.p+PLAID.q-1;
  XVAL.val=1;
  LANDSCAPE.COUNT=0;
  LANDSCAPE.CURRENT=-1;
}

function setLocation(x,y) {
  if(BLOCK.on==0) {
    if((x>500)||(y>500)) return;
    if((x<30)||(y<30)) return;
  }
  if(BLOCK.on==1) {
    if((x>770)||(y>770)) return;
    if((x<30)||(y<30)) return;
  }

  var r=RE.getRational();
  var s=PLAID.plaidTransform(x,y);
  s[0]=Math.floor(s[0]);
  s[1]=Math.floor(s[1]);

  var n=PLAID.n;
  if(SLICE==0) {
    XVAL.val=s[0];
    YVAL.val=s[1];
  }

  if(SLICE==1) {
    XVAL.val=s[0];
    ZVAL.val=s[1];
  }

  if(SLICE==2) {
    YVAL.val=s[0];
    ZVAL.val=s[1];
  }

  ZVAL.val=(ZVAL.val+PLAID.getOffset())%PLAID.n;
 
  TILE=new Tile([XVAL.val,YVAL.val,ZVAL.val]);
  TILE.assemble();
  NAV.navigatorAdapt(TILE);
}

function setEye(x,y) {
  TILE.EYE[0]=.5+(750-x)/350;
  TILE.EYE[1]=.5+(250-y)/350;
}


function doMouseDown(e) {
   DRAG=true;
   var x=e.pageX;
   var y=e.pageY;
   unTransform(x,y);
   RE.rationalEntryPress(x,y);
   ZVAL.arrowSliderPress(x,y);
   YVAL.arrowSliderPress(x,y);
   XVAL.arrowSliderPress(x,y);
   NAV.navigatorProcess(x,y);
   BLOCK.buttonToggle(x,y);  
   OFFSET.buttonToggle(x,y);   
   CUBE.buttonToggle(x,y);     
   SWAP.buttonToggle(x,y); 
   SLICER.sliceProcess(x,y); 
   switchSlice(x,y);
   if(SEND.buttonPress(x,y)==true) sendParameter();
   setLocation(x,y);
   PLAID.squareReset();
   setAnimation(x,y);
   switchBig(x,y);
   COLOR.colorSelectorProcess(x,y);
   LANDSCAPE.landscapeProcess(x,y);
   TEMP.buttonToggle(x,y);

   repaint();
   repaintMiddle(); 
   repaintBottom();

}

function doMouseUp() { 
   DRAG=false;
}

function doMouseMove(e) { 
   var x=e.pageX;
   var y=e.pageY; 
   CLICK[0]=x;
   CLICK[1]=y;
   unTransform(x,y); 
   var b=new Button([500,30,470,470],'#fff',"");
   if(DRAG==true) {
       if(b.buttonPress(x,y)==true) setEye(x,y);
       SLICER.sliceProcess(x,y);
       repaint();
   }

   repaintMiddle(); 
   repaintBottom();
}

function doKeyDown(e) {
  var test=RE.acceptKey(e,CLICK[0],CLICK[1]);
  doKeyCommands(e);
  doKeyScaling(e);
  if(test==false) repaint();
  if(test==false) repaintMiddle();
   repaintBottom();

}

function doKeyCommands(e) {
   var letter=e.keyCode-64;
   if(letter==24) forceSwitch(2);
   if(letter==25) forceSwitch(1);
   if(letter==26) forceSwitch(0); 

   if(letter==17) {
     if(SLICE==0) ++ZVAL.val;
     if(SLICE==1) ++YVAL.val;
     if(SLICE==2) ++XVAL.val;
   }

   if(letter==23) {
     if(SLICE==0) --ZVAL.val;
     if(SLICE==1) --YVAL.val;
     if(SLICE==2) --XVAL.val;
   }

   if(letter==1) {
     if(SLICE==2) XVAL.val=PLAID.getMagicSlice();
     if(SLICE==1) YVAL.val=PLAID.getMagicSlice();
   }

   if(ZVAL.val>ZVAL.max) ZVAL.val=0;
   if(YVAL.val>ZVAL.max) YVAL.val=0;
   if(XVAL.val>ZVAL.max) XVAL.val=0;
   if(ZVAL.val<0) ZVAL.val=ZVAL.max;
   if(YVAL.val<0) YVAL.val=YVAL.max;
   if(XVAL.val<0) XVAL.val=XVAL.max;
   PLAID.squareReset();

 
}
