
function determineInfo(x,y) { 

  INFO=2;
  if(COLOR.detectPress(x,y)==true) INFO=12;
  if(BLOCK.buttonPress(x,y)==true) INFO=8;
  if(BIG[0].buttonPress(x,y)==true) INFO=8;
  if(BIG[1].buttonPress(x,y)==true) INFO=8; 
  if(ANIMATE.buttonPress(x,y)==true) INFO=9; 
  if(OFFSET.buttonPress(x,y)==true) INFO=15; 
  if(TEMP.buttonPress(x,y)==true) INFO=15;
  if(CUBE.buttonPress(x,y)==true) INFO=16;
  if(LANDSCAPE.GO.buttonPress(x,y)==true) INFO=4;
  if(LANDSCAPE.RECOLOR.buttonPress(x,y)==true) INFO=13;
  if(LANDSCAPE.OMIT.buttonPress(x,y)==true) INFO=13; 
  if(NAV.EXTEND.buttonPress(x,y)==true) INFO=7;

  var temp=new Button([0,970,740,30],'#fff',"");
  if(temp.buttonPress(x,y)==true) INFO=6; 
  temp=new Button([30,30,470,470],'#fff',"");
  if(temp.buttonPress(x,y)==true) INFO=3;  
  temp=new Button([500,30,470,470],'#fff',""); 
  if((CUBE.on==0)&&(temp.buttonPress(x,y)==true)) INFO=10; 
  if((CUBE.on==1)&&(temp.buttonPress(x,y))==true) INFO=5; 
  temp=new Button([970,30,30,220],'#fff',""); 
  if(temp.buttonPress(x,y)==true) INFO=7; 
  temp=new Button([30,770,710,30],'#fff',"");  
  if(temp.buttonPress(x,y)==true) INFO=17; 
  temp=new Button([740,770,130,30],'#fff',"");  
  if(temp.buttonPress(x,y)==true) INFO=1; 
}

function drawInfo(x,y) {
  determineInfo(x,y);
  if(INFO==1) drawSendInfo();
  if(INFO==2) drawInfoInfo();
  if(INFO==3) drawPlaidModelInfo();
  if(INFO==4) drawSurfaceInfo();
  if(INFO==5) drawPieceInfo();
  if(INFO==6) drawSwitchInfo();
  if(INFO==7) drawExtendInfo();
  if(INFO==8) drawBlockInfo();
  if(INFO==9) drawAnimateInfo();
  if(INFO==10) drawSurfaceWindowInfo();
  if(INFO==11) drawTitleInfo();
  if(INFO==12) drawColorInfo();
  if(INFO==13) drawRecolorInfo();
  if(INFO==14) drawBigInfo();
  if(INFO==15) drawOffsetInfo();
  if(INFO==16) drawCubeInfo();
  if(INFO==17) drawSliceInfo();

}



function drawSendInfo() {
  var S="Once you enter a rational number into the field, you press send to send it to the computer. The computer wil then draw the plaid model with respect to that parameter.  Note that the program only works for rationals p/q in (0,1) with pq even.";


  var S2="Key commands for the rational entry field: (r) produces a random parameter, (a) reduces a rational to lowest terms, and (q) sets the parameter to 1/2.  You might want to set the parameter to 1/2 in case you have selected a very large parameter and the program is taking a long time to draw things. ";

  setTextBox([30,500,940,120],CANVAS,S2,'#900',1);
  setTextBox([30,620,940,150],CANVAS,S,'#345',21);
}

function drawInfoInfo() {
  var S="This program illustrates the plaid model. The plaid model is a combinatorial construction which produces, for each rational number p/q in (0,1), with pq even, a collection of embedded polyhedral surfaces contained in an NxNxN cube.  Here N=p+q. The complexity of these surfaces grows with N.  The surfaces are made from an NxNxN array of simple pieces, inside unit cubes, which are connected together.  This program draws the surfaces for smallish parameters and lets you nagivate them in various ways. Probably it is best to take N<40.  Otherwise the program is too slow. If you move the mouse over other parts of the program, you can read in this window what they do."
  setTextBox([30,500,940,270],CANVAS,S,'#066',2);
}

function drawPlaidModelInfo() {
  var S="This window displays the (unoriented) plaid model. The domain is a cube. The curves you see are the slices of the plaid model surfaces in that direction.  If you click on a square, and have the CUBE button on, the top right window shows the cube which has that square as one of its faces. (The cube is such that the selected vertex is the vertex closest to the origin.) The green Z slices correspond to a combinatorial model for the special orbits of outer billiards on kites.  The red and blue slices correspond to the orbits of a dynamical system that is related to P. Hooper's Truchet tile system. The plaid model is a kind of marriage of outer billiards on kites and the Truchet tile system.";

  var S2="Key commands for the plaid model window:  Press (x), (y), (z) to change the slice direction.  Press (q), (w) to change the slice.  When the slice is X or Y, press (a) to bring up the slice of critical capacity. This is the slice that is specially related to Hooper's Truchet tile system.";
  setTextBox([30,500,940,120],CANVAS,S2,'#345',23);
  setTextBox([30,620,940,150],CANVAS,S,'#009',3);
}


function drawCubeInfo() {
  var S="The upper right window has a double purpose: It displays the plaid model surfaces, and it also displays individual cubical tiles.  This button toggles which of the two things are shown. When the button is colored, the cubical tile is shown. When the button is colored red, or when if no surface is plotted, the currently selected cubical tile is drawn.  When the button is black and at least one surface has been plotted, this window shows the currently selected surface.";
  setTextBox([30,500,940,270],CANVAS,S,'#066',16);
}

function drawSliceInfo() {
  var S="These arrow keys ley you select the various slices of the model.  You can either click on the bars or on the arrows at the end to move the slices.  Initially the program shows the Z-slices.  (By Z-slice, we mean the XY coordinate slices.)  You can use the buttons labeled X,Y,Z to change the display so that it shows the other coordinate slices.  Here X stands for YZ and Y stands or XZ and (again) Z stands for XY.";

  setTextBox([30,500,940,270],CANVAS,S,'#066',24);
}



function drawSurfaceInfo() {
  var S="When you press the crucial SURFACE button, the program computes the surface containing the piece you have selected, then adds the surface to a list which is indexed by the round disks beneath the SURFACE button. You can access already computed surfaces by clicking on these little disks. The program computes the Euler characteristic of the surface and tries to draw it in the plane.  When the surface is a sphere, the picture works out nicely.  The program also draws the slices of the surface in the cube. Here is a discussion of the planar representation of the surface: In all cases, we move a vertex to infinity in the extended plane, fix 4 other vertices ar the four 4th roots of unity, and then try to map the surface harmonically into the plane.  This amounts to finding two independent harmonic functions on the set of vertices.";


  setTextBox([30,500,940,270],CANVAS,S,'#048',4);
}


function drawPieceInfo() {
  var S="This window has a double purpose.  When the CUBE button is on, as it is now, this window draws a cubical tile of the plaid model. For the parameter p/q, we set N=p+q and then consider a union of embedded surfaces made by connecting together an NxNxN grid of unit cubes.  Each unit cube has a small piece of the surfaces in it. These small cubes as the elementary tiles in the model.  If you select a nontrivial component of the plaid model, this region will show the corresponding unit cube.  For better viewing, you can drag the mouse over this region and slightly change the perspective with which you are viewing the cube.  Once you have selected a tile, you can use the use the little round buttons and the E keys to navigate through the surface.  Move the mouse over these buttons and then read here about what they do.";

  var S2="Key commands for the graph window:  The letter keys zoom into the picture.  The number keys zoom out of the picture.  The space bar resets the zoom and thereby centers the picture.  Note: if there is no surface computed, these commands will not have a visible effect.";

  setTextBox([30,500,940,120],CANVAS,S2,'#345',25);
  setTextBox([30,620,940,150],CANVAS,S,'#080',5);
}


function drawSwitchInfo() {
  var S="For each rational parameter, the plaid model produces a family of surfaces embedded in a cube. You can see slices of these surfaces in the cube in any of the 3 coordinate directions. These buttons allow you to switch the slice direction.  Once you have chosen a slice direction, you can use the arrow keys to move through the different slices in the same direction. You can also use some key commands for this.  Press keys (x), (y), (z), to change slice directions.  Press keys (q) and (w) to change the slice.  Press key (a) to get the slice of capacity 2p.  This is a special slice.";

  setTextBox([30,500,940,270],CANVAS,S,'#080',6);
}


function drawExtendInfo() {
  var S="This region of the program has some special controls which appear when you have selected a nontrivial cubical tile in the plaid model. The E button and the collection of small round buttons gives you a way to navigate through the plaid surface.  The plaid model surface intersects each cube in a union of 1 or 2 polygons.  The display shows these polygons for the selected cube, and also shows a distinguished edge. Click on the round colored buttons to change the distinguished edge.  The E button moves to the adjacent cube across the distinguished edge, and keeps the distinguished edge the same. This map is an involution.  Using the round buttons and the Ey buttons in combination with each other, you can eventually explore the whole surface.  Of course, given that these surfaces often have thousands of little pieces, you would not generally be able to explore the whole surface without putting in a tremendous effort.";

  setTextBox([30,500,940,270],CANVAS,S,'#50a',7);
}

function drawBlockInfo() {
  var S="When you turn on this option, the upper right window is resized so that it fills the entire screen and the most of the other features of the program are hidden.  The purpose of this option is to let you explore the surface in a larger window.  The L and R buttons toggle the display of this window. You can either see the plaid model (L) or the plaid surface (R). In R-mode, you need to select a component of the plaid model and press the SURFACE button. Otherwise, you will just get a blank screen.  In R-mode, you can use the space bar to recenter the surface in the larger window.";

  setTextBox([30,500,940,270],CANVAS,S,'#b0b',8);
}

function drawAnimateInfo() {
  var S="Once you have selected a surface from the plaid model, the programs tries to draw its 1-skeleton in the plane using a harmonic map.  This amounts to fixing several outside vertices and embedding the graph so that each other vertex is the center of mass of its neighbors.  If you press the EVOLVE button the computer will start computing this harmonic embedding using a classic relaxation method.  After a while you should turn off the evolution, because it seems to use a lot of computer resources..";

  setTextBox([30,500,940,270],CANVAS,S,'#05f',9);
}


function drawSurfaceWindowInfo() {
  var S="This window has a double purpose.  When the CUBE button is off, as it is now, this window displays the 1-skeleta of the plaid model surfaces. In order to see anything in this window you first have to select a nontrivial component of the plaid model and then you have to press that SURFACE button. If the surface is a sphere, you can see a nice picture in this window. If the surface is not a sphere (i.e. has higher genus) you will not see a very nice picture.  In the sphere case, you can evolve the picture towards its final form by turning on the ANIMATE button. You can zoom in and out of the picture using the letter and number keys.  You can recenter the picture using the space bar.  If you want to see a larger picture, you can press the FULL key.";

 var S2="Key commands for the graph window:  The letter keys zoom into the picture.  The number keys zoom out of the picture.  The space bar resets the zoom and thereby centers the picture.  Also, you can make this window full-screen by clicking the R button and then pressing the FULL button.";

  setTextBox([30,500,940,120],CANVAS,S2,'#b00',27);
  setTextBox([30,620,940,150],CANVAS,S,'#345',10);
}




function drawTitleInfo() {
  var S="This program is a companion to my monograph, also called The Plaid Model.  There is also a much more extensive Java program that goes with the monograph, but that program does not run online. This program goes further than the java program in one respect: It draws the surfaces associated to the plaid model.  At the moment this program is still kind of a toy. It doesn't really do heavy computations that well, and so it runs very slowly when you try to enter a large parameter. I hope to beef up the program in the coming months.";

  setTextBox([30,500,940,270],CANVAS,S,'#058',11);
}


function drawBigInfo() {
  var S="The FULL button allows you to make one of the top two windows into a full-screen display.  These two buttons toggle which of the two windows becomes enlarged when you press the FULL button.  When you press the L button, you select the top left window. When you press the R button, you select the top right window.  The top right window is scalable, and you should use the space bar to center the picture.  The top left window is not scalable.";
  setTextBox([30,500,940,270],CANVAS,S,'#090',14);
}


function drawOffsetInfo() {
  var S="One can interpret the domain for the plaid model as a square torus rather than a cube.  When we make this interpretation, it makes it possible for us to change the center of the picture.  The OFFSET button makes a different and more symmetric choice for the center.  This choice only effects the X (blue) and Y (red) slices.  For intstance, in the blue case, the canonical center reveals the 8-fold dihedral symmetry of the blue slices.  For the blue slices, I have not quite figured out the formula for the canonical center as a function of the slice. I have so far figured out that for each rational parameter there seems to be two possible formulas, at least one of which works for that parameter.  The small button labeled P lets you toggle between the two choices. So, if the picture does not quite look right, push the P button to fix it. ";

  setTextBox([30,500,940,270],CANVAS,S,'#04f',15);
}




function drawColorInfo() {
  var S="This is the color selector. You specify the color by selecting values on each of the 3 rows of boxes. These values correspond to the red, green, and blue components of the color.  The rectangle at the bottom of the RGB sliders displays the current color. When new surfaces are computed (by pressing the SURFACE button) the current color is assigned to the newly computed surfaces.  The surfaces are plotted in the plaid model with their assigned colors.";

  setTextBox([30,500,940,270],CANVAS,S,'#678',12);
}



function drawRecolorInfo() {
  var S="Once you have plotted at least one surface, you have several options for changing the plots. Using the RECOLOR button, you can recolor any of the surfaces you have plotted.  Using the DELETE button, you can delete any of the surfaces you have plotted.  You select the surface you want to modify by clicking on the colored disks.";
  setTextBox([30,500,940,270],CANVAS,S,'#678',13);
}
