

/**window opens with this routine*/
function init() { 
  var s = document.getElementById("picture"); 
  s.contentEditable=true;
  s.addEventListener('mousedown',doMouseDown,false);
  s.addEventListener('mouseup',doMouseUp,false);
  s.addEventListener('mousemove',doMouseMove,false); 
  s.addEventListener('keydown',doKeyDown,true); 
  startWorker();
  stopWorker();
  repaintBottom();
  repaintMiddle();
  repaint();
}

var CANVAS = document.getElementById("picture"); 
var INFO=0;
var WRITER=new Writer();
var RE=new RationalEntry([740,770,70,30],['#000','#fff','#456','#ff0','#678','#236'])
var SEND=new Button([810,770,60,30],'#f00',"send");
var OFFSET=new Button([410,0,60,30],'#05f',"offset");OFFSET.on=1;
var TEMP=new Button([470,0,30,30],'#00f',"p");TEMP.on=1;

var ZVAL=new ArrowSlider([550,770,180,25],'#0b0','#080',0,10,1,"Z=");
var YVAL=new ArrowSlider([300,770,180,25],'#f30','#c00',0,10,1,"Y=");
var XVAL=new ArrowSlider([50,770,180,25],'#05f','#00d',0,10,1,"X=");

var PLAID=new PlaidModel([2,9]);
PLAID.plaidCompute(); 
var SURFACE=new Surface();
var LANDSCAPE=new Landscape(0,0);
var ANIMATE=new Button([930,0,70,30],'#f00',"evolve");ANIMATE.on=0;
var COLOR=new ColorSelector(970,300);
var CUBE=new Button([860,0,70,30],'#f00',"cube");ANIMATE.on=0;
var SWAP=new Button([800,0,60,30],'#0c0',"alt");SWAP.on=0;
var SLICER=new Slicer(500,0);
SLICER.sliceX(0);

var SWITCH0=new Button([500,770,30,30],'#0b0',"Z");SWITCH0.on=1;
var SWITCH1=new Button([250,770,30,30],'#f30',"Y");SWITCH1.on=0;
var SWITCH2=new Button([0,770,30,30],'#05f',"X");SWITCH2.on=0;
var SWITCH=[SWITCH0,SWITCH1,SWITCH2];
var SLICE=0;


var BLOCK=new Button([870,770,50,30],'#50a',"full");BLOCK.on=0;
var BIG0=new Button([920,770,25,30],'#090',"L");BIG0.on=1;
var BIG1=new Button([945,770,25,30],'#090',"R");BIG1.on=0;
var BIG=[BIG0,BIG1];
var CHOICE=0;

var INFO=0;

var SQUARE=[0,0,0];
var TILE=new Tile([0,0,0]);
var NAV=new Navigator();
NAV.navigatorInit();



/**animation*/

var WORKER
var RUN=false;
function startWorker() {
  if(RUN==true) return;
  RUN=true;
  WORKER = new Worker("Counter.js");
  WORKER.onmessage = function(event) { 
    var c=LANDSCAPE.CURRENT;
    if(c!=-1)
    LANDSCAPE.S[c].geomUpdate(50);
    repaint();
    repaintMiddle();
    repaintBottom();
    WORKER.postMessage(0);
  }
}

function stopWorker() {
  RUN=false;
    WORKER.terminate();
}



