
function Landscape(x,y) {
  this.X=x;
  this.Y=y;
  this.COUNT=0;
  this.CURRENT=-1;
  this.S=[];
  this.COLOR=[];
  this.R=[];
  var count=0;
  var i=0;
  var j=0;
  while(count<40) {
    this.R[count]=new Button([7+x,y+40+20*i,15,15],'#fff',"");
    ++i;
    ++count;
  }
  this.GO=new Button([x,y,80,30],'#058',"surface");
  this.RECOLOR=new Button([x+160,y,80,30],'#678',"recolor");
  this.OMIT=new Button([x+80,y,80,30],'#678',"delete");
  this.landscapeRenderSurface=landscapeRenderSurface;
  this.landscapeRenderGraph=landscapeRenderGraph;
  this.landscapeRenderGraphStats=landscapeRenderGraphStats;
  this.landscapeRenderControls=landscapeRenderControls;
  this.newSurface=newSurface;
  this.landscapeProcess=landscapeProcess;
  this.selectSurface=selectSurface;
  this.makeNewSurface=makeNewSurface;
  this.deleteSurface=deleteSurface;
}


function landscapeRenderSurface(CAN) {
  for(var i=0;i<this.COUNT;++i) {
    this.S[i].surfaceRender(CAN,this.COLOR[i]);
  }
}


function landscapeRenderGraph(CAN) {
  if(this.CURRENT==-1) return;
  var draw = CAN.getContext('2d'); 
  draw.fillStyle='#000';
  draw.setTransform(1,0,0,1,0,0);
  this.S[this.CURRENT].graphRender(CANVAS);
}

function landscapeRenderGraphStats(CAN) {
  if(this.CURRENT==-1) return;
  var draw = CAN.getContext('2d'); 
  var M=this.S[this.CURRENT].topology();
  draw.setTransform(1,0,0,1,0,0);
  draw.fillStyle='#fff';
  draw.font = '13pt Helvetica';  
  draw.fillText(M,510,20);
}



function landscapeRenderControls(CAN) {
  for(var i=0;i<this.COUNT;++i) {
    this.R[i].buttonRenderCircle(CAN,this.COLOR[i]);
  }
  this.GO.buttonRender(CAN);
  this.OMIT.buttonRender(CAN);
  this.RECOLOR.buttonRender(CAN);
}


function deleteSurface() {
  if(this.CURRENT==-1) return;
  for(var i=this.CURRENT;i<this.COUNT-1;++i) {
    this.S[i]=this.S[i+1].surfaceCopy();
    this.COLOR[i]=this.COLOR[i+1];
  }
  --this.COUNT;
  --this.CURRENT;
}




function newSurface(s) {
   var count=this.COUNT;
   for(var i=0;i<count;++i) this.R[i].on=0;
   this.S[count]=SURFACE.surfaceCopy();
   this.COLOR[count]=COLOR.getColor();
   this.CURRENT=this.COUNT;
   this.R[count].on=1;
   ++this.COUNT;
}

function landscapeProcess(x,y) {
  this.selectSurface(x,y);
  if(this.GO.buttonPress(x,y)==true) this.makeNewSurface();
  if(this.OMIT.buttonPress(x,y)==true) this.deleteSurface();
  if(this.RECOLOR.buttonPress(x,y)==true) {
    if(this.CURRENT!=-1) {
      this.COLOR[this.CURRENT]=COLOR.getColor();
    }
  }
}


function selectSurface(x,y) {
  var index=-1;
  for(var i=0;i<this.COUNT;++i) {
    if(this.R[i].buttonPress(x,y)==true) index=i;
  }
  if(index==-1) return;
  for(var i=0;i<this.COUNT;++i) this.R[i].on=0;
  this.R[index].on=1;
  this.CURRENT=index;

}

function makeNewSurface() {
  CUBE.on=0;
   var xx=[TILE.x[0],TILE.x[1],TILE.x[2],TILE.FOCUS];
   var n=SURFACE.cubeToLineArray(xx);
   SURFACE.doBFS(n);
   SURFACE.surfaceGraph();
   this.MESSAGE=SURFACE.topology();
   SURFACE.geomInit();
   SURFACE.geomUpdate(100);
   this.newSurface(SURFACE);
}

