
function Navigator() {
  this.EMPTY=true;
  this.navigatorInit=navigatorInit;
  this.navigatorRender=navigatorRender;
  this.navigatorInit=navigatorInit;
  this.navigatorProcess=navigatorProcess;
  this.navigatorNext=navigatorNext;
  this.navigatorFreeChoice=navigatorFreeChoice;
  this.navigatorAdapt=navigatorAdapt;
  this.INDEX=[0,0];
  this.EXTEND=new Button([970,30,30,30],'#50b',"E");
  this.MESSAGE=["","","","",""];
}


function navigatorInit() {
var C0=[];
var C1=[];
for(var i=0;i<8;++i) {
  C0[i]=new Button([0,0,0,0],'#ff0',"");
  C1[i]=new Button([0,0,0,0],'#ff0',"");
  C0[i].on=0;
  C1[i].on=0;
 }
 C0[0].on=1;
 this.C=[C0,C1];
 this.T=new Tile([0,0,0]);
}

function navigatorAdapt(T) {  
  this.navigatorInit();
  this.T=T;
  if(T.VCOUNT==0) return;
  var L0=T.F[0].length;
  for(var i=0;i<L0;++i) {
    var on=this.C[0][i].on;
    this.C[0][i]=new Button([975,70+23*i,20,20],'#ff0',"");
    this.C[0][i].on=on;
  }

  var L1=0;
  try{L1=T.F[1].length;}
  catch(e){}

  for(var i=0;i<L1;++i) {
    var t=2*i*Math.PI/L1;
    var on=this.C[1][i].on;
    this.C[1][i]=new Button([975,180+23*i,20,20],'#ff0',""); 
    this.C[1][i].on=on;
  }

  var index=T.focusToIndex(T.FOCUS);

  for(var i=0;i<8;++i) {
    this.C[0][i].on=0;
    this.C[1][i].on=0;
  }
  this.C[index[0]][index[1]].on=1;

}

function navigatorProcess(x,y) {
  if(this.T.VCOUNT==0) return;

  if(this.EXTEND.buttonPress(x,y)==true) {
       this.navigatorNext();
  }
  this.navigatorFreeChoice(x,y);
}



function navigatorFreeChoice(x,y) {
  var index=[-1,-1];
  for(var i=0;i<8;++i) {
    if(this.C[0][i].buttonPress(x,y)==true) index=[0,i];
    if(this.C[1][i].buttonPress(x,y)==true) index=[1,i];
  }
  if(index[0]==-1) return;
  TILE.FOCUS=TILE.indexToFocus(index);
  this.navigatorAdapt(TILE);
}


function navigatorNext() { 
   setSlices(TILE);
   var f=SURFACE.tileExtend([TILE.x[0],TILE.x[1],TILE.x[2],TILE.FOCUS]);
   TILE=SURFACE.T[f[0]][f[1]][f[2]];
   TILE.FOCUS=f[3];
   this.navigatorAdapt(TILE);
}

function setSlices(T) {
  var xx=[]; 
  var test=T.faceVector();
  for(var i=0;i<3;++i) {
    xx[i]=(T.x[i]+test[i]+PLAID.n)%PLAID.n;
  }
  XVAL.val=xx[0];
  YVAL.val=xx[1];
  ZVAL.val=xx[2];
}

function navigatorRender(CAN) { 
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);

  if(this.T.VCOUNT==0) return;
  var cols=['#04f','#f40','#0a0'];
  this.EXTEND.buttonRender(CAN);

  for(var i=0;i<this.T.F[0].length;++i) {
    var test=this.T.indexToFocus([0,i]);
    var col=cols[this.T.E[test][2]];
    this.C[0][i].buttonRenderCircle(CAN,col);
  }

  if(this.T.F.length==1) return;
  for(var i=0;i<this.T.F[1].length;++i) {
     var test=this.T.indexToFocus([1,i]);
     var col=cols[this.T.E[test][2]];
     this.C[1][i].buttonRenderCircle(CAN,col);
  }
}
