
function PlaidModel(x) {
  this.p=x[0];
  this.q=x[1];
  this.n=x[0]+x[1];
  this.PATH=[];
  this.plaidCompute=plaidCompute;
  this.plaidRender=plaidRender;
  this.gridRender=gridRender;
  this.plaidTransform=plaidTransform;
  this.squareCompute=squareCompute;
  this.computePoints0=computePoints0;
  this.computePoints1=computePoints1;
  this.computePoints2=computePoints2;
  this.goodHorizontal=goodHorizontal;
  this.computePoints=computePoints;
  this.squareRender0=squareRender0;
  this.squareReset=squareReset;
  this.squareRender=squareRender;
  this.getMagicSlice=getMagicSlice;
  this.getOffset=getOffset;
}

function getMagicSlice() {
  for(var i=0;i<this.n;++i) {
    if(this.CAP[i]==2*this.p) return i;
  }
  return 0;
}


function plaidCompute() {
  var s=470/(this.p+this.q);
  this.TR=[s,0,0,s,30,30];
  this.TR2=[1.57*s,0,0,1.57*s,30,30];
  this.CAP=capacitySequence(this.p,this.q);
  this.MAS=massSequence(this.p,this.q);
  this.HOR=horizontalArray(this.p,this.q);
  this.squareReset();
}

function plaidRender(CAN) {
  this.gridRender(CAN);
  this.squareRender(CAN,SLICE);
}


function gridRender(CAN) {
   var draw = CAN.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle='#000';
   draw.lineWidth=0;
   if(BLOCK.on==0) draw.fillRect(0,0,500,500);
   if(BLOCK.on==1) draw.fillRect(0,0,1000,800);
   var a=this.TR;
   if(BLOCK.on==1) a=this.TR2;

   draw.setTransform(a[0],a[1],a[2],a[3],a[4],a[5]);
   draw.lineWidth=1/a[0];
   draw.strokeStyle='#235';
   for(var i=0;i<=this.n;++i) {
     for(var j=0;j<=this.n;++j) {
        var p=new Path2D();
        p.moveTo(j,0);
        p.lineTo(j,this.n);
        p.moveTo(0,j);
        p.lineTo(this.n,j);
        draw.stroke(p);
     }
   }
}

function squareRender(CAN,choice) {
  for(var i=0;i<this.n;++i) {
    for(var j=0;j<this.n;++j) {
      this.squareRender0(CAN,choice,i,j);
    }
  }
}


function squareRender0(CAN,choice,i,j) {
   var draw = CAN.getContext('2d'); 
   draw.fillStyle='#f00';
   draw.strokeStyle='#06f';
   if(choice==1) draw.strokeStyle='#f30';
   if(choice==0) draw.strokeStyle='#0b0';

   var a=this.TR;
   if(BLOCK.on==1) a=this.TR2;

   draw.setTransform(a[0],a[1],a[2],a[3],a[4],a[5]);  
   draw.lineWidth=3/a[0];

   var LOC=ZVAL.val;
   if(choice==1) LOC=YVAL.val;
   if(choice==2) LOC=XVAL.val;

   if(this.PATH[i][j]==0) {
     var jj=j+this.getOffset();
     jj=jj%this.n;
     var SQ=this.squareCompute(choice,LOC,i,jj);
     this.PATH[i][j]=pathConnector(SQ[0],SQ[1],SQ[2],SQ[3],i,j);
   }
   draw.stroke(this.PATH[i][j]);
}

function squareReset() {
  var n=this.n;
  for(var i=0;i<n;++i) {
    this.PATH[i]=[];
    for(var j=0;j<n;++j) {
      this.PATH[i][j]=0;
    }
  }
}




function squareCompute(choice,LOC,i,j) {
   var z0=new Complex(i+1,j+0);
   var z1=new Complex(i+1,j+1);
   var z2=new Complex(i+0,j+1);
   var z3=new Complex(i+0,j+0);
   var E=this.computePoints(choice,LOC,[z0,z1]);
   var S=this.computePoints(choice,LOC,[z2,z1]);
   var W=this.computePoints(choice,LOC,[z3,z2]);
   var N=this.computePoints(choice,LOC,[z3,z0]);
   return [N,S,E,W];
}





function plaidTransform(x,y) {
  var a=this.TR;
  if(BLOCK.on==1) a=this.TR2;

    var s=[];
    s[0]=(x-a[4])/a[0];
    s[1]=(y-a[5])/a[3];
    return s;
}


function getOffset() {
  var z=ZVAL.val;
  var x=XVAL.val;
  if(OFFSET.on==0) return 0;
  if(SLICE==1) return this.p;
  if(SLICE==2) {
    var s=this.getMagicSlice();
    var p=this.p;
    var q=this.q;
    var n=this.n;
    var r1=1-2*(p/n);
    var r2=q/n;
    if(TEMP.on==1) r2=p/n;
    var p2=p-(x-s)*r1;
    var p3=Math.floor(p2+r2);
    p3=(p3+n)%n;
    return p3;
  }
  return 0;
}


function computePoints(choice,LOC,EDGE0) {
  var a0=0;
  var a1=0;
  var a=0;

  var t0=EDGE0[0].y;
  var t1=EDGE0[1].y;

  if(t0>this.n) t0=t0-this.n;
  if(t1>this.n) t1=t1-this.n;

  var EDGE=[];
  EDGE[0]=new Complex(EDGE0[0].x,t0);
  EDGE[1]=new Complex(EDGE0[1].x,t1);

  if(choice==0) {
    a0=this.computePoints0(0,LOC,EDGE);
    a1=this.computePoints0(1,LOC,EDGE);
    a=(a0+a1)%2;
    a=[a,-1];
  }

  if(choice==1) {
    a0=this.computePoints1(0,LOC,EDGE);
    a1=this.computePoints1(1,LOC,EDGE);
    a=(a0+a1)%2;
    a=[a,-1];
  }

  if(choice==2) {
    a=this.computePoints2(LOC,EDGE);
  }
  return a;
}


function computePoints0(choice,Z,EDGE) {
  var y=[];
  y=plaidRange0(choice,this.p,this.q,Z,EDGE);
  line=getLine(EDGE);
  var cap=this.CAP[line];
  var I=getIntegers(y,this.p,this.q);
  var count=0;
  for(var i=0;i<I[0].length;++i) {  
    var test=false;
    var mas=this.MAS[I[0][i]];
    if(goodPoint(mas,cap)==true) test=true;
    if(choice==1) {
      if((I[1]==0)&&(i==0)) test=false;
      if((I[1]==1)&&(i==I[0].length-1)) test=false;
    }
    if(test==true) ++count;
  }
  return count;
}


function computePoints1(choice,Y,EDGE) {
  if(Y==0) return 0;
  var y=[];
  y=plaidRange1(choice,this.p,this.q,EDGE);
  var cap=this.CAP[Y];
  if(cap<0) cap=-cap;
  var I=getIntegers(y,this.p,this.q);
  var count=0;
  for(var i=0;i<I[0].length;++i) {  
    var test=false;
    if(this.goodHorizontal(I[0][i],cap)==true) test=true; 
    if(choice==1) {
      if((I[1]==0)&&(i==0)) test=false;
      if((I[1]==1)&&(i==I[0].length-1)) test=false;
    }
    if((getLine(EDGE)==0)&&(verticalOrHorizontal(EDGE)==0)) test=false;
    if((getLine(EDGE)==this.n)&&(verticalOrHorizontal(EDGE)==0)) test=false;
    if(test==true) ++count;
  }
  return count;
}

function computePoints2(X,EDGE) {

  if(X==0) return 0;
  var a0=0;
  var a1=0;
  var a=0;
  var VH=verticalOrHorizontal(EDGE);
  var twist=0;
  var n=this.n;
  //horizontal case:plaid
  if(VH==1) {
    var z1=new Complex(X,EDGE[0].x);
    var z2=new Complex(X,EDGE[1].x);
    var EDGE2=[z1,z2];
    a0=this.computePoints0(0,EDGE[0].y,EDGE2);
    a1=this.computePoints0(1,EDGE[0].y,EDGE2);
    a=(a0+a1)%2;
    var twist=0;
    if(a0==1) twist=1;
  }

  //vertical case:truchet
  if(VH==0) {

    var z1=new Complex(X,EDGE[0].y);
    var z2=new Complex(X,EDGE[1].y);
    var EDGE2=[z1,z2];
    a0=this.computePoints1(0,EDGE[0].x,EDGE2);
    a1=this.computePoints1(1,EDGE[0].x,EDGE2);
    a=(a0+a1)%2; 
    var twist=0;
    if(a0==1) twist=1;
  }
  return [a,twist];
}

function goodHorizontal(a,cap) {
  if(cap==0) return false;
  var index=cap/2-1;
  for(var i=0;i<this.HOR[index].length;++i) {
    if(a==this.HOR[index][i]) return true;
  }
  return false;
}

