/**These are some numerical routines that support the plaid model*/



/**Here is the basic plaid model comparison*/

function goodPoint(mass,cap) {
  if(mass*cap<0) return false;
  if(Math.abs(mass)>=Math.abs(cap)) return false;
  return true;
}

/**Tests if a point is fairly near an integer*/
function nearInteger(y) {
  var z=y-Math.floor(y);
  if(z<.00001) return true;
  if(z>.99999) return true;
  return false;
}



/**This gets the number of the line containing the
   two points of Z*/

function getLine(EDGE) {
  var VH=verticalOrHorizontal(EDGE);
  var line=0;
  if(VH==0) line=EDGE[0].x;
  if(VH==1) line=EDGE[0].y; 
  return line;
}

/** 0 is vertical,  1 is horizontal*/

function verticalOrHorizontal(EDGE) {
  if(Math.abs(EDGE[0].x-EDGE[1].x)<.25) return 0;
  return 1;
}



function tau(p,q,choice) {
  var n=p+q;
  var i=inverse(2*p,n);
  if(choice==true) return i;
  if(i>n/2) i=n-i;
  return i;
}

function inverse(k,n) {
  for(var i=0;i<n;++i) {
    if((i*k)%n==1) return i;
  }
  return 0;
}


function massSequence(p,q) {
  var S=capacitySequence(p,q);
  var T=[];
  var n=p+q;
  for(var i=0;i<=n;++i) {
    var t=S[i]/2;
    var test=(t+2*n)%2;
    if(test==1) T[i]=t;
    if(test==0) {
      var t1=t-n;
      if(t1<-n) t1=t1+2*n;
      T[i]=t1;
    }
  }
  return T;
}



function capacitySequence(p,q) {
  var t=tau(p,q,false);
  var S=[];
  var n=p+q;
  var Z=[];
  for(var i=0;i<=n;++i) Z[i]=0;
  for(var i=0;i<n/2;++i) {
    var j=(t*i)%n;
    Z[j]=2*i;
    Z[n-j]=-2*i;
  }
  return Z;
}


function horizontalArray(p,q) {
  var Z=[];
  var n=p+q;
  var pp=tau(p,q,false);
  var qq=n-pp;
  for(var i=0;i<n/2;++i) {
    Z[i]=[];
    for(var j=0;j<=i;++j) {
      Z[i][j]=(i*pp+j*(qq-pp))%n;
    }
  }
  return Z;
}


function plaidRange0(choice,p,q,Z,EDGE) {
  var z1=EDGE[0];
  var z2=EDGE[1];
  var slope=0;
  if(choice==0) slope=+2*p/(p+q);
  if(choice==1)  slope=+2*q/(p+q);
  var y1=slope*z1.x+z1.y;
  var y2=slope*z2.x+z2.y;
  var t=tau(p,q,true);
  if(choice==0) t=2*t*p*Z;
  if(choice==1) t=2*t*q*Z;
  y1=y1-t;
  y2=y2-t;
  return [y1-.00000001,y2+.00000001];
}


function plaidRange1(choice,p,q,EDGE) {
  var z1=EDGE[0];
  var z2=EDGE[1];
  var slope=0;
  if(choice==0) slope=-2*p/(p+q);
  if(choice==1) slope=+2*q/(p+q);
  var y1=slope*z1.x+z1.y;
  var y2=slope*z2.x+z2.y;
  var yy1=y1;
  var yy2=y2;
  if(y1>y2) {
    yy1=y2;
    yy2=y1;
  }
  return [yy1-.00000001,yy2+.00000001];
}

function getIntegers(Y,p,q) {
  var n=p+q;
  var count=0;
  var Z=[];
  for(var i=Math.floor(Y[0])+1;i<Math.floor(Y[1])+1;++i) {
    Z[count]=(i+n*n*n*n)%n;
    ++count;
  }
  var SPECIAL=-1;
  if(nearInteger(Y[0])==true) SPECIAL=0;
  if(nearInteger(Y[1])==true) SPECIAL=1;
  return [Z,SPECIAL];
}

function pathConnector(N0,S0,E0,W0,i,j) {
  var N=N0[0];
  var S=S0[0];
  var E=E0[0];
  var W=W0[0];

 var p=new Path2D();


 if((N*S*E*W==1)&&(N0[1]==1)) {
   p.moveTo(i,j+.5);
   p.lineTo(i+.5,j);
   p.moveTo(i+1,j+.5);
   p.lineTo(i+.5,j+1);
   return p;
 }

 if((N*S*E*W==1)&&(N0[1]==0)) {
   p.moveTo(i,j+.5);
   p.lineTo(i+.5,j+1);
   p.moveTo(i+1,j+.5);
   p.lineTo(i+.5,j);
   return p;
 }

   if((E==1)&&(W==1)) {
     p.moveTo(i,j+.5);
     p.lineTo(i+1,j+.5);
   }

   if((N==1)&&(S==1)) {
     p.moveTo(i+.5,j);
     p.lineTo(i+.5,j+1);
   }

   if((W==1)&&(N==1)) {
     p.moveTo(i,j+.5);
     p.lineTo(i+.5,j);
   }

   if((W==1)&&(S==1)) {
     p.moveTo(i,j+.5);
     p.lineTo(i+.5,j+1);
   }

   if((E==1)&&(S==1)) {
     p.moveTo(i+1,j+.5);
     p.lineTo(i+.5,j+1);
   }

   if((E==1)&&(N==1)) {
     p.moveTo(i+1,j+.5);
     p.lineTo(i+.5,j);
   }

   return p;
}



