
/**Here is a polygon object*/

function Poly(Z,n,COLOR) {
   this.Z=Z;
   this.n=n;
   this.COLOR=COLOR;
   this.inside=0;
   this.polyInside=polyInside;
   this.polyRender=polyRender;
   this.polyCopy=polyCopy;
   this.toPath=toPath;
   this.polyRenderUnscaled=polyRenderUnscaled;
   this.translate=translate;
}

/**Draws the polygon. F determines whether
   you draw the whole thing or just the outline*/

function polyRender(CANVAS,F) {
    var draw = CANVAS.getContext('2d');
    var p=this.toPath();
    draw.fillStyle=this.COLOR;
    draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
    if(F==true) draw.fill(p);
    draw.strokeStyle='#fff'; 
    if(F==false) draw.strokeStyle='#bdf';
    draw.lineWidth=1/TRANS[0];
    draw.stroke(p);
    draw.setTransform(1,0,0,1,0,0);
}

function toPath() {
    var p=new Path2D();
    for(var i=0;i<this.n;++i) {
       if(i==0) p.moveTo(this.Z[0],this.Z[1]);
       if(i!=0) p.lineTo(this.Z[2*i],this.Z[2*i+1]);
    }
    p.closePath();
    return p;
}


/**Draws the polygon in absolute coordinates.
   Used with the remote control*/

function polyRenderUnscaled(CANVAS) {
    var draw = CANVAS.getContext('2d');
    var p=new Path2D();
    draw.fillStyle=this.COLOR;
    for(i1=0;i1<this.n;++i1) {
       if(i1==0) p.moveTo(this.Z[0],this.Z[1]);
       if(i1!=0) p.lineTo(this.Z[2*i1],this.Z[2*i1+1]);
    }
    p.closePath();
    draw.setTransform(1,0,0,1,0,0);
    draw.fill(p);
    draw.strokeStyle='#fff'; 
    draw.lineWidth=1;
    draw.stroke(p);
}


/**This determines whether the polygon
   contains the point (x,y).  This routine
   only works with CONVEX polygons.*/

function polyInside(x,y) {
   var total=0;
   this.inside=1;
   var MEM=[0,0,0,0];
   
   for(q=0;q<this.n;++q) {
       var j=(q+1)%this.n;;
       var A1=this.Z[2*q+0]-x;
       var A2=this.Z[2*q+1]-y;
       var B1=this.Z[2*j+0]-x;
       var B2=this.Z[2*j+1]-y;
       MEM[q]=A1*B2-A2*B1; 
    }
   if(MEM[0]*MEM[1]<0) this.inside=0;
   if(MEM[0]*MEM[2]<0) this.inside=0;
   if(MEM[0]*MEM[3]<0) this.inside=0;
}


/**This works for non-convex polygons as well.*/

function polyInsideRobust(x,y) {
   var total=0;
   this.inside=0;
   for(i=0;i<this.n;++i) {
     var j=i+1;
     if(j==this.n) j=0;
     var A1=this.Z[2*i+0]-x;
     var A2=this.Z[2*i+1]-y;
     var B1=this.Z[2*j+0]-x;
     var B2=this.Z[2*j+1]-y;
     var A3=Math.sqrt(A1*A1+A2*A2);
     var B3=Math.sqrt(B1*B1+B2*B2);
     A1=A1/A3;
     A2=A2/A3;
     B1=B1/B3;
     B2=B2/B3;
     var C=A1*B1+A2*B2; //dot
     var S=A1*B2-A2*B1; //cross
     var angle = Math.atan2(S,C);
     total=total+angle;
   }
if(total*total>.0001) this.inside=1;
}

function toPoly(X) {
  var n=X.length;
  var Y=[];
  for(var i=0;i<n;++i) {
    Y[2*i+0]=X[i][0];
    Y[2*i+1]=X[i][1];
  }
  var P=new Poly(Y,n,'#fff');
  return P;
}

function translate(x,y) {
  for(var i=0;i<this.n;++i) {
    this.Z[2*i+0]=this.Z[2*i+0]+x;
    this.Z[2*i+1]=this.Z[2*i+1]+y;
  }
}

function polyCopy() {
  var Y=[];
  for(var i=0;i<this.n;++i) {
    Y[2*i+0]=this.Z[2*i+0];
    Y[2*i+1]=this.Z[2*i+1];
  }
  var P=new Poly(Y,this.n,this.COLOR);
  return P;
}
