

/************************************/
/**Here is the button object*/
function RationalEntry(Z,COL) {
   this.Z=Z;
   this.COL=COL; 
   this.S="2/9";
   this.on=0;
   this.rationalEntryRender=rationalEntryRender;
   this.rationalEntryPress=rationalEntryPress;
   this.acceptKey=acceptKey;
   this.getRational=getRational;
   this.doReduce=doReduce;
   this.doRandom=doRandom;
}

/**switches the on feature between 0 and 1*/


function rationalEntryRender(CANVAS) {
   var draw = CANVAS.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle = this.COL[0];
   var x=this.getRational();
   if(x==false) draw.fillStyle=this.COL[4];
   else {
     x=reduce(x);
     if((x[0]*x[1])%2==1) draw.fillStyle=this.COL[5];
   }
   draw.fillRect(this.Z[0],this.Z[1],this.Z[2],this.Z[3]);
   draw.fillStyle = this.COL[1];
   draw.font = '14pt Helvetica';  
   draw.fillText(this.S,this.Z[0]+5,this.Z[1]+this.Z[3]-5);
   draw.strokeStyle = this.COL[2];
   if(this.on==1) draw.strokeStyle = this.COL[3];
   draw.strokeRect(this.Z[0],this.Z[1],this.Z[2],this.Z[3]);
}

function rationalEntryPress(x,y) {
  this.on=0;
   if(x<this.Z[0]) return(false);
   if(x>this.Z[0]+this.Z[2]) return(false);
   if(y<this.Z[1]) return(false);
   if(y>this.Z[1]+this.Z[3]) return(false);
   this.on=1;
   return(true);
}

function acceptKey(e,x,y) {
  if(this.rationalEntryPress(x,y)==false) return false;
  var letter=event.keyCode-48;
  if((letter>=0)&&(letter<=9)) this.S=this.S+letter;
  if(letter==143) this.S=this.S+"/";
  if(letter==-40) this.S=this.S.substring(0,this.S.length-1);
  var T=this.getRational();
  if(letter==17) this.doReduce();
  if(letter==34) this.doRandom();
  if(letter==33) this.S="1/2";
  return true;
}


/***We want the rational to be even and between 0 and 1*/
function getRational() {
  var a=this.S.indexOf("/");
  if(a<1) return false; 
  var N=this.S.substring(0,a); 
  var D=this.S.substring(a+1,this.S.length); 
  if(D.length==0) return false;
  var n=+N;
  var d=+D;
  return [+N,+D];
}

function doReduce() {
  var x=this.getRational();
  if(x==false) return;
  x=reduce(x);
  this.S=x[0].toString()+"/"+x[1].toString();
}


function GCDe(a,b) {

  var u,v,g;
  var u1,v1,g1;
  var t1,t2,t3;
  var q;
  u  = 1;  
  v  = 0;  
  g  = a;
  u1 = 0;  
  v1 = 1;  
  g1 = b;
  while (g1 != 0) {
    q = (g-g%g1)/g1; 
    t1 = u - q*u1;   
    t2 = v - q*v1;   
    t3 = g - q*g1;
    u  = u1;   
    v  = v1;    
    g  = g1;
    u1 = t1;    
    v1 = t2;    
    g1 = t3;
  }
  return [u,v,g];
}

function GCD(a,b) {
  var x=GCDe(a,b);
  return x[2];
}


function reduce(x) {
  var c=GCD(x[0],x[1]);
  return [x[0]/c,x[1]/c];
}

function doRandom() {
  var test=false;
  while(test==false) {
    var q=Math.floor(30*Math.random());
    if(q<2) q=2;
    var p=Math.floor((q-2)*Math.random())+1;
    var x=[p,q];
    x=reduce(x);
    var parity=(x[0]*x[1])%2;
    if(parity==0) test=true;
  }

  this.S=x[0].toString()+"/"+x[1].toString();

}
