
function repaintBottom() { 
   var draw = CANVAS.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.clearRect(0,0,1000,30);
   draw.clearRect(0,0,30,800);
   draw.clearRect(0,770,1000,30);
   draw.clearRect(970,0,30,800);
   draw.fillStyle='#808';
   draw.fillRect(0,0,1000,30);
   draw.fillRect(970,0,30,800);
   draw.fillRect(0,770,1000,30);  
   draw.fillStyle='#088'; 
   draw.fillRect(970,30,30,470); 
   draw.fillRect(0,0,30,800); 

   draw.fillStyle='#509'; 
   ANIMATE.buttonRender(CANVAS);
   BLOCK.buttonRender(CANVAS);
   draw.font = '12pt Helvetica'; 
   draw.fillStyle='#fff';
   RE.rationalEntryRender(CANVAS);
   SEND.buttonRender(CANVAS);
   OFFSET.buttonRender(CANVAS);
   TEMP.buttonRender(CANVAS);
   CUBE.buttonRender(CANVAS);
   SWAP.buttonRender(CANVAS);
   if(SWAP.on==1) SLICER.sliceControlRender(CANVAS);


   ZVAL.arrowSliderRender(CANVAS);
   YVAL.arrowSliderRender(CANVAS);
   XVAL.arrowSliderRender(CANVAS);
   for(var i=0;i<3;++i) SWITCH[i].buttonRender(CANVAS);

   for(var i=0;i<2;++i) BIG[i].buttonRender(CANVAS);
   COLOR.colorSelectorRender(CANVAS);  
   LANDSCAPE.landscapeRenderControls(CANVAS); 
   LANDSCAPE.landscapeRenderGraphStats(CANVAS);
   var k=-1;
   if(SLICE==1) k=PLAID.CAP[YVAL.val];
   if(SLICE==2) k=PLAID.CAP[XVAL.val];
   draw.fillStyle='#fff';
   if(Math.abs(k)>2*PLAID.p)   draw.fillStyle='#f80';
   if(k!=-1) draw.fillText(k.toString(),350,20); 
   if(CUBE.on==1) NAV.navigatorRender(CANVAS); 
   if(CLICK[0]>970) drawCrosshairs();
   if(CLICK[1]>770) drawCrosshairs();
   if(CLICK[0]<30) drawCrosshairs();
   if(CLICK[1]<30) drawCrosshairs();
}

function repaintMiddle() { 
  if(BLOCK.on==1) return; 
  var draw = CANVAS.getContext('2d');
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(0,500,1000,500);
  drawInfo(CLICK[0],CLICK[1]); 
  if(CLICK[1]>500) drawCrosshairs();
 
}



function repaint() { 
  var draw = CANVAS.getContext('2d');
  draw.clearRect(30,30,740,470);
  if(BLOCK.on==1) draw.clearRect(30,30,740,940);
  if(CUBE.on==0) LANDSCAPE.landscapeRenderGraph(CANVAS);
 
   if((BLOCK.on==0)||((BLOCK.on==1)&&(BIG[0].on==1))) {
     if(SWAP.on==0) PLAID.plaidRender(CANVAS);
       LANDSCAPE.landscapeRenderSurface(CANVAS);
       drawLocator();
   }
   if((BLOCK.on==0)&&(CUBE.on==1)) drawTile(); 
   if(SWAP.on==1) drawSlice();
   drawFrame();
}

function drawSlice() {
  if(SLICE==0) SLICER.sliceZ();
  if(SLICE==1) SLICER.sliceY();
  if(SLICE==2) SLICER.sliceX();
  SLICER.sliceRender();
}

function getSegment(i,j) {
  if(SQUARE[2]==0) return [new Complex(i+1,j+0),new Complex(i+1,j+1)];
  if(SQUARE[2]==1) return [new Complex(i+0,j+1),new Complex(i+1,j+1)];
  if(SQUARE[2]==2) return [new Complex(i+0,j+0),new Complex(i+0,j+1)];
  if(SQUARE[2]==3) return [new Complex(i+0,j+0),new Complex(i+1,j+0)];
  return undefined();
}


function drawTile() { 
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(500,30,470,470);
  draw.fillStyle='#000';
  draw.fillRect(500,30,470,470);
  TILE.tileRender(CANVAS);
  draw.strokeStyle='#fff';
  draw.lineWidth=2; 
  draw.strokeRect(500,30,470,470);
  draw.setTransform(1,0,0,1,0,0);

}

function drawFrame() {
   var draw = CANVAS.getContext('2d');  
   draw.setTransform(1,0,0,1,0,0);
   draw.strokeStyle='#fff';
   draw.lineWidth=2;
   if(BLOCK.on==0) {
     draw.strokeRect(30,30,470,470);
     draw.strokeRect(500,30,470,470);
     draw.strokeRect(0,500,1000,500);
   }
 
}

function drawLocator() {  
  var draw = CANVAS.getContext('2d'); 
  var a=PLAID.TR;
  if(BLOCK.on==1) a=PLAID.TR2;
  draw.setTransform(a[0],a[1],a[2],a[3],a[4],a[5]);
  draw.lineWidth=2/a[0]; 
  draw.fillStyle='#fff';  
  draw.strokeStyle='#fff';
  var x=XVAL.val;
  var y=YVAL.val;
  var z=ZVAL.val;

  z=(z-PLAID.getOffset()+PLAID.n)%PLAID.n;


  var tau=2*Math.PI;
  var p=new Path2D();
  var n=PLAID.n;
  if(SLICE==0) draw.strokeRect(x,y,1,1); 
  if(SLICE==1) draw.strokeRect(x,z,1,1); 
  if(SLICE==2) draw.strokeRect(y,z,1,1); 
  draw.lineWidth=8/a[0]; 
  if(SLICE==0) p.arc(x,y,.2,0,tau);
  if(SLICE==1) p.arc(x,z,.2,0,tau);
  if(SLICE==2) p.arc(y,z,.2,0,tau);
  draw.fill(p);
}


function drawCrosshairs() { 
    var draw = CANVAS.getContext('2d');
    draw.setTransform(1,0,0,1,0,0);
    var p=new Path2D();
    draw.lineWidth=2;
    p.moveTo(CLICK[0]-4,CLICK[1]);
    p.lineTo(CLICK[0]+4,CLICK[1]);
    p.moveTo(CLICK[0],CLICK[1]-4);
    p.lineTo(CLICK[0],CLICK[1]+4);
    p.closePath();
    draw.strokeStyle='#fff';
    draw.stroke(p);
}


     
/**This sets the scale to that the bounding box is mapped to the
   given square*/

function doFit(X,Y) {
   var s=Y[2]/X[2];
   TRANS[0]=s;
    TRANS[1]=0;
    TRANS[2]=0;
    TRANS[3]=s;
    TRANS[4]=Y[0]-s*X[0];
    TRANS[5]=Y[1]-s*X[1];
}
