
/**M is a 3x3 matrix.
   M[0] is a point.
   M[1] and M[2] make up a frame.
   The plane is spanned by M[0],M[1] and goes through M[0]
*/

function Slicer(x,y) {
  this.x=x;
  this.y=y;
  this.A=new ArrowSlider([x+10,y,270,30],'#0c0','#070',0,50,1,"");
  this.toVisual=toVisual;
  this.halfplaneRaw=halfplaneRaw;
  this.halfplane=halfplane;
  this.intersectSegment=intersectSegment;
  this.intersectTriangle=intersectTriangle;
  this.sliceRender=sliceRender;
  this.sliceControlRender=sliceControlRender;
  this.sliceProcess=sliceProcess;
  this.sliceX=sliceX;
  this.sliceY=sliceY;
  this.sliceZ=sliceZ;
}

/**Maps a vector in the plane to the visual plane*/

function toVisual(p) {
  var q=subtract(p,this.M[0]);
  var N=cross(this.M[1],this.M[2]);
  var W1=cross(this.M[2],N);
  var W2=cross(N,this.M[1]);
  var a1=dot(q,W1);
  var a2=dot(q,W2);
  return [a1,a2];
}

/**tells which halfplane a given vector is in.
   Returns +/- 1*/

function halfplane(p) {
  var d=this.halfplaneRaw(p);
  if(Math.abs(d)<.0000001) return 0;
  if(d<0) return -1;
  if(d>0) return 1;
}

function halfplaneRaw(p) {
  var q=subtract(p,this.M[0]);
  var N=cross(this.M[1],this.M[2]);
  var d=dot(q,N);
  return d;
}


/**This routine works when one vector is
   above and one vector is below*/

function intersectSegment(V,W) {
  var sv=this.halfplane(V);
  var sw=this.halfplane(W);
  if((sv==0)&&(sw!=0)) return V;
  if((sw==0)&&(sv!=0)) return W;
  if(sv*sw!=-1) return undefined
  var v=this.halfplaneRaw(V);
  var w=this.halfplaneRaw(W);
  var t=w/(w-v);
  var X=add(scale(t,V),scale(1-t,W));
  return X;
}


function intersectTriangle(T) {

  var s=[];
  for(var i=0;i<3;++i) {
    s[i]=this.halfplane(T[i]);
  }

  var empty=false;
  if((s[0]==-1)&&(s[1]==-1)&&(s[2]==-1)) empty=true;
  if((s[0]==+1)&&(s[1]==+1)&&(s[2]==+1)) empty=true;
  for(var i=0;i<3;++i) {
    if((s[i]==0)&&(s[0]+s[1]+s[2]==+2)) empty=true;
    if((s[i]==0)&&(s[0]+s[1]+s[2]==-2)) empty=true;
  }
  if(empty==true) {
    var p=new Path2D();
    p.moveTo(0,0);
    p.lineTo(0,0);
    return p;
  }   

  var z=[];
  for(var i=0;i<3;++i) z[i]=this.toVisual(T[i]);

  if((s[0]==0)&&(s[1]==0)&&(s[2]==0)) {
    var p=new Path2D();
    p.moveTo(z[0][0],z[0][1]);
    p.lineTo(z[1][0],z[1][1]);
    p.lineTo(z[2][0],z[2][1]);
    p.closePath();
    return p;
  }

  for(var i=0;i<3;++i) {
    var j=(i+1)%3;
    var k=(i+2)%3;
    if((s[j]==0)&&(s[k]==0)) {
      var p=new Path2D();
      p.moveTo(z[j][0],z[j][1]);
      p.lineTo(z[k][0],z[k][1]);
      p.closePath();
      return p;
    }
  }

  for(var i=0;i<3;++i) {
    var j=(i+1)%3;
    var k=(i+2)%3;
    if(s[i]==0) {
      var p=new Path2D();
      var w=this.intersectSegment(T[j],T[k]);  
      w=this.toVisual(w);
      p.moveTo(z[i][0],z[i][1]);
      p.lineTo(w[0],w[1]);
      return p;
    }
  }


  for(var i=0;i<3;++i) {
    var j=(i+1)%3;
    var k=(i+2)%3;
    if((s[i]*s[j]==-1)&&(s[i]*s[k]==-1)) {
      var p=new Path2D();
      var w1=this.intersectSegment(T[i],T[j]); 
      var w2=this.intersectSegment(T[i],T[k]);  
      w1=this.toVisual(w1);
      w2=this.toVisual(w2);
      p.moveTo(w1[0],w1[1]);
      p.lineTo(w2[0],w2[1]);
      return p;
    }
  }
}

function sliceControlRender(CAN) {
  this.A.arrowSliderRender(CAN);
}

function sliceRender(CAN) {
  var draw = CANVAS.getContext('2d'); 
  var a=PLAID.TR;
  draw.setTransform(a[0],a[1],a[2],a[3],a[4],a[5]);
  var cols=['#0c0','#f40','#04f'];
  draw.strokeStyle=cols[SLICE];
  draw.lineWidth=2.0/a[0];

  var n=PLAID.n;
  for(var i=0;i<n;++i) {
    for(var j=0;j<n;++j) {
      for(var k=0;k<n;++k) {
	var T=SURFACE.T[i][j][k];
	var LIST=T.triangleList();
	for(var l=0;l<LIST.length;++l) {
	  var p=this.intersectTriangle(LIST[l]);
	  draw.stroke(p);
	}
      }
    }
  }
}

function sliceProcess(x,y) {
  this.A.arrowSliderPress(x,y);
}

function sliceZ() {
  var t=ZVAL.val+this.A.val/50;
  var r=1-2*PLAID.p/PLAID.n;
   var M0=new Vector([0,0,t]);
   var M1=new Vector([1,0,-r]);
   var M2=new Vector([0,1,0]);
   this.M=[M0,M1,M2];
}

function sliceY() {
   var t=YVAL.val+this.A.val/50;
   var u=PLAID.getOffset();
   var M0=new Vector([0,t,u]);
   var M1=new Vector([1,0,0]);
   var M2=new Vector([0,0,1]);
   this.M=[M0,M1,M2];
}

function sliceX() {
   var t=XVAL.val+this.A.val/50; 
   var u=PLAID.getOffset(); 

   var M0=new Vector([t,0,u]);
   var M1=new Vector([0,1,0]);
   var M2=new Vector([0,0,1]);
   this.M=[M0,M1,M2];
}

