

function Surface() {
    this.GRAPH=[];
    this.COLOR=[];
    this.FLAGS=[];
    this.POINTS=[];

    this.precompute=precompute;
    this.precompute();
    this.cubeToLineArray=cubeToLineArray;
    this.lineToCubeArray=lineToCubeArray;
    this.initBFS=initBFS;
    this.singleBFS=singleBFS;
    this.doBFS=doBFS;
    this.surfaceSlice=surfaceSlice;
    this.surfaceSlice0=surfaceSlice0;
    this.surfaceSlice1=surfaceSlice1;
    this.surfaceSlice2=surfaceSlice2;
    this.surfaceRender=surfaceRender;
    this.adjacentVertices=adjacentVertices;
    this.tileCycle=tileCycle;
    this.tileExtend=tileExtend;
    this.flagNeighbors=flagNeighbors;
    this.graphRender=graphRender;
    this.surfaceGraph=surfaceGraph;
    this.initGraph=initGraph;
    this.initFace=initFace;
    this.recordGraph=recordGraph;
    this.correctCyclic=correctCyclic;
    this.countFaces=countFaces;
    this.vertexNumber=vertexNumber;
    this.geomInit=geomInit;
    this.geomUpdate=geomUpdate;
    this.geomUpdate0=geomUpdate0;
    this.surfaceCopy=surfaceCopy;
    this.topology=topology;
}

function surfaceCopy() {
  var S=new Surface();

  for(var i=0;i<this.FLAGS.length;++i) {
    S.FLAGS[i]=this.FLAGS[i];
  }

  for(var i=0;i<this.POINTS.length;++i) {
    var z=this.POINTS[i];
    S.POINTS[i]=new Complex(z.x,z.y);
  }

  for(var i=0;i<this.COLOR.length;++i) {
    S.COLOR[i]=[];
    for(var j=0;j<4;++j) {
      S.COLOR[i][j]=this.COLOR[i][j];
    }
  }

  for(var i=0;i<this.GRAPH.length;++i) {
    S.GRAPH[i]=[];
    for(var j=0;j<4;++j) {
      S.GRAPH[i][j]=this.GRAPH[i][j];
    }
  }
  return S;

}

function topology() {
   var f=this.countFaces();
   var v=this.GRAPH.length;
   var e=2*v;
   var chi=f+v-e;
   var g=1-chi/2;
   var S="(F,V,E)=(";
   S=S+f.toString()+","+v.toString()+","+e.toString()+")";
   S=S+" g="+g.toString();  
   return S;
}




function precompute() { 
    this.CURRENT=0;
    this.T =[];
    var count=0;
    var n=PLAID.n;
    for(var i=0;i<n;++i) {
      this.T[i]=[];
      for(var j=0;j<n;++j) {
	this.T[i][j]=[];
	for(var k=0;k<n;++k) {
	  this.T[i][j][k]=new Tile([i,j,k]);
	  this.T[i][j][k].assemble();
	  this.T[i][j][k].TAG=count;
	  count=count+this.T[i][j][k].E.length;
	}
      }
    }

    this.ITAG=[];
    count=0;
    for(var i=0;i<n;++i) {
      for(var j=0;j<n;++j) {
	for(var k=0;k<n;++k) {
	  var L=this.T[i][j][k].E.length;
	  for(var l=0;l<L;++l) {
	    this.ITAG[count]=[i,j,k,l];
	    ++count;
	  }
	}
      } 
    } 
    this.TOTAL=count; 
    this.USED=[];
    for(var i=0;i<this.TOTAL;++i) this.USED[i]=false;
}






function doBFS(n) {
   this.initBFS(n);
   var test=false;
   while(test==false) {
      this.singleBFS();
      if(this.CURRENT==this.FLAGS.length) test=true;
   }
}

function initBFS(n) {
  for(var i=0;i<this.TOTAL;++i) this.USED[i]=false;
  this.FLAGS=[n];
  this.CURRENT=0; 
  this.USED[n]=true;
}

function singleBFS() {
  var n=this.FLAGS[this.CURRENT];

  var L=this.FLAGS.length;
  var N=this.adjacentVertices(n);
  var count=0;
  for(var i=0;i<N.length;++i) {
    if(this.USED[N[i]]==false) {
         this.FLAGS[L+count]=N[i];
	 this.USED[N[i]]=true;
	 ++count;
    }
  }
  ++this.CURRENT;
}



function adjacentVertices(m) {
  var x=this.lineToCubeArray(m);
  var nx=this.flagNeighbors(x);
  var y=[];
  for(var i=0;i<nx.length;++i) {
    y[i]=this.cubeToLineArray(nx[i]);
  }
  return y;
}


/**These routines convert back and forth between
the natural cubical indexing for the cubes
and a linear, essentially lexicographic, order.*/

function cubeToLineArray([i,j,k,l]) {
  var t=this.T[i][j][k].TAG+l;
  return t;
}

function lineToCubeArray(m) {
  return this.ITAG[m];
}



/**Navigation*/

function tileExtend(x) { 
  var T=this.T[x[0]][x[1]][x[2]];
  var edge0=T.absoluteEdge(x[3]);
  T.FOCUS=x[3];
  var test=T.faceVector();
  var xx=[];
  for(var i=0;i<3;++i) {
    xx[i]=(x[i]+test[i]+PLAID.n)%PLAID.n;
  }
  var TT=this.T[xx[0]][xx[1]][xx[2]];
  TT.tileAlign(edge0);
  return [xx[0],xx[1],xx[2],TT.FOCUS];
}

function tileCycle(x) { 
  var T=this.T[x[0]][x[1]][x[2]];
  var index=T.focusToIndex(x[3]);
  var L=T.F[index[0]].length;
  index[1]=(index[1]+1)%L;
  var focus=T.indexToFocus(index); 
  return [x[0],x[1],x[2],focus];

}


function flagNeighbors(x) {
  var T=this.T[x[0]][x[1]][x[2]];
  var e=T.focusToIndex(x[3]);
  var nx=[];
  var L=T.F[e[0]].length;
  var y=x;
  for(var i=0;i<L;++i) {
    nx[i]=this.tileExtend(y);
    y=this.tileCycle(y);
  }
  return nx;
}


/**The graph*/

function initGraph() {
  var n=PLAID.n;
  for(var i=0;i<=2*n;++i) {
    this.USED[i]=[];
    for(var j=0;j<=2*n;++j) {
      this.USED[i][j]=[];
      for(var k=0;k<=2*n;++k) {
	this.USED[i][j][k]=[];
      }
    }
  }
}

function initFace() {
  var n=PLAID.n;
  for(var i=0;i<=n;++i) {
    this.USED[i]=[];
    for(var j=0;j<=n;++j) {
      this.USED[i][j]=[];
      for(var k=0;k<=n;++k) {
	this.USED[i][j][k]=[];
      }
    }
  }
}


function countFaces() {

  this.initFace();
  var n=PLAID.n;

  for(var i=0;i<this.FLAGS.length;++i) {
      var x=this.lineToCubeArray(this.FLAGS[i]);
      var T=this.T[x[0]][x[1]][x[2]];
      var u=this.USED[x[0]][x[1]][x[2]];
      var index=T.focusToIndex(x[3]);
      u[u.length]=index[0];
  }
  var count=0;
  for(var i=0;i<=n;++i) {
    for(var j=0;j<=n;++j) {
      for(var k=0;k<=n;++k) {
	var u=this.USED[i][j][k];
	if(onList(0,u)==true) ++count;
	if(onList(1,u)==true) ++count;
      }
    }
  }
  return count;
}


function recordGraph() {
  this.GRAPH=[];
  this.COLOR=[];
  var n=PLAID.n;
  var N=this.vertexNumber();
  for(var i=0;i<2*n;++i) {
    for(var j=0;j<2*n;++j) {
      for(var k=0;k<2*n;++k) {	 
        var u=this.USED[i][j][k];
	var u0=[];
	var u1=[];
	for(var q=0;q<u.length;++q) {
            u0[q]=u[q][0];
            u1[q]=u[q][1];
	}
	if(u.length>0) {
	  this.GRAPH[u0[0]]=[];
	  this.COLOR[u0[0]]=[];

	  var count=0;
	  for(var ii=0;ii<N;++ii) {
            var oln=onListNum(ii,u0);
	    if((ii!=u0[0])&&(oln!=-1)) {
	      this.GRAPH[u0[0]][count]=ii;
              this.COLOR[u0[0]][count]=u1[oln];
	      ++count;
	    }
	  }
	}
      }
    }
  }
  for(var i=0;i<this.GRAPH.length;++i) {
    if(this.GRAPH[i].length!=4) alert("valence problem");
  }
}


function assignColor(u1) {
  var s=intersection[[0,1,2],u1];
  return 0;
}




function correctCyclic() {
  var n=this.GRAPH.length;
  for(var i=0;i<n;++i) {
    var t=this.GRAPH[i];
    var a=this.COLOR[i];

    if(a[0]==a[1]) {
      t=swap(t,1,2);
      a=swap(a,1,2);
    }

    if(a[0]==a[1]) {
      t=swap(t,1,3);
      a=swap(a,1,3);
    }

    if(a[1]==a[2]) {
      t=swap(t,2,3);
      a=swap(a,2,3);
    }

  this.GRAPH[i]=[t[0],t[1],t[2],t[3]];
  this.COLOR[i]=[a[0],a[1],a[2],a[3]];
  }
}




function vertexNumber() {
  var n=PLAID.n;
  var count=0;
  for(var i=0;i<=2*n;++i) {
    for(var j=0;j<=2*n;++j) {
      for(var k=0;k<=2*n;++k) {
	if(this.USED[i][j][k].length>0) ++count;
      }
    }
  }
  return count;
}



function surfaceGraph(CAN) {
   if(this.FLAGS.length==0) return;
   var n=PLAID.n;
   this.initGraph();
   var count=0;
   for(var i=0;i<this.FLAGS.length;++i) {
     var x=this.lineToCubeArray(this.FLAGS[i]);
     var T=this.T[x[0]][x[1]][x[2]];
     var e=T.absoluteEdge(x[3]);
     var v0=e[0];
     var v1=e[1];
     var col=T.E[x[3]][2];

     for(var ii=0;ii<3;++ii) {
       if(v0[ii]==2*n) v0[ii]=0;
       if(v1[ii]==2*n) v1[ii]=0;
     }

     var g0=this.USED[v0[0]][v0[1]][v0[2]];
     var g1=this.USED[v1[0]][v1[1]][v1[2]];

     var L0=g0.length;
     var L1=g1.length;
     var used=false;
     if((L0==0)&&(L1==0)&&(used==false)) {
       g0[0]=[count,col];
       g1[0]=[count+1,col];
       count=count+2;
       used=true;
     }
     if((L0==0)&&(L1=!0)&&(used==false)) {
       g0[0]=[count,col]; 
       g1[L1]=[g0[0][0],col];
       count=count+1; 
       used=true;
     }

     if((L0!=0)&&(L1==0)&&(used==false)) {
       g1[0]=[count,col]; 
       g0[L0]=[g1[0][0],col];
       count=count+1; 
       used=true;
     }

     if((L0!=0)&&(L1!=0)&&(used==false)) {
       g0[L0]=[g1[0][0],col];
       g1[L1]=[g0[0][0],col]; 
       used=true;
     }
   }
   this.recordGraph();
   this.correctCyclic();
}



/**rendering*/

function surfaceRender(CAN,col) {  
   if(this.FLAGS.length==0) return;
   var draw = CANVAS.getContext('2d'); 
   var t=PLAID.TR;
   if(BLOCK.on==1) t=PLAID.TR2;
   draw.setTransform(t[0],t[1],t[2],t[3],t[4],t[5]);
   draw.strokeStyle=col;
   draw.lineWidth=4/t[0];
   for(var i=0;i<this.FLAGS.length;++i) {
     var p=this.surfaceSlice(this.FLAGS[i]);
     if(p!=undefined) {
          draw.stroke(p);
     }
   }
   draw.setTransform(1,0,0,1,0,0);
}


function surfaceSlice(n) {
  if(SLICE==0) return this.surfaceSlice0(n);
  if(SLICE==1) return this.surfaceSlice1(n);
  if(SLICE==2) return this.surfaceSlice2(n);
}

function surfaceSlice0(n) {
  var x=this.lineToCubeArray(n);
  if(x[2]%2==1) return undefined;
  var i=x[0];
  var j=x[1];
  var k=x[2];
  var T=this.T[i][j][k];
  if(T.E[x[3]][2]!=2) return undefined;
  if(k+T.E[x[3]][3]!=ZVAL.val) return undefined;
  var E=T.absoluteEdge(x[3]);
  var p=new Path2D();
  p.moveTo(E[0][0]/2,E[0][1]/2);
  p.lineTo(E[1][0]/2,E[1][1]/2);
  return p;
}



function surfaceSlice1(n) {
  var x=this.lineToCubeArray(n); 
  if(x[1]%2==1) return undefined;
  var i=x[0];
  var j=x[1];
  var k=x[2];
  var T=this.T[i][j][k];
  if(T.E[x[3]][2]!=1) return undefined
  if(j+T.E[x[3]][3]!=YVAL.val) return undefined
  var E=T.absoluteEdge(x[3]);
  var p=new Path2D();
  E=offsetImage(E);
  p.moveTo(E[0][0]/2,E[0][2]/2);
  p.lineTo(E[1][0]/2,E[1][2]/2);
  return p;
}


function offsetImage(E) {
  var F00=E[0][0];
  var F01=E[0][1];
  var F02=E[0][2];
  var F10=E[1][0];
  var F11=E[1][1];
  var F12=E[1][2];
  var z0=(F02+F12)/2;
  var z1=z0-2*PLAID.getOffset();
  if(z1<0) z1=z1+2*PLAID.n;
  F02=F02+(z1-z0);
  F12=F12+(z1-z0);
  return [[F00,F01,F02],[F10,F11,F12]];
}



function surfaceSlice2(n) {
  var x=this.lineToCubeArray(n); 
  if(x[0]%2==1) return undefined;
  var i=x[0];
  var j=x[1];
  var k=x[2];
  var T=this.T[i][j][k];
  if(T.E[x[3]][2]!=0) return undefined
  if(i+T.E[x[3]][3]!=XVAL.val) return undefined
  var E=T.absoluteEdge(x[3]);
  E=offsetImage(E);
  var p=new Path2D();
  p.moveTo(E[0][1]/2,E[0][2]/2);
  p.lineTo(E[1][1]/2,E[1][2]/2);
  return p;
}


function graphRender(CAN) {
  if(this.GRAPH.lenth==0) return;
  var draw = CAN.getContext('2d'); 
  draw.fillStyle='#000';
  draw.setTransform(1,0,0,1,0,0);
  draw.fillRect(500,0,500,500);
  if(BLOCK.on==1) draw.fillRect(0,0,1000,800);
  draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);

  for(var i=1;i<this.GRAPH.length;++i) {
  
    var z=this.POINTS[i];
    var I=this.GRAPH[i];
    for(var j=0;j<I.length;++j) {
      var k=I[j];
      var w=this.POINTS[k];
      if(k==0) {
          w=new Complex(1.2*z.x,1.2*z.y);
      }
      var cols=['#08f','#f60','#8f0'];

      var c1=this.COLOR[i][j];
      draw.strokeStyle=cols[c1];
      draw.lineWidth=2/TRANS[0]; 
      var p=new Path2D();
      p.moveTo(z.x,z.y);
      p.lineTo(w.x,w.y);
      draw.stroke(p);
    }
  }
  draw.setTransform(1,0,0,1,0,0);
}


function geomInit() {
  if(this.GRAPH.length==0) return;

  this.POINTS=[];
  for(var i=0;i<this.GRAPH.length;++i) {
    this.POINTS[i]=new Complex(0,0);
  }
  this.POINTS[0]=new Complex(100,100);
  var  H=this.GRAPH[0];
  this.POINTS[H[0]]=new Complex(1,0);
  this.POINTS[H[1]]=new Complex(0,1);
  this.POINTS[H[2]]=new Complex(-1,0);
  this.POINTS[H[3]]=new Complex(0,-1);
}


function geomUpdate0() {
  var n=this.GRAPH.length;
  if(n==0) return;
  var test=false;
  while(test==false) {
    var i=Math.floor(n*Math.random());
    var test2=onList(i,this.GRAPH[0]);
    if((test2==false)&&(i!=0)) test=true;
  }

  var z=new Complex(0,0);
  var E=this.GRAPH[i];
  for(var j=0;j<E.length;++j) {
    var k=E[j];
    z=cxAdd(z,this.POINTS[k]);
  }
  z.x=z.x/E.length;
  z.y=z.y/E.length;
  this.POINTS[i]=new Complex(z.x,z.y);
}
  

function geomUpdate(time) {
  var d=new Date();
  var t=d.getTime();
  var test=false; 
  while(test==false) {
    var d1=new Date();
    var t1=d1.getTime()-t;
    if(t1>time) test=true;
    this.geomUpdate0();
  }
}

