

function Tile(x) {
  this.x=x; 
  this.EYE=[.5,.5];
  this.FOCUS=0;
  this.VCOUNT=0;
  this.TAG=0;
  this.tileRender=tileRender;
  this.assemble=assemble;
  this.assembleVertices=assembleVertices;
  this.assembleEdges=assembleEdges;
  this.assembleFaces=assembleFaces;
  this.indexToFocus=indexToFocus;;
  this.focusToIndex=focusToIndex;
  this.faceVector=faceVector;
  this.absoluteEdge=absoluteEdge;
  this.absoluteVertex=absoluteVertex;
  this.absoluteCenters=absoluteCenters;
  this.triangleList=triangleList;
  this.tileAlign=tileAlign;
  this.tilePrint=tilePrint;
  this.tilePrintShort=tilePrintShort;
}


function tilePrint() {
  console.log("------tile------");
  console.log("location "+this.x);
  console.log("edge focus "+this.FOCUS);

  for(var i=0;i<this.V.length;++i) {
    var S0="   ";
    S0=S0+this.V[i][0][0].toString();
    S0=S0+this.V[i][0][1].toString();
    S0=S0+this.V[i][0][2].toString();
    S0=S0+" . ";
    S0=S0+this.V[i][1][0].toString();
    S0=S0+this.V[i][1][1].toString();
    S0=S0+this.V[i][1][2].toString();

    console.log("vertex "+i+S0);
  }


  for(var i=0;i<this.E.length;++i) {
    console.log("edge "+i.toString()+" connects vertices:  "+this.E[i][0]+" "+this.E[i][1]);
  }

  for(var i=0;i<this.F.length;++i) {
    console.log("vertex cycle "+i.toString()+"  "+this.F[i]);
  }

  console.log("----------------");
}

function tilePrintShort() {
  console.log("tile    "+this.x+"   "+this.FOCUS);
}


function assemble() {
  this.assembleVertices();
  this.E=[];
  this.F=[];
  if(this.VCOUNT>0) {
     this.assembleEdges();
     this.assembleFaces();
     this.FOCUS=0;
  }
}


function assembleFaces() {
  var E0=[];
  for(var i=0;i<this.ECOUNT;++i) {
    E0[i]=[this.E[i][0],this.E[i][1]];
  }
  this.F=getCycles(E0);
}


function assembleEdges() {
  this.ECOUNT=0;
  this.E=[];
  var v=this.VCOUNT;
  var count=0;
  for(var i=0;i<v;++i) {
    for(var j=i+1;j<v;++j) {
      var v1=this.V[i];
      var v2=this.V[j];
      var test=edgeTest(v1,v2,this.SPECIAL,this.TWIST);
      if(test[0]==true) {
	this.E[count]=[i,j,test[1],test[2]];
	++count;
      }
    }
  }
  this.ECOUNT=count;
}



function assembleVertices() {
  this.V=[];
  this.VCOUNT=0;
  var count=0;

  var SQ=[];

  for(var i=0;i<2;++i) {
    SQ=PLAID.squareCompute(0,this.x[2]+i,this.x[0],this.x[1]);

     if(SQ[0][0]==1) {
       this.V[count]=[[0,0,i],[1,0,i]];
       ++count;
     }

     if(SQ[1][0]==1) {
       this.V[count]=[[0,1,i],[1,1,i]];
       ++count;
     }

     if(SQ[2][0]==1) {
       this.V[count]=[[1,0,i],[1,1,i]];
       ++count;
     }

     if(SQ[3][0]==1) {
       this.V[count]=[[0,0,i],[0,1,i]];
       ++count;
     }
  }


  for(var i=0;i<2;++i) {
      SQ=PLAID.squareCompute(1,this.x[1]+i,this.x[0],this.x[2]);

     if(SQ[2][0]==1) {
       this.V[count]=[[1,i,0],[1,i,1]];
       ++count;
     }

     if(SQ[3][0]==1) {
       this.V[count]=[[0,i,0],[0,i,1]];
       ++count;
     }
  }

  this.TWIST=[];
  for(var i=0;i<2;++i) {
      SQ=PLAID.squareCompute(2,this.x[0]+i,this.x[1],this.x[2]);
      this.TWIST[i]=SQ[0][1];
  }
  this.VCOUNT=count;

  var s0=0;
  var s1=0;
  for(var i=0;i<count;++i) {
    var v=this.V[i];
    if((v[0][0]==0)&&(v[1][0]==0)) ++s0;
    if((v[0][0]==1)&&(v[1][0]==1)) ++s1;
  }
  this.SPECIAL=[s0,s1];
}




function tileRender(CAN) {
   var draw = CAN.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle='#000';
   if(this.VCOUNT==0) return;

   var p=[[0,0,0],[0,0,1],[0,1,0],[0,1,1],[1,0,0],[1,0,1],[1,1,0],[1,1,1]];
   var q1=new Path2D();

   for(var i=0;i<8;++i) {
     for(var j=0;j<8;++j) {
       var test=hamming(p[i],p[j]);
       if(test==1) {
	 var z0=project(p[i],this.EYE[0],this.EYE[1]);
	 var z1=project(p[j],this.EYE[0],this.EYE[1]);
	 q1.moveTo(z0[0],z0[1]);
	 q1.lineTo(z1[0],z1[1]);
       }
     }
   }

   draw.lineWidth=1/200;
   draw.strokeStyle='#888';
   draw.setTransform(450,0,0,450,510,40);
   draw.stroke(q1);


   draw.lineWidth=1/70;
   var cols=['#04f','#f40','#0a0'];
   for(var i=0;i<this.ECOUNT;++i) {
     draw.lineWidth=1/100;
     if(i==this.FOCUS) draw.lineWidth=1/40;
     var q2=new Path2D();
     var edge=this.E[i];
     draw.strokeStyle=cols[edge[2]];
     var j=edge[0];
     var k=edge[1];    
     var z0=toPoint(this.V[j],this.EYE[0],this.EYE[1]);
     var z1=toPoint(this.V[k],this.EYE[0],this.EYE[1]);
     q2.moveTo(z0[0],z0[1]);
     q2.lineTo(z1[0],z1[1]);
     draw.stroke(q2);
   }

   draw.fillStyle='#ff0';
   for(var i=0;i<this.VCOUNT;++i) {
     var q2=new Path2D();
     var z=toPoint(this.V[i],this.EYE[0],this.EYE[1]);
     q2.arc(z[0],z[1],.02,0,2*Math.PI);
     draw.fill(q2);
   }
}


/**The variable index gives the position in the cycle.*/

function indexToFocus(index) {
  var i0=index[0];
  var i1=index[1];
  var L=this.F[i0].length;
  var i2=(i1+1)%L;
  var v1=this.F[i0][i1];
  var v2=this.F[i0][i2];
  for(var i=0;i<this.ECOUNT;++i) {
    if(specialMatch([v1,v2],[this.E[i][0],this.E[i][1]])==true) return i;
  }
  return -1;
}

function focusToIndex(f) {
  var e=this.E[f];
  for(var k=0;k<2;++k) {
  var L=this.F[k].length;
  for(var i1=0;i1<L;++i1) {
    var i0=(i1-1+L)%L;
    var i2=(i2+1+L)%L;
    if(specialMatch([e[0],e[1]],[this.F[k][i0],this.F[k][i1]])==true) return [k,i0];
    if(specialMatch([e[0],e[1]],[this.F[k][i1],this.F[k][i2]])==true) return [k,i2];
  }}
  return undefined;

}

function specialMatch(a,b) {
  var temp=union(a,b);
  if(temp.length==2) return true;
  return false;
}


function faceVector() {
  var a0=this.E[this.FOCUS][0];
  var a1=this.E[this.FOCUS][1];
  var b0=this.V[a0];
  var b1=this.V[a1];
  var X=[0,0,0];

  for(var i=0;i<2;++i) {
    for(var j=0;j<3;++j) {
      if((b0[0][j]==i)&&(b0[1][j]==i)&&(b1[0][j]==i)&&(b1[1][j]==i)) {
	X[j]=2*i-1;
	return X;
      }
    }
  }
  return undefined;
}

/**everything is scaled up by a factor of 2*/

function absoluteEdge(f) {
  var a0=this.E[f][0];
  var a1=this.E[f][1];
  var c0=this.absoluteVertex(a0);
  var c1=this.absoluteVertex(a1);
  c=[c0,c1];
  return c;
}


function absoluteVertex(a) {
  var b=this.V[a];
  var c=[];
  for(var i=0;i<3;++i) {
    c[i]=2*this.x[i]+b[0][i]+b[1][i];
  }
  return c;
}

function absoluteCenters() {
  var L=this.F.length;
  var c=[];
  for(var i=0;i<L;++i) {
    c[i]=[0,0,0];
    var M=this.F[i].length;
    for(var j=0;j<M;++j) {
      var v=this.absoluteVertex(this.F[i][j]);
      for(var k=0;k<3;++k) {
	c[i][k]=c[i][k]+v[k]/M;
      }
    }
  }
  return c;
}

function triangleList() {
  var c=this.absoluteCenters();  
  var count=0;
  var LIST=[];
  var L=this.F.length; 
    for(var i=0;i<L;++i) {
      var M=this.F[i].length;
      for(var j=0;j<M;++j) {
	LIST[count]=[];
        var j2=(j+1)%M;
        LIST[count][0]=c[i];
        LIST[count][1]=this.absoluteVertex(this.F[i][j]);
        LIST[count][2]=this.absoluteVertex(this.F[i][j2]);
	++count;
      }
    }
    return toVectorList(LIST);
}


function toVectorList(LIST) {
  var LIST2=[];
  var L=LIST.length;
  for(var i=0;i<L;++i) {
    LIST2[i]=[];
    for(var j=0;j<3;++j) {
      LIST2[i][j]=new Vector(LIST[i][j]);
      LIST2[i][j]=scale(.5,LIST2[i][j]);
    }
  }
  return LIST2;
}



function tileAlign(edge0) {
   for(var i=0;i<this.ECOUNT;++i) {
     var edge1=this.absoluteEdge(i);
     var test=edgeMatch(edge0,edge1,PLAID.n);
     if(test==true) this.FOCUS=i;
   }
}

