/**Tests of a pair of vertices are part of an edge.*/

function edgeTest(v1,v2,special,twist) {
  for(var i=0;i<2;++i) {
    if((v1[0][2]==i)&&(v1[1][2]==i)&&(v2[0][2]==i)&&(v2[1][2]==i)) return [true,2,i];
    if((v1[0][1]==i)&&(v1[1][1]==i)&&(v2[0][1]==i)&&(v2[1][1]==i)) return [true,1,i];
    if((v1[0][0]==i)&&(v1[1][0]==i)&&(v2[0][0]==i)&&(v2[1][0]==i)) { 
      if(special[i]<4) return [true,0,i];
      var corner=commonCorner(v1,v2);
      if((hamming(corner,[0,0,0])==i)&&(twist[i]==1)) return [true,0,i];
      if((hamming(corner,[0,1,1])==i)&&(twist[i]==1)) return [true,0,i];
      if((hamming(corner,[0,0,1])==i)&&(twist[i]==0)) return [true,0,i];
      if((hamming(corner,[0,1,0])==i)&&(twist[i]==0)) return [true,0,i];

    }
  }
  return false;
}


function commonCorner(e1,e2) {
  for(var i=0;i<2;++i) {
    for(var j=0;j<2;++j) {
      if(hamming(e1[i],e2[j])==0) return e1[i];
    }
  }
  return -1;
}



function toPoint(X,A,B) {
  var Y=[];
  for(var i=0;i<3;++i) {
    Y[i]=X[0][i]+X[1][i];
    Y[i]=Y[i]/2;
  }
  var z=project(Y,A,B);
  return z
}


function project(p,A,B) {
  var q=[];
  if(SLICE==0) q=[p[0],p[1],p[2]];
  if(SLICE==1) q=[p[0],p[2],p[1]];
  if(SLICE==2) q=[p[1],p[2],p[0]];
  return project0(q,A,B);
}

function project0(p,A,B) {
  var a=p[0];
  var b=p[1];
  var c=p[2];
  var x0=(2*a+A*c)/(2+c);
  var x1=(2*b+B*c)/(2+c);
  return [x0,x1];
}





function hamming(a,b) {
  var total=0;
  for(var i=0;i<3;++i) {
    if(a[i]!=b[i]) ++total;
  }
  return total;
}

function average(a,b) {
  var c=[(a[0]+b[0])/2,(a[1]+b[1])/2];
  return c;
}

function getCycles(E) {
  var C0=getCycle(E,0);
  if(C0.length==E.length) return [C0];
  var i=newCycleIndex(C0,E);
  var C1=getCycle(E,i);
  return [C0,C1];
}

function getCycle(E,k) {
  var F=[E[k][0],E[k][1]];
  var test=false;
  while(test==false) {
    var t0=F.length;
    F=augment(F,E);
    var t1=F.length;
    if(t0==t1) test=true;
  }
  return F;
}


function edgeMatch(E0,E1,n) {
  var test=[[0,0],[0,0]];
  for(var i=0;i<2;++i) {
    for(var j=0;j<2;++j) {
      test[i][j]=edgeMatch0(E0[i],E1[j],n);
    }
  }
  if((test[0][0]==true)&&(test[1][1]==true)) return true;
  if((test[0][1]==true)&&(test[1][0]==true)) return true;
  return false;
}

function edgeMatch0(e0,e1,n) {
  for(var i=0;i<3;++i) {
    var a=e0[i]%(2*n);
    var b=e1[i]%(2*n);
    if(Math.abs(a-b)>.001) return false;
  }
  return true;
}

