



function Vector(x) {
  this.x=x;
  this.n=x.length;
  this.norm=norm;
  this.negate=negate;
  this.vectorPrint=vectorPrint;
}

function vectorPrint() {
  console.log("Vector");
  for(var i=0;i<this.n;++i) {
     console.log(this.x[i]);
  }
}

function negate() {
  for(var i=0;i<this.n;++i) {
    this.x[i]=-this.x[i];
  }
}

function norm() {
  var d=dot(this,this);
  return Math.sqrt(d);
}

function dot(V,W) {
  if(V.n!=W.n) return undefined;
  var tot=0;
  for(var i=0;i<V.n;++i) {
    tot=tot+V.x[i]*W.x[i];
  }
  return tot;
}

function cross(V,W) {
  if(V.n!=3) return undefined;
  if(W.n!=3) return undefined;
  var x0=V.x[1]*W.x[2]-V.x[2]*W.x[1];
  var x1=V.x[2]*W.x[0]-V.x[0]*W.x[2];
  var x2=V.x[0]*W.x[1]-V.x[1]*W.x[0];
  var X=new Vector([x0,x1,x2]);
  return X;
}

function add(V,W) {
  if(V.n!=W.n) return undefined;
  var X=[];
  for(var i=0;i<V.n;++i) {
    X[i]=V.x[i]+W.x[i];
  }
  return new Vector(X);
}

function subtract(V,W) {
  if(V.n!=W.n) return undefined;
  var X=[];
  for(var i=0;i<V.n;++i) {
    X[i]=V.x[i]-W.x[i];
  }
  return new Vector(X);
}

function scale(r,V) {
  var W=[];
  for(var i=0;i<V.n;++i) {
    W[i]=r*V.x[i];
  }
  return new Vector(W);
}

function vectorDist(V,W) {
  var X=subtract(V,W);
  var d=dot(X,X);
  return Math.sqrt(d);
}

/**strait projection*/
function fromSphereX(V) {
  return [V.x[0],V.x[1]];
}

/**makes the vector a unit*/

function unit(V) {
  var d=Math.sqrt(dot(V,V));
  return scale(1/d,V);
}


