import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class AGLattice {

    public static Path2D.Double grid(int k,int p,int q,int i0,int i1) {
	Path2D.Double gp=new Path2D.Double();
	Complex z=AGTransforms.p2kAffine(p,q,new Complex(i0,i1));
	int i=(int)(z.x);
	int j=(int)(z.y);
	Complex z1=new Complex(i+0,j+0);
	Complex z2=new Complex(i+0,j+1);
	Complex z3=new Complex(i+1,j+1);
	Complex z4=new Complex(i+1,j+0);
	Complex z5=new Complex(i-1,j+1);
	z1=AGTransforms.k2pAffine(p,q,z1);
	z2=AGTransforms.k2pAffine(p,q,z2);
	z3=AGTransforms.k2pAffine(p,q,z3);
	z4=AGTransforms.k2pAffine(p,q,z4);
	z5=AGTransforms.k2pAffine(p,q,z5);

	Complex w0=new Complex(0,0);
	if(k==0)w0=z4;
	if(k==1)w0=z2;
	if(k==2)w0=z3;
	if(k==3)w0=z5;

	Complex w1=Complex.plus(w0.scale(-1),z1.scale(2));
	gp.moveTo(w0.x,w0.y);
	gp.lineTo(w1.x,w1.y);
	return(gp);
    }


    /**Finds the nearest AG Grid*/

    public static Complex nearestGrid(int p,int q,double x,double y) {
	Complex z=new Complex(x,y);
	return nearestGrid(p,q,z);
    }

    public static Complex nearestGrid(int p,int q,Complex z) {
        Complex z1=AGTransforms.p2kAffine(p,q,z);
	double x2=Math.floor(z1.x+.5);
	double y2=Math.floor(z1.y+.5);
	int xx=(int)(x2);
	int yy=(int)(y2);
	for(int i=xx-2;i<=xx+2;++i) {
	    for(int j=yy-2;j<=yy+2;++j) {
		Complex z2=new Complex(i,j);
	        Complex z3=AGTransforms.k2pAffine(p,q,z2);
		if(linked(z,z3)==true) return(z3);
	    }
	}
	return null;
    }


    public static Complex shortVector(int p,int q,int i,int j) {
	Complex z1=new Complex(i,j);
	Complex z2=new Complex(0,0);
	z1=AGTransforms.k2pAffine(p,q,z1);
	z2=AGTransforms.k2pAffine(p,q,z2);
	Complex z=Complex.minus(z1,z2);
	return(z);
    }

    /**Tests if w is in the unit square centered at z*/

    public static boolean linked(Complex z,Complex w) {
	if(Math.abs(z.x-w.x)>.499999) return false;
	if(Math.abs(z.y-w.y)>.499999) return false;
	return(true);
    }


    public static boolean goodPoint(int p,int q,double x,double y) {
	Complex z=nearestGrid(p,q,x,y);
	if(z==null) return false;
	return true;
    }


}