import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


 public class AGMap {

     public AGMap() {}


     /**Here is the forward graph PET dynamics.
        We don't need the backwards case*/

     public static Vector4 graphDynamics(Vector4 V0) {
	V0=reduce(V0);
	int[] t=graphType(V0);
	int m1=t[0];
	int m2=t[1];
	double A=V0.x[3];
        double d0=m1*A+m2+(m2-m1);
	double d1=m1*A+m2-(m2-m1);
	double d2=m1*A+m2-(m2-m1);
	Vector4 V1=Vector4.plus(V0,new Vector4(d0,d1,d2,0));
	V1=AGMap.reduce(V1);
	return V1;
    }



     /**This tells the type for the curve following dynamics*/

     public static int[] forwardMap(int p,int q,double m,double n) {
	 Vector4 W=PSI(p,q,m,n);
	 int[] t={0,0};
	 t=graphType(W);
	 return t;
     }

    public static int[] graphType(Vector4 W0) {
	int i = graphIndex(W0);
	return DataGraphPolytopes.type(i);
    }

    public static int graphIndex(Vector4 W) {
	for(int i=0;i<28;++i) {  
            Polytope POLY=AllPolytopes.graph(i);
	    if(POLY.contains(W)==true) return i;
	}
	return -1;
    }


     /**Here is the map Psi from the monograph. */

     public static Vector4 PSI(int p,int q,double m,double n) {
	 double A=1.0*p/q;
         double s=1.0*p*m/q+n+.5/q;
	 double t=m-n;
	 Vector4 V=new Vector4(s+t,s-t,s-t,A);
	 return reduce(V);
     }



     /**lattice reduction algorithms*/


     /**This is the final routine.
        fundamental domain is [0,2] x [-1,A] x [0,1+A]**/

     public static Vector4 reduce(Vector4 V0) {
	 double A=V0.x[3];
	 double[] u=reduceLattice(A,V0.x[0],V0.x[1],V0.x[2]);
	 Vector4 V1=new Vector4(u[0],u[1],u[2],A);
	 return V1;
     }

     /**Warning: The first and last coordinates are in a different order
        than is used in the final routine.*/

     public static double[] reduceLattice(double A,double x1,double x2,double x3) {
	 double r1=reduceVector(-2,2,x3,x1);
	 double r2=reduceVector(-2,2,x2,x1);
	 double n1=reduceVector(1-A,1+A,r1,r2);      
	 double X1=fractionalPart(1+A,n1);      
         double X2=fractionalPart(1+A,r2);      
	 double[] z={fractionalPart(2,x1),X2,X1};
	 if(z[1]>A) {z[1]=z[1]-1-A;z[2]=z[2]-1+A;}
	 if(z[2]<0) z[2]=z[2]+1+A;
	 return(z);
     }

     public static double reduceVector(double v1,double v2,double x1,double x2) {
	 double number=Math.floor(x2/v2);
	 return(x1-v1*number);
     }



     public static double fractionalPart(double x) {
	 return(x-Math.floor(x));
     }

     public static double fractionalPart(double d,double x) {
	 double y=d*fractionalPart(x/d);
	 return(y);
     }




 }
