import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;


public class AGPlot {

    /**For the arithmetic graph*/

    public static void blockPlot(Manager M,Graphics2D g) {
	int p=M.p();
	int q=M.q();
 	double A=1.0*p/q;
	int[] LL=M.P.getLimits();
	int k=LL[0]/(LL[1]-LL[0]);
	Path2D.Double BOX=periodBox(p,q,k);
	int[] L2=GraphicsHelp.getLimits(BOX);
	Path2D.Double gp=new Path2D.Double();

	for(int i=L2[0]-4;i<L2[2]+4;++i) {
	    for(int j=L2[1]-4;j<L2[3]+4;++j) {
		int[] test=AGMap.forwardMap(p,q,i,j);
		int i1=i+test[0];
		int j1=j+test[1];
	       if((BOX.contains(i,j)==true)&&(BOX.contains(i1,j1)==true)) {
		   Complex z0=AGTransforms.k2pAffine(p,q,new Complex(i,j));
		   Complex z1=AGTransforms.k2pAffine(p,q,new Complex(i1,j1));
	           gp.moveTo(z0.x,z0.y);
		   gp.lineTo(z1.x,z1.y);
		}
	    }
	}
	gp=M.P.transform(gp);
	g.setColor(M.C.AG.M[0].C);
	g.setStroke(new BasicStroke(2));
	g.fill(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }

    /**Gets the bounding box for the arithmetic graph*/

    public static Path2D.Double periodBox(int p,int q,int k) {
	Path2D.Double gp=new Path2D.Double();
 	double t=.00001;
	double s=p+q;
	double[][] d={{k-t,-1-t},{k-t,1+t},{k+1+t,1+t},{k+1+t,-1-t}};
	for(int i=0;i<4;++i) {
	    Complex u=new Complex(s*d[i][0],s*d[i][1]);
	    Complex z=AGTransforms.p2kAffine(p,q,u);
	    if(i==0) gp.moveTo(z.x,z.y);
	    if(i!=0) gp.lineTo(z.x,z.y);
	}
	gp.closePath();
	return(gp);
    }





    public static void firstPolygon(Manager M,Graphics2D g,boolean trans) {
        Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	double A=1.0*p/q;
	double LIM=50000;
	int count=0;
	int closed=0;	
	int[] pos=new int[2];

	int halt=1;
	gp.moveTo(0,0);
	Complex z=AGTransforms.k2pAffine(p,q,new Complex(0,0));
	gp.moveTo(0,0);
	if(trans==true) gp.moveTo(z.x,z.y);

       	while((halt==1)&&(count<LIM)) {
	    int[] test=AGMap.forwardMap(p,q,pos[0],pos[1]);

	    pos[0]=pos[0]+test[0];
	    pos[1]=pos[1]+test[1];
	    z=AGTransforms.k2pAffine(p,q,new Complex(pos[0],pos[1]));
	    if(trans==false) gp.lineTo(pos[0],pos[1]);
	    if(trans==true) gp.lineTo(z.x,z.y);
	    if((pos[0]==0)&&(pos[1]==0)) closed=1;
	    if(closed==1) halt=0;
	    ++count;
	}
	halt=0;
	gp=M.P.transform(gp);
	g.setColor(M.C.AG.M[1].C);
	g.setStroke(new BasicStroke(2));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }



    public static void drawAGLattice(Manager M,Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	int[] L=M.P.getLimits();
	for(int k=0;k<4;++k) {
	    int t=M.C.GRID.L[k].on;
	    if(t==1) {
		for(int i=-L[0]-1;i<L[1]+1;++i) {
	          for(int j=-1;j<L[1]-L[0]+1;++j) {
		     gp=AGLattice.grid(k,p,q,i,j);
		     gp=M.P.transform(gp);
	             g.setColor(M.C.AG.M[2].C);
	             g.draw(gp);
		  }
	       }
	    }
	}
    }


    public static void nearestGrid(Manager M,Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	Complex z=M.P.SOURCE;
	z=AGLattice.nearestGrid(p,q,z);
	if(z==null) return;

	int par=AGparity(p,q,z);

	for(int i=0;i<100;++i) {
	    double t=2*Math.PI*i/100;
	    double c=z.x+.15*Math.cos(t);
	    double s=z.y+.15*Math.sin(t);
	    if(i==0) gp.moveTo(c,s);
	    if(i!=0) gp.lineTo(c,s);
	}


	gp.closePath();
	gp=M.P.transform(gp);
	g.setColor(M.C.AG.M[5].C);
	if(par==0) g.fill(gp);
	g.draw(gp);
    }

    /**This gets the parity for the orientations*/

    public static int AGparity(int p,int q,Complex z) {
	Complex w=AGTransforms.p2kAffine(p,q,z);
	int m=(int)(Math.floor(w.x+.5));
	double A=1.0*p/q;
	double test2=10000+(A+1)*m+0.5/q; //guarantee positive
	int par=(int)(test2);
	par=(par)%2;

	System.out.println(test2+" "+par);

	return par;
    }









    public static void drawPixelFail(Manager M,Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int[] L=M.P.getLimits();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=0;j<L[1]-L[0];++j) {
              if(AGLattice.goodPoint(p,q,i+.5,j+.5)==true) {
		  Tile T=new Tile(p,q,i,j);
                  Path2D.Double gp=T.getSquare();
		  gp=M.P.transform(gp);
		  g.setColor(new Color(30,40,50));
		  g.fill(gp);
		  g.setColor(M.C.MODEL.M[2].C);
		  g.draw(gp);
	      }
	    }
	}
    }



}

