import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class AGTransforms {

    /**This is the image of (0,0) under the canonical
       map which maps the plaid plane to the kite plane.*/

    public static Complex kiteZero(int p,int q) {
	int t=MathRational.tune(p,q,1);
	double x=(-1.0-2.0*q*t)/(2*p+2*q);
	double y=(-1.0+2.0*p*t)/(2*p+2*q);
	if(t%2==0) {
	  x=x-q;
	  y=y+p;
	}
	return new Complex(x,y);
    }

    /**This is the image of (0,0) under the canonical
       map which maps the arithmetic graph 
       (kite) plane to the plaid plane.*/

    public static Complex plaidZero(int p,int q) {
	int t=MathRational.tune(p,q,1);
	double x=+1.0/(2*q);
	double y=-1.0/(2*q)+1.0/(p+q)+t;
	if(t%2==0) y=y+(p+q);
	return new Complex(x,y);
    }

    /**This is the linear map which maps the plaid plane
       to the kite plane*/

    public static Complex p2kLinear(double A,Complex Z) {
	double[] V2=vectorV2(A);
	double[] V1=vectorV1(A);
	double x=Z.y*V2[0]+Z.x*V1[0];
	double y=Z.y*V2[1]+Z.x*V1[1];
	Complex Z1=new Complex(x,y);
	return(Z1);
    }

    /**This is the affine map which maps the plaid plane
       to the (kite) arithmetic graph plane*/

    public static Complex p2kAffine(int p,int q,Complex Z) {
	double A=1.0*p/q;
	Complex W=p2kLinear(A,Z);
	W=Complex.plus(W,kiteZero(p,q));
	return W;
    }


    /**arithmetic graph (kite) to plaid*/

    public static Complex k2pLinear(double A,Complex Z) {
	double[] W1=vectorW1(A);
	double[] W2=vectorW2(A);
	double x=Z.y*W2[0]+Z.x*W1[0];
	double y=Z.y*W2[1]+Z.x*W1[1];
	Complex Z1=new Complex(x,y);
	return(Z1);
    }

    public static Complex k2pAffine(int p,int q,Complex Z) {
	double A=1.0*p/q;
	Complex W=k2pLinear(A,Z);
	W=Complex.plus(W,plaidZero(p,q));
	return W;
    }


    /**These are used for the p2k map: plaid to kite*/

    public static double[] vectorV1(double A) {
	double[] X=new double[2];
        X[0]=2.0*A/((1+A)*(1+A));
	X[1]=X[0]+(1-A)/(1+A);
	return(X);
    }

    public static double[] vectorV2(double A) {
	double P=2.0*A/(1+A);
	double[] X=new double[2];
	X[0]=1-P/2;
	X[1]=-P/2;
	return(X);
    }

    /**These are used for the k2p map: kite to plaid*/

    public static double[] vectorW1(double A) {
	double[] X=new double[2];
        X[0]=A;
	X[1]=(-A*A+2*A+1)/(1+A);
	return(X);
    }

    public static double[] vectorW2(double A) {
	double[] X=new double[2];
	X[0]=1.0;
	X[1]=-2*A/(1+A);
	return(X);
    }




}







