import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class retrieves the the polytopes from the 4 partitions:
-graph PET partition
-plaid PET partition
-graph triple partition 
-plaid triple partition
All polytopes are in the triple partitions  scaled up by 60 to clear denominators. */

public class AllPolytopes {

    public static Polytope graph(int k) {
	int[][] P1=DataGraphPolytopes.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	int[] type=DataGraphPolytopes.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }

    public static Polytope plaid(int k) {
	int[][] P1=DataPlaidPolytopes.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	int[] type=DataPlaidPolytopes.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }


    public static Polytope inCleanPartition(int k) {
	int k2=k%95;
	int[][] P1=DataCleanPartition.data(k2);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	    X.V[i]=X.V[i].scale(1.0/60);
	}
	int[] code=DataCleanPartition.type(k2);
	X.type[1]=code[0];
	X.type[2]=code[1];
	X.code[0]=code[0];
	X.code[1]=code[1];
	X.code[2]=code[2];
	X.code[3]=code[3];
	if(k>=95) return PlaidPolytopeMoves.I(X);
	return(X);
    }

    /**This is the set Z from the monograph.  It is
       the domain for the orbit equivalence theorem*/

    public static Polytope ZPiece(int k) {
	int[][] P1=DataZPartition.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	return(X);
    }

    /**Here is a special case, just Z+*/
    public static Polytope ZPlus() {
	return ZPiece(0);
    }

}


