import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener,MouseListener,MouseMotionListener {
    Manager M;
    PopupManager PM;
    Parameter PAR;
    ListenSquare GO,HALT,RESET0,RESET1,RESET2,RESET3;
    ControlPanel PRESET,MAIN,PLAID,GRAPH,EXPORT,CAPACITY,
	DEBUG,SANITY,PROOF,GRID,CUBE,DRAWSTYLE;
    ControlPanelColor MODEL,AG,HITSET,SPACETIME;
    Debug DEB;
    SelectInteger GRAPH_HIGHLIGHT;  //part of partition debugger
    ColorSelector CS;
    ScaleConsole SCA;
    WallConsole WAL;
    ListenSquare[] RESET=new ListenSquare[9];
    int PARTICLE;
    Lever AUTO;
    SelectInteger KAPPA,FRAME;  //spacetime diagram capacity
    Lever KAPPA2;
    SelectInteger CAPACITY2;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 PM=new PopupManager(M,120,65);
	 PAR=new Parameter(230,0,"2/9");
	 GO=new ListenSquare(120,260,50,25);
	 HALT=new ListenSquare(165,260,50,30);
	 DEB=new Debug();
	 for(int i=0;i<9;++i) RESET[i]=new ListenSquare(423*i/9,255,20,20);
	 CS=new ColorSelector(0,470,330,50);
	 ControlPanelSetup.setPanels(this);
	 SCA=new ScaleConsole(-298,-100);
	 WAL=new WallConsole(0,275);
	 PARTICLE=0;
	 GRAPH_HIGHLIGHT=new SelectInteger(25,305,60,30,0,0,28,1);
	 KAPPA=new SelectInteger(5,390,40,20,2,2,50,2);
	 FRAME=new SelectInteger(5,350,40,20,0,-50,50,1);
	 KAPPA2=new Lever(5,435,0,4);
	 CAPACITY2=new SelectInteger(45,380,35,18,2,2,100,2);

     }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,0,100));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawControls(Graphics2D g) { 
	PM.M=this.M;
	PM.render(g);
	PAR.render(g);
	MAIN.render(g,0,0,115); 
        CS.render(g);   
        SCA.render(g);

	if(MAIN.mode==0) {
           MODEL.render(g,0,175,115);
	   CAPACITY.render(g,0,350,115);
	   DRAWSTYLE.render(g,0,405,115);
	   if(CAPACITY.mode==1) 
           CAPACITY2.render(g,Color.blue,Color.white,Color.white);
	}

	if(MAIN.mode==1) {
           AG.render(g,0,175,115);
	   if(AG.L[2].on==1) GRID.render(g,0,295,115);
	}
	if(MAIN.mode==2) {
            HITSET.render(g,0,175,115);	
	}

	if(MAIN.mode==3) {
            PLAID.render(g,0,175,115);
	}


	if(MAIN.mode==4) {
            GRAPH.render(g,0,175,115);
	    GRAPH_HIGHLIGHT.render(g,Color.red,Color.white,Color.white);
	}

	if(MAIN.mode==5) {
	    SPACETIME.render(g,0,175,115); 
	    FRAME.render(g,Color.red,Color.white,Color.white);
	    KAPPA.render(g,Color.red,Color.white,Color.white);
	    KAPPA2.render(g,"H  H  V  V",Color.red);
	    g.drawString("frame",70,FRAME.y+13);
	    g.drawString("capacity",70,KAPPA.y+13);
	}

	if(MAIN.mode==6) {
	    CUBE.render(g,0,175,115); 
	}

	if(MAIN.mode==7) {
	    SANITY.render(g,0,175,115);
            if(SANITY.L[1].on==1) WAL.render(g);
	}

	if(MAIN.mode==8) {
	    drawDebugger(g);
	}

	if(MAIN.mode==9) {
             EXPORT.render(g,0,175,115); 
             renderGo(g);
	}

	if(MAIN.mode==10) {
             PROOF.render(g,0,175,115);
	     renderGo(g);
	}

	if(MAIN.mode==11) {
             PRESET.render(g,0,175,115);
	}
    }	


    public void drawDebugger(Graphics2D g) {
       DEBUG.render(g,0,175,115);  
       boolean test=DEB.isRunning();
       if(test==false) renderGo(g);
       if(test==true)  renderHalt(g);
    }

    public void renderGo(Graphics2D g) { 
         g.setFont(new Font("Helvetica",Font.PLAIN,14));
         GO.render(g,new Color(0,200,0)); 
         g.drawString("go",(int)(GO.x+5),(int)(GO.y+18));
    }

    public void renderHalt(Graphics2D g) { 
         g.setFont(new Font("Helvetica",Font.PLAIN,14));
         HALT.render(g,new Color(200,0,0));
	 g.drawString("halt",(int)(HALT.x+5),(int)(HALT.y+18));
    }


    public void spacetimeSelect(Point X) {
	KAPPA.modify(X);
	KAPPA2.process(X);
	FRAME.modify(X);
	int t1=KAPPA.isModified(X);
	int t2=KAPPA2.isUsed(X);
	if((t1==1)||(t2!=-1)) {
	    try{
		int p=M.p();
		int q=M.q();
		int w=p+q;
		int t=MathRational.tune(p,q,1);
		if(t>w/2) t=w-t;
		int v=KAPPA.val;
		if(v<=w-1) {
		   int n=(t*KAPPA.val/2)%w;
		   if(KAPPA2.val==0) M.ST.Z=new Complex(.5,n);
		   if(KAPPA2.val==1) M.ST.Z=new Complex(.5,w-n);
		   if(KAPPA2.val==2) M.ST.Z=new Complex(n,.5);
		   if(KAPPA2.val==3) M.ST.Z=new Complex(w-n,.5);
		}
	    }
	    catch(Exception e) {}
	}
    }


    public void doPanels(Point X) {
 	MAIN.switchMode(X);
	if(MAIN.mode==0) MODEL.process(X,M.color());
	if(MAIN.mode==0) CAPACITY.switchMode(X);
	if(MAIN.mode==0) CAPACITY2.modify(X);
	if(MAIN.mode==0) DRAWSTYLE.switchMode(X);
	if(MAIN.mode==1) AG.process(X,M.color());
	if(MAIN.mode==1) GRID.toggle(X);
	if(MAIN.mode==2) HITSET.process(X,M.color());
	if(MAIN.mode==3) PLAID.toggle(X);
	if(MAIN.mode==4) GRAPH.toggle(X);
	if(MAIN.mode==4) GRAPH_HIGHLIGHT.modify(X);
	if(MAIN.mode==5) SPACETIME.process(X,M.color());
	if(MAIN.mode==6) CUBE.switchMode(X);
	if(MAIN.mode==7) SANITY.toggle(X);
	if(MAIN.mode==8) DEBUG.switchMode(X);
	if(MAIN.mode==9) EXPORT.toggle(X);
	if(MAIN.mode==10) PROOF.switchMode(X);
    }

    /**Needs fixing*/
    public void documentStuff(Point X) {
	try{
	  if(MAIN.L[20].inside(X)==1) DocumentControl.main0(M.D);


	  if(CAPACITY.L[20].inside(X)==1) DocumentControl.capacity(M.D);

	  if(MAIN.mode==0) {
	    if(MODEL.L[20].inside(X)==1) DocumentControl.plaid(M.D);
	  }

	  if(MAIN.mode==1) {
	    if(AG.L[20].inside(X)==1) DocumentControl.ag(M.D);
	  }

	  if(MAIN.mode==2) {
	    if(HITSET.L[20].inside(X)==1) DocumentControl.hitset(M.D);
	  }

	  if(MAIN.mode==3) {
	    if(PLAID.L[20].inside(X)==1) DocumentControl.plaidPET(M.D);
	  }

	  if(MAIN.mode==4) {
	  }

	  if(MAIN.mode==5) {
	     if(SPACETIME.L[20].inside(X)==1) DocumentControl.spacetime(M.D);
	  }

	  if(MAIN.mode==7) {
	     if(SANITY.L[20].inside(X)==1) DocumentControl.sanity(M.D);
	  }

	  if(MAIN.mode==8) {
	     if(DEBUG.L[20].inside(X)==1) DocumentControl.debug(M.D);
	  }

	  if(MAIN.mode==9) {
	     if(EXPORT.L[20].inside(X)==1) DocumentControl.export(M.D);
	  }

	  if(MAIN.mode==10) {
	     if(PROOF.L[20].inside(X)==1) DocumentControl.proof(M.D);
	  }

	  if(MAIN.mode==11) {
	     if(PRESET.L[20].inside(X)==1) DocumentControl.preset(M.D);
	  }

	  if(SCA.INFO.inside(X)==1) DocumentControl.scale(M.D);

	  if(CS.INFO.inside(X)==1)  DocumentControl.colors(M.D);

	}
	catch(Exception e){}
    }

    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e); 
	SCA.M=this.M;
	WAL.M=this.M;
	PM.process(J.X); 
        PAR.process(e,M);
	SCA.process(J.X);
	doPanels(J.X);
	WAL.process(J.X,CS.C);
	CS.process(e); 

	if(MAIN.mode==5) spacetimeSelect(J.X);

	if(MAIN.mode==8) {  
           if(GO.inside(J.X)==1) DEB.go(M);
	   if(HALT.inside(J.X)==1) DEB.halt(M);
	}
	if(MAIN.mode==9) {
	    if(GO.inside(J.X)==1) Export.main(this.M);
	}

	documentStuff(J.X);
	M.repaint();
    }


    public void mousePressed(MouseEvent e) {
    }
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);  
	M.repaint();

     }


    public void keyTyped(KeyEvent e) {
        PAR.processKey(e);
   	M.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

