import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class sets the control panels for the control canvas.*/

public class ControlPanelSetup {

    public static void setPanels(ControlCanvas C) {

         Color[] A0={new Color(80,140,255),
                     Color.white,
                     Color.white,
                     Color.black,
                     Color.red};

         Color[] A1={new Color(200,0,255),
                     Color.white,
                     Color.white,
                     Color.black,
                     Color.yellow};


	 Color[] C1={new Color(255,255,255),
                     new Color(255,150,0),
                     new Color(0,0,220),
                     new Color(50,100,255),
                     new Color(255,255,0),
                     new Color(255,100,100),
                     new Color(100,100,255),
                     new Color(255,200,0),
		     new Color(0,200,0),
                     new Color(255,255,255)};

	 Color[] C2={new Color(100,150,255),
                     new Color(255,100,0),
                     new Color(0,160,160),
		     new Color(0,0,0),
                     new Color(255,100,00),
                     new Color(255,200,0)};

	 Color[] C3={new Color(255,255,255,100),
		     new Color(255,0,0),
		     new Color(50,100,255),
		     new Color(200,0,0),
		     new Color(0,0,200),
                     new Color(255,255,255),
                     new Color(0,0,0),
                     new Color(0,0,0),
                     new Color(0,0,0)};

         Color[] C4={new Color(0,0,0),
                     new Color(50,50,50),
		     new Color(100,100,100),
                     new Color(255,100,50),
		     new Color(80,150,255),
		     new Color(140,140,140),
                     new Color(255,200,0),
                     new Color(0,80,255)};


	 //main
	 String[] MainString={
	    "plaid model",
	    "arithmetic graph",
	    "grid analyzer",
	    "plaid PET",
	    "graph PET",
	    "spacetime diag",
	    "cube",
	    "sanity checks",
	    "debug",
            "export",
            "control panels"};
	 int[] MainState={1,0,0,0,0,0,0,0,0,0};
         C.MAIN=new ControlPanel(A1,MainString,MainState,10);

	 //planar plaid model

	 String[] BasicString={
	    "polygons",
	    "big polygon",
            "grid",
	    "polygon tracer",
	    "light points",
	    "(-)slant lines",
	    "(+)slant lines", 
            "directions",
	    "hexagrid",
            "oriented tiles",
            "plaid model"};
	 int[] BasicState={1,0,1,0,0,0,0,0,0,0};
         C.MODEL=new ControlPanelColor(A0,BasicString,BasicState,10,C1);


	 //arithmetic graph
	 String[] CompareString={
            "polygons",
	    "first polygon",
	    "grid",
	    "grid full",
	    "1st poly aff",
	    "nearest grid",
            "arithmetic graph"};
	 int[] CompareState={0,0,0,0,0,0};
         C.AG=new ControlPanelColor(A0,CompareString,CompareState,6,C2);

	 //spacetime window
	 String[] SpacetimeString={
            "background",
	    "grid",
	    "worldlines",
	    "pixellated H",
	    "pixellated V",
	    "frame",
	    "marker",
	    "low capacity",
            "spacetime diagram"};
	 int[] SpacetimeState={1,1,1,0,0,0,0,0,0};
         C.SPACETIME=new ControlPanelColor(A0,SpacetimeString,SpacetimeState,8,C4);


	 //plaid PET window
	 String[] PlaidString={
	    "basic partition",
	    "clean partition",
	    "Z+",
	    "Z--",
	    "Z'+",
	    "Z'--",
	    "Z tiling",
	    "hitset (Z*)",
	    "hit set hi",
	    "hit set lo",
	    "direction reminder",
            "plaid PET"};
	 int[] PlaidState={1,0,0,0,0,0,0,0,0,0,0};
         C.PLAID=new ControlPanel(A0,PlaidString,PlaidState,11);


	 //graph PET window
	 String[] GraphString={
	     "partition","piece highlight","direction reminder","graph PET"};
	 int[] GraphState={1,0,0};
         C.GRAPH=new ControlPanel(A0,GraphString,GraphState,3);


	 //graph grid options
	 String[] GridString={
	     "1,0",
	     "0,1",
	     "1,1",
	     "-1,1",
	     "grid display"};
	     int[] GridState={1,1,0,0};
         C.GRID=new ControlPanel(A0,GridString,GridState,4);

	 //limit capacity
	 String[] CapString={
	     "no", 
             "yes",
             "limit capacity"};
	 int[] CapState={1,0,0};
         C.CAPACITY=new ControlPanel(A0,CapString,CapState,2);

	 //drawing style
	 String[] StyleString={
	     "direct", 
             "boxy",
             "drawstyle"};
	 int[] StyleState={1,0,0};
         C.DRAWSTYLE=new ControlPanel(A0,StyleString,StyleState,2);


	 //graph hitset options
	 String[] HitsetString={
	     "hitset",
	     "low set",
	     "high set",
	     "low set image",
	     "high set image",
	     "frame",
	     "cursor",
	     "pointer raw",
	     "pointer",
	     "hitset display"};
	 int[] HitsetState={1,0,0,0,0,0,1,0,0};
	     C.HITSET=new ControlPanelColor(A1,HitsetString,HitsetState,9,C3);

	 //sanity checks
	 String[] SanityString={
	     "plaid class map",
	     "images by type",
	     "plaid V particle",
	     "plaid H particle",
	     "plaid hit set",
	      "sanity checks"};
	 int[] SanityState={0,0,0,0,0,0};
         C.SANITY=new ControlPanel(A0,SanityString,SanityState,5);

	 //cube surface shading

	 String[] CubeString={
	     "none",
	     "gray",
	     "color",
	     "surface shading"};
	 int[] CubeState={1,0,0};
         C.CUBE=new ControlPanel(A0,CubeString,CubeState,3);
	 C.CUBE.mode=0;



	 //export system
	 String[] ExportString={
            "square grid",
            "slanting lines",
            "light points",
            "plaid polygons",
	    "first plaid poly",
            "arithmetic graph",
	    "individual poly",
	    "selected lines",
	    "hitset",
	    "hitset frame",
	    "hitset partition1",
	    "hitset partition2",
	    "spacetime",
            "export"};
	 int[] ExportState={0,0,0,0,0,0,0,0,0,0,0,0,0};
         C.EXPORT=new ControlPanel(A0,ExportString,ExportState,13);


	 //debug system
	 String[] DebugString={
            "coincidence",
            "reconstruction",
	    "plaid class map",
	    "plaid2graph map",
	    "plaid dynamics",
	    "graph dynamics",
	    "renorm theorem",
	    "orbit equiv thm.",
	    "Z is dyn large",
	    "AG transforms",
	    "core copy lemma",
            "debug"};
	 int[] DebugState={1,0,0,0,0,0,0,0,0,0,0,0};
         C.DEBUG=new ControlPanel(A0,DebugString,DebugState,11);

    }



}

