import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Cube extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Output OUT;
    Point JX;
    Complex Z;
    double[] EYE=new double[3];

     public Cube() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,200,100);
	 Z=new Complex();
	 EYE[0]=.2;
	 EYE[1]=.3;
	 EYE[2]=4;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTiles(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(150,150,150));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawTiles(Graphics2D g) {
	drawCube(g);
	Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	int x=(int)(Math.floor(Z.x));
	int y=(int)(Math.floor(Z.y));
	drawTile(g,p,q,x,y);

    }

    public void drawTile(Graphics2D g,int p,int q,int x,int y) {
	 int[][] c=tilePoints(g,p,q,x,y);
	 g.setStroke(new BasicStroke(3));
         Color C0=new Color(255,255,255);
	 Color C1=new Color(255,100,0);
	 Color C2=new Color(70,130,255);
         Color CC0=new Color(255,255,255,80);
	 Color CC1=new Color(255,180,0,80);
	 Color CC2=new Color(70,130,255,80);
 	 Color[] C={C0,C0,C1,C1,C2,C2};
 	 Color[] CC={CC0,CC0,CC1,CC1,CC2,CC2};
	 int[][][] A=generateCycles(c);

	 Path2D.Double gp=new Path2D.Double();

	 for(int i=0;i<A.length;++i) {
	     double[] cen = center(A[i]);
	     Complex w=project(EYE,cen);
	     for(int j=0;j<A[i].length;++j) {
		 int j0=j;
		 int j1=(j+1)%A[i].length;
		 gp.reset();
		 Complex z0=project(EYE,pointd(A[i][j0][0],A[i][j0][1]));
		 Complex z1=project(EYE,pointd(A[i][j1][0],A[i][j1][1]));
		 gp.moveTo(w.x,w.y);
		 gp.lineTo(z0.x,z0.y);
		 gp.lineTo(z1.x,z1.y);
		 gp.closePath();
 	         if(M.C.CUBE.mode==0) g.setColor(new Color(0,0,0,0));
 	         if(M.C.CUBE.mode==1) g.setColor(new Color(255,255,255,80));
 	         if(M.C.CUBE.mode==2) g.setColor(CC[A[i][j0][0]]);
		 gp=transform(gp);
		 g.fill(gp);
		 gp.reset();
		 g.setColor(C[A[i][j0][0]]);
        	 gp.moveTo(z0.x,z0.y);
		 gp.lineTo(z1.x,z1.y);
		 gp=transform(gp);
		 g.draw(gp);
	     }
	 }
	g.setStroke(new BasicStroke(1));
    }


    public static int[][] tilePoints(Graphics2D g,int p,int q,int x,int y) {

	int w=p+q;
        int t=MathRational.tune(p,q,p+q-1);
	int[] X={x,x+w*t,x,x,x,x+1};
	int[] Y={y,y,y,y+1,y,y};
	int[] A={-1,-1,0,0,1,1};

	int[][] c=new int[6][4];

	for(int i=0;i<6;++i) {

	if(i<2) {
	    Tile T=new Tile(p,q,X[i],Y[i]);
	   Complex[] POINTS=PlaidModel.getPoints(T);
	   c[i]=PlaidModel.getCount(T,POINTS);
	}

	if(i>1) c[i]=getTile(p,q,X[i],Y[i],A[i]);
	}
	for(int i=0;i<6;++i) c[i]=recode(c[i]);
	return c;
    }

    public static double[] center(int[][] A) {
	double[] d={0,0,0};
	for(int i=0;i<A.length;++i) {
	    int[] b=point(A[i][0],A[i][1]);
	    for(int j=0;j<3;++j) d[j]=d[j]+1.0*b[j]/A.length;
	}
	return d;
    }


    public static int[] recode(int[] a) {
	int sum=a[0]+a[1]+a[2]+a[3];
	if(sum==2) {
            for(int i=0;i<4;++i) {
	      for(int j=i+1;j<4;++j) {
		if((a[i]==1)&&(a[j]==1)) {
		    int[] b={i,j,i,j};
		    return b;
		}
	      }
	    }
	}
	if(sum==4) {
	    int[] b={0,1,2,3};
	    return b;
	}

	if(sum==6) {
            int[] b={0,3,1,2};
	    return b;
	}
	int[] b={-1,-1,-1,-1};
	return b;
    }

    /**This finds the cycle structure on the cube*/



    public static void printCycle(int[][] A) {
	for(int i=0;i<A.length;++i) System.out.print(A[i][0]+""+A[i][1]+" ");
	System.out.println("");
    }


    public static int[][][] generateCycles(int[][] c) {
	int[][][] LIST0=new int[24][12][2];
	int count=0;
	for(int i=0;i<6;++i) {
	    for(int j=0;j<4;++j) {
		int[] a={i,j};
		int[][] A=cycle(c,a);
		boolean test=onCycleList(A,LIST0,count);
		if(test==false) {
		    LIST0[count]=A;
		    ++count;
		}
	    }
	}
	int[][][] LIST1=new int[count][12][2];
	for(int i=0;i<count;++i) LIST1[i]=LIST0[i];
	return LIST1;
    }


    public static boolean onCycleList(int[][] A,int[][][] LIST,int count) {
	if(A==null) return true;
	for(int i=0;i<count;++i) {
	    if(cycleEqual(A,LIST[i])==true) return true;
	}
	return false;
    }


    public static boolean cycleEqual(int[][] A1,int[][] A2) {
	if(A1==null) return false;
	if(A2==null) return false;
	if(A1.length!=A2.length) return false;
	int n=A1.length;
	for(int i=0;i<n;++i) {
	    for(int j=0;j<n;++j) {
		int[] p1=point(A1[i][0],A1[i][1]);
		int[] p2=point(A2[j][0],A2[j][1]);
		if(equal(p1,p2)==true) return true;
	    }
	}
	return false;
    }


    public static int[][] cycle(int[][] c,int[] a) {
	int[] b=next1(a);
	if(a[0]>b[0]) return null;
	b=next(c,a);
	if(equal(a,b)==true) return null;
	int[][] A1=new int[13][2];
	int count=0;
	boolean test=false;
	A1[0]=a;
	while((count<12)&&(test==false)) {
	    ++count;
	    A1[count]=next(c,A1[count-1]);
	    test=equal(A1[count],a);
	}
	if(count==12) return null;
	int[][] A2=new int[count][2];
	for(int i=0;i<count;++i) A2[i]=A1[i];
	return A2;
    }



    public static int[] next(int[][] c,int[] a) {
	int[] b=next0(c,a);
	if(equal(b,a)==true) return a;
	return next1(b);
    }

    public static int[] next0(int[][] c,int[] a) {
	int[] b0={0,1,2,3};
	int[] b1={1,0,3,2};
	for(int i=0;i<4;++i) {
	    if(c[a[0]][b0[i]]==a[1]) {
		int[] A={a[0],c[a[0]][b1[i]]};
		return A;
	    }
	}
	return a;
    }

    public static int[] next1(int[] a) {
	int[] p1=point(a[0],a[1]);
	for(int i=0;i<6;++i) {
	    for(int j=0;j<4;++j) {
		int[] p2=point(i,j);
		if(i!=a[0]) {
		    if(equal(p1,p2)==true) {
			int[] A={i,j};
			return A;
		    }
		}
	    }
	}
	return a;
    }

    public static boolean equal(int[] p1,int[] p2) {
	for(int i=0;i<p1.length;++i) {
	    if(p1[i]!=p2[i]) return false;
	}
	return true;
    }


    /**Done with routines finding cycle structure of cube*/



    public static int[] getTile(int p,int q,int n1,int n2,int choice) {

	Complex[][] LINES=new Complex[0][0];
	int[] n=new int[4];
	int k1=Spacetime.whichBlockRaw(p,q,n1);	
        int k2=Spacetime.whichBlock(p,q,n1);
	int nn1=n1-k1*(p+q);

	if(choice==0) LINES=Spacetime.getLinesH(p,q,n2);
	if(choice==1) LINES=Spacetime.getLinesV(p,q,nn1);
	int i=0;
	int j=k2;
	if(choice==0) i=nn1;
	if(choice==1) i=n2;
	if(i>p+q) i=i-p-q;
	if(i<0) i=i+p+q;
	if(choice==0) return Spacetime.tileHNums(p,q,LINES,i,j);
	if(choice==1) return Spacetime.tileVNums(p,q,LINES,i,j);
	return null;
    }

    public static Complex[] list(double[] eye,int choice) {
	int[][] b=vectorList(choice);
	double[][] bb=new double[4][3];
	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		bb[i][j]=b[i][j];
	    }
	}
	Complex[] z=project(eye,bb);
	return z;
    }



    public static int[] point(int i,int j) {
	int[][] a=vectorList(i);
	return a[j];
    }

    public static double[] pointd(int i,int j) {
	int[][] a=vectorList(i);
	int[] aa=a[j];
	double[] b={aa[0],aa[1],aa[2]};
	return b;
    }

    public static int[][] vectorList(int choice) {
	if(choice==0) return list0();
	if(choice==1) return list1();
	if(choice==2) return list2();
	if(choice==3) return list3();
	if(choice==4) return list4();
	if(choice==5) return list5();
	return null;
    }

    public static int[][] list0() {
	int[][] b={{0,-1,-1},{-1,0,-1},{0,1,-1},{1,0,-1}};
	return b;
    }


    public static int[][] list1() {
	int[][] b={{0,-1,1},{-1,0,1},{0,1,1},{1,0,1}};
	return b;
    }

    public static int[][] list2() {
	int[][] b={{0,-1,-1},{-1,-1,0},{0,-1,1},{1,-1,0}};
	return b;
    }

    public static int[][] list3() {
	int[][] b={{0,1,-1},{-1,1,0},{0,1,1},{1,1,0}};
	return b;
    }


    public static int[][] list4() {
	int[][] b={{-1,0,-1},{-1,-1,0},{-1,0,1},{-1,1,0}};
	return b;
    }

    public static int[][] list5() {
	int[][] b={{1,0,-1},{1,-1,0},{1,0,1},{1,1,0}};
	return b;
    }


    public void drawCube(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();

	double[][][] b={
            {{-1,-1,1},{1,-1,1},{1,1,1},{-1,1,1}},
            {{-1,-1,-1},{1,-1,-1},{1,1,-1},{-1,1,-1}}};
	Color[] C={new Color(50,50,50),new Color(50,20,20),new Color(20,20,50)};

	for(int k=0;k<3;++k) {
	for(int j=0;j<2;++j) {
	  gp.reset();
	  Complex[] w=new Complex[4];
	  for(int i=0;i<4;++i) {
	      w[i]=project(EYE,cycle(b[j][i],k));
	       if(i==0) gp.moveTo(w[0].x,w[0].y);
	       if(i!=0) gp.lineTo(w[i].x,w[i].y);
	  }
	  gp=transform(gp);
	  g.setColor(C[k]);
	  g.fill(gp);
	}}

	g.setColor(new Color(100,100,100));
	for(int k=0;k<3;++k) {
	   gp.reset();
	   for(int i=-1;i<=1;i=i+2) {
	     for(int j=-1;j<=1;j=j+2) {
		double[] b1={i,j,-1};
		double[] b2={i,j,+1};
		b1=cycle(b1,k);
		b2=cycle(b2,k);
		Complex z1=project(EYE,b1);
		Complex z2=project(EYE,b2);
		gp.moveTo(z1.x,z1.y);
		gp.lineTo(z2.x,z2.y);
		gp=transform(gp);
		g.draw(gp);
	     }
	   }
	}

    }


    public double[] cycle(double[] b,int k) {
	double[] c={b[k%3],b[(k+1)%3],b[(k+2)%3]};
	return c;
    }



    /**Point projection of b from a to the plane z=0*/

    public static Complex project(double[] a,double[] b) {
	double x=(a[2]*b[0]-a[0]*b[2])/(a[2]-b[2]);
	double y=(a[2]*b[1]-a[1]*b[2])/(a[2]-b[2]);
	Complex z=new Complex(x,y);
	return z;
    }

    public static Complex[] project(double[] a,double[][] b) {
	Complex[] z=new Complex[b.length];
	for(int i=0;i<4;++i) z[i]=project(a,b[i]);
	return z;
    }



    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  {
             SOURCE=unTransform(JX);
	     EYE[0]=-SOURCE.x;
	     EYE[1]=-SOURCE.y;
	}
	repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
     }
  
     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
        SOURCE=unTransform(J.X);
	EYE[0]=-SOURCE.x;
	EYE[1]=-SOURCE.y;
	repaint();
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

