import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;


public class Debug {

    DebugReconstruction SR;
    DebugPlaidToGraph PG;
    DebugCoincidence CO;
    DebugPlaidClassifier PC;
    DebugPlaidDynamics DP;
    DebugGraphDynamics DG;
    DebugFirstReturn DF;
    DebugOrbitEquivalence DD;
    DebugDynLarge DL;
    DebugAGTransforms DA;
    DebugCore DC;

    public Debug() {
	SR=new DebugReconstruction();
	PG=new DebugPlaidToGraph();
	CO=new DebugCoincidence();
	PC=new DebugPlaidClassifier();
	DP=new DebugPlaidDynamics();
	DG=new DebugGraphDynamics();
	DF=new DebugFirstReturn();
	DD=new DebugOrbitEquivalence();
	DL=new DebugDynLarge();
	DA=new DebugAGTransforms();
	DC=new DebugCore();
    }

    public boolean isRunning() {
	if(SR.HALT==false) return true;
	if(PG.HALT==false) return true;
	if(CO.HALT==false) return true;
	if(PC.HALT==false) return true;
	if(DP.HALT==false) return true;
	if(DG.HALT==false) return true;
	if(DD.HALT==false) return true;
	if(DF.HALT==false) return true;
	if(DL.HALT==false) return true;
	if(DA.HALT==false) return true;
	if(DC.HALT==false) return true;
	return(false);
    }

    public void go(Manager M) {
	int a=M.C.DEBUG.mode;
 	if(a==0) new Thread(CO).start();
	if(a==1) new Thread(SR).start();
	if(a==2) new Thread(PC).start();
	if(a==3) new Thread(PG).start();
	if(a==4) new Thread(DP).start();
	if(a==5) new Thread(DG).start();
	if(a==6) new Thread(DF).start();
	if(a==7) new Thread(DD).start();
	if(a==8) new Thread(DL).start();
	if(a==9) new Thread(DA).start();
	if(a==10) new Thread(DC).start();
    }

    public void halt(Manager M) {
	CO.HALT=true;
	SR.HALT=true;
	PC.HALT=true;
	PG.HALT=true;
	DP.HALT=true;
	DG.HALT=true;
	DD.HALT=true;
	DF.HALT=true;
	DL.HALT=true;
	DA.HALT=true;
	DC.HALT=true;
    }
}


