public class DebugAGTransforms implements Runnable{
    boolean HALT=true;


    public void run() {
	HALT=false;
	while(HALT==false) {
	  testBaseCase();
	}

    }

    /**This picks a random parameter and
       checks that our formulas for T and T^{-1}
       really are inverses of each other*/

    public static void testMaps() {
	int[] a=random();
	Complex Z_graph=randomLattice();
	int p=a[0];
	int q=a[1];

	int tau=MathRational.tune(p,q,1);
	int omega=p+q;
	double A=1.0*p/q;

	System.out.println("--------------------------------");
	System.out.println("parameter "+p+" "+q+" "+A);
	System.out.println("widehat tau "+tau);
	System.out.println("omega "+omega);

	System.out.println("point in graph plane (Z^2 point)");
	Z_graph.print();

	System.out.println("transformed point in plaid plane");
	Complex Z_plaid=AGTransforms.k2pAffine(p,q,Z_graph);
	Z_plaid.print();

	System.out.println("inverse applied to plaid point");
	Complex test=AGTransforms.p2kAffine(p,q,Z_plaid);
	test.print();

	double d=Complex.dist(test,Z_graph);
	if(d>.00000001) throw new ProofException("inverse fail");

	double m=mu(p,q,Z_plaid.x,Z_plaid.y);
	System.out.println("mu value "+m);
	double m_floor=Math.floor(m+.5);
	d=Math.abs(m-m_floor);
	if(d>.00000001) throw new ProofException ("mu not integer");

	Vector4 V1=Psi(p,q,Z_plaid);
	Vector4 V2=AGMap.PSI(p,q,Z_graph.x,Z_graph.y);
	d=Vector4.dist2(V1,V2);
	System.out.println("Psi");
	V1.print();
	System.out.println("Psi'' compose T^{-1}");
	V2.print();
	if(d>.00000001) throw new ProofException ("maps don't agree");
    }


    /**Tests the base case from the intertwining Lemma
       in Chapter 19.*/

    public static void testBaseCase() {

	int[] a=random();
	Complex Z_graph=randomLattice();
	int p=a[0];
	int q=a[1];

	int tau=MathRational.tune(p,q,1);
	int omega=p+q;
	double A=1.0*p/q;
	int theta=0;
	if(tau%2==0) theta=1;

	System.out.println("----------------");
	Complex z=new Complex((1.0+A)/2.0,(1.0-A)/2.0);

	Vector4 V=PlaidClassifyingMap.PHI(A,.5,.5);
	V.print();
	double m=mu(p,q,(1+A)/2,(1-A)/2);
	double b=(1+A)/2;
	Vector4 W=new Vector4(b+1,b-1,b-1,A);

	Vector4 X=PlaidToGraph.omega(V);


	W=AGMap.reduce(W);
        X=AGMap.reduce(X);
        W.print();
        X.print();
	double d=Vector4.dist2(W,X);
	if(d>.00000001) throw new ProofException("identity fails");
    }





    public static double mu(int p,int q,double x,double y) {
	double A=1.0*p/q;
	double m=1 + (x*(A-1)+y*(A+1))/(1+A);
	return m;
    }



    public static int[] random() {
	boolean test=false;
	int[] a={};
	int max=100;
	int min=2;
	int diff=2;

	while(test==false) {
	   int c=1+(int)(max*Math.random());
	   int b=1+(int)(Math.min(c,max*Math.random()));  
           a=MathRational.reduce(b,c);
           if((a[0]>=min)&&(a[1]-a[0]>=diff)&&(a[0]*a[1]%2==0)) test=true;
	}
	return(a);
    }

    public static Complex randomLattice() {
	int m=(int)(50-100*Math.random());
	int n=(int)(50-100*Math.random());
	return new Complex(m,n);
    }


    /**Here is the formula for Psi given in the monograph, Ch 17*/
    public static Vector4 Psi(int p,int q,Complex z) {
	double m=mu(p,q,z.x,z.y);
	double x=z.x;
	double A=1.0*p/q;
	Vector4 V=new Vector4(x+m,x-m,x-m,A);
	V=AGMap.reduce(V);
	return V;
    }


}


