import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.Arrays;
import java.math.*;

/**This file tests whether any of the graph lattice
   points lie on the edges of unit squares**/

public class DebugCoincidence implements Runnable {
    boolean HALT=true;

    public void run() {
	HALT=false;
	int p=1;
	int q=2;
	while(HALT==false) {
	    boolean test=testCoincidence(p,q);
	    if(test==true) throw new ProofException("coincidence");
	    ++p;
	    if(p==q) {
		++q;
		p=1;
	    }
	}
    }


    public boolean testCoincidence(int p,int q) {
	if(MathRational.GCD(p,q)!=1) return false;
	if((p*q)%2==1) return false;
	System.out.print("coincidence test "+p+"/"+q+"  ");
	int w=p+q;
	double tol=1.0/(4*q*q);
	for(int i=0;i<w*w;++i) {
	    for(int j=0;j<w;++j) {
	        Complex z=new Complex(i+.5,j+.5);
                Complex w1=AGLattice.nearestGrid(p,q,i+.5,j+.5);
		if(w1!=null) {
		  double x=w1.x-Math.floor(w1.x);
		  double y=w1.y-Math.floor(w1.y);
		  if(Math.abs(x)<tol) return true;
		  if(Math.abs(y)<tol) return true;
		  if(Math.abs(1-x)<tol) return true;
		  if(Math.abs(1-y)<tol) return true;
		}
	    }
	}
	System.out.println("done");
	return false;
    }




}


