public class DebugCore implements Runnable {
    boolean HALT=true;

    public  void run() {
	System.out.println("------------------------");
	int[] P=randomParameter();
	P[0]=49;
	P[1]=74;

	table1Print(P[0],P[1]);

	System.out.println("parameter "+P[0]+"/"+P[1]);
	int p1=P[0];
	int q1=P[1];
	P=MathRational.corePredecessor(p1,q1);
	System.out.println("core pred "+P[0]+"/"+P[1]);
	int p2=P[0];
	int q2=P[1];
	int w1=p1+q1;
	int w2=p2+q2;
	System.out.println("omega "+w1);
	System.out.println("omega_bar "+w2);
	int tau1=MathRational.tune(p1,q1);
	int tau2=MathRational.tune(p2,q2);
	System.out.println("tau "+tau1);
	System.out.println("tau_bar "+tau2);
	int eta1=w1-2*tau1;
	int eta2=w2-2*tau2;
	System.out.println("equality test eta "+eta1+" "+eta2);

	int top1=(w1+w2)/2;
	int top2=top1+2*tau2;
	System.out.println("central top "+top1);
	System.out.println("peripheral top "+top2);

	int kappa=MathRational.kappa(p1,q1);
	System.out.println("kappa "+kappa);

	int masstop=DebugCopySupport.FP(p1,q1,top1);
	System.out.println("central top mass       "+masstop);

	int tricky1=top1+eta1;
	int wierdmass1=DebugCopySupport.FP(p1,q1,tricky1);
	int tricky2=tricky1-w2;
	int wierdmass2=DebugCopySupport.FP(p1,q1,tricky2);


	if(tricky1<top2) {
	  System.out.println("wierd point,peripheraltop,omega "+tricky1+" "+top2+" "+w1);
	  System.out.println("wierd point mass peripheral "+wierdmass1);
	  System.out.println("wierd point mass central    "+wierdmass2);
	}


    }



    public int[] randomParameter() {

	boolean test=false;
	while(test==false) {
	    int p=(int)(50*Math.random());
	    int q=(int)(50*Math.random());
	    q=p+q;
	    int[] P=MathRational.reduce(p,q);
	    p=P[0];
	    q=P[1];
	    if((p*q)%2==0) {
	       int c=MathRational.classify(p,q);
	       if(c==2) {
		   test=true;
		   return P;
	       }
	    }
	}
	return null;
    }




    public  void runX() {
	int p=1;
	int q=2;
	HALT=false;
	while(HALT==false) {
	   int[] P=MathRational.reduce(p,q);
	   int k=test(P[0],P[1]);
	   if(k==-1)  throw new ProofException("core test fails");
	   ++p;
	   if(p==q) {
	       p=1;
	       ++q;
	   }
	}
    }


    public  int test(int p,int q) {
	if((p*q)%2==1) return(0);
	int c=MathRational.classify(p,q);
	if(c!=2) return(0);
	System.out.print("core copy test "+p+"/"+q+" ");
	int[] A=MathRational.corePredecessor(p,q);
	int[][] c1=table1(A[0],A[1]);
	int[][] c2=table2(p,q);
	signCompare(p,q);
	minValue(p,q);
	System.out.println("done");
	return(DebugCopySupport.match(c1,c2));
    }

    public  int[][] table1(int p,int q) {
	int t=MathRational.tune(p,q);
	int[] a=DebugCopySupport.spectrumPQ(p,q,0,p+q+2*t);
	int[] b=DebugCopySupport.spectrumH(p,q,t);
	return(DebugCopySupport.table(a,b));
    }

    public  int[][] table2(int p,int q) {
	int[] A=MathRational.corePredecessor(p,q);	
	int t=MathRational.tune(A[0],A[1]);
        int offset=(p+q-A[0]-A[1])/2;
	int[] a=DebugCopySupport.spectrumPQ(p,q,offset,offset+A[0]+A[1]+2*t);
	int[] b=DebugCopySupport.spectrumH(p,q,t);
	return(DebugCopySupport.table(a,b));
    }


    /**This checks that the signs do not switch, except
       for the special maximal mass*/

    public  void  signCompare(int p,int q) {
	int[] A=MathRational.corePredecessor(p,q);
	int t=MathRational.tune(A[0],A[1]); 
        int offset=(p+q-A[0]-A[1])/2;
	int[] m1=DebugCopySupport.spectrumPQ(A[0],A[1],-2*t,A[0]+A[1]+2*t);
	int[] c1=DebugCopySupport.spectrumH(A[0],A[1],t);
	int[] m2=DebugCopySupport.spectrumPQ(p,q,offset-2*t,offset+A[0]+A[1]+2*t);
	int[] c2=DebugCopySupport.spectrumH(p,q,t);

	boolean FAIL=false;
	for(int i=0;i<c1.length;++i) {
	    if(c1[i]*c2[i]<0) FAIL=true;
	}

	for(int i=0;i<m1.length;++i) {
	    int mm2=m2[i];
	    if(mm2<0) mm2=-mm2;
	    if((mm2<A[0]+A[1])&&(m1[i]*m2[i]<0)) FAIL=true;
	}

	if(FAIL==true) {
	    table1Print(p,q);
            System.out.println(1/0);
	}


    }


    /**This checks the minimum value property*/

    public  void  minValue(int p,int q) {
	int[] A=MathRational.corePredecessor(p,q);
	int t=MathRational.tune(A[0],A[1]); 
        int offset=(p+q-A[0]-A[1])/2;
	int[] m2=DebugCopySupport.spectrumPQ(p,q,offset,offset+A[0]+A[1]);

	int min=20000;
	for(int i=0;i<m2.length;++i) {
	    int qq=m2[i];
	    if(qq<0) qq=-qq;
	    if((qq>1)&&(min>qq)) min=qq;
	}
	int kappa=MathRational.kappa(p,q);
	if(min<4*kappa+2) {
	    System.out.println("                 "+p+"/"+q);
	}
    }




    public  void  table1Print(int p,int q) {
	System.out.println("--------------");
	System.out.println(p+"/"+q);
	int[] A=MathRational.corePredecessor(p,q);
	int t=MathRational.tune(A[0],A[1]); 
      
        int offset=(p+q-A[0]-A[1])/2;
	int[] m1=DebugCopySupport.spectrumPQ(A[0],A[1],-2*t,A[0]+A[1]+2*t);
	int[] c1=DebugCopySupport.spectrumH(A[0],A[1],t);
	int[] m2=DebugCopySupport.spectrumPQ(p,q,offset-2*t,offset+A[0]+A[1]+2*t);
	int[] c2=DebugCopySupport.spectrumH(p,q,t);

	printout("core mass",m1);
	printout("core cap.",c1);
	printout("curr mass",m2);
	printout("curr cap.",c2);

    }

    public void printout(String S,int[] a) {
	System.out.println(S);
	for(int i=0;i<a.length;++i) System.out.print(a[i]+" ");
	System.out.println("");
    }



}


