import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**This is the debugging file for the Renormalization Theorem
   in the monograph.  We test both directions of the dynamics*/

public class DebugFirstReturn implements Runnable {
    boolean HALT=true;
    int[] LIST=new int[100];
    int COUNT;

    public void run() {
	HALT=false;
	COUNT=0;
	int[] TRY={0,0,0};
	COUNT=0;
	while(HALT==false) {
	    Vector4 V=randomPlaid();
	    int test=dynamicsHitset(V);

	      System.out.print("first return theorem: ");
	      System.out.print("win "+TRY[2]+"  ");
	      System.out.print("lose "+TRY[0]+"  ");
	      System.out.print("tie "+TRY[1]);
	      System.out.println("");

	    ++TRY[test+1];
	}
    }


    public static int dynamicsHitset(Vector4 V0) {
	boolean test=inHitset(V0);
	if(test==false) return 0;
	Vector4 W0=PlaidToGraph.omega(V0);
	Vector4 V1=hitsetPlaidDynamics(V0);
	Vector4 W1=AGMap.graphDynamics(W0);
	Vector4 X1=PlaidToGraph.omega(V1);
	double d=Vector4.dist2(W1,X1);
	if(d<.0000001) return 1;
	return(-1);
    }




    public static Vector4 hitsetPlaidDynamics(Vector4 V0) {
	boolean test=false;
	Vector4 V1=new Vector4(V0);
	int count=0;
	while(test==false) {
	    ++count;
	    V1=PlaidClassifyFast.plaidDynamics(V1);
	    test=inHitset(V1);
	}
	return V1;
    }

    public static Vector4 randomPlaid() {
	double x=10*Math.random()-5;
	double y=10*Math.random()-5;
	double z=10*Math.random()-5;
	double P=Math.random();
	Vector4 V=new Vector4(x,y,z,P);
	V=PlaidClassifyingMap.reduce(V);
	return V;
    }


    public static boolean inHitset(Vector4 V) {
	double P=V.x[3];
	for(int a1=-3;a1<=3;++a1) {
	for(int a2=-3;a2<=3;++a2) {
	    PolygonWrapper PO1=Hitset.hitsetLo(P,a1,a2);
	    Path2D.Double gp1=PO1.toPath2D();
	    if(gp1.contains(V.x[0],V.x[1])==true) return true;

	    PolygonWrapper PO2=Hitset.hitsetHi(P,a1,a2);
	    Path2D.Double gp2=PO2.toPath2D();
	    if(gp2.contains(V.x[0],V.x[1])==true) return true;
	}}
	return false;
    }

    /**not in use*/
    public static boolean inHitset2(Vector4 V) {
	for(int a1=-3;a1<=3;++a1) {
	for(int a2=-3;a2<=3;++a2) {
	    Polytope X=AllPolytopes.ZPiece(0);
	    X=PlaidPolytopeMoves.shift(a1,a2,0,X);
	    if(X.contains(V)==true) return true;
	}}
	return false;
    }





}





