import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**This routine checks that the classifying map
conjugates the arithmetic graph curve following
dynamics to the AG Pet dynamics.*/


public class DebugGraphDynamics implements Runnable {
    boolean HALT=true;
    int[] TRY=new int[2];
 

    public void run() {
	HALT=false;

	while(HALT==false) { 
            int t=doDynamics();
	    ++TRY[t]; 
            if(TRY[1]%20==0) {
		System.out.print("graph dynamics ");
		System.out.print("win "+TRY[1]+" ");
		System.out.print("lose "+TRY[0]);
		System.out.println("");
	    }
	    doDynamics();
	}


    }


    public static int doDynamics() {
	int[] a=randomParameter();
	int p=a[0];
	int q=a[1];
	double A=1.0*p/q;
	int[] mm=randomGrid();
	int m0=mm[0];
	int n0=mm[1];
	int[] test=AGMap.forwardMap(p,q,m0,n0);
	int m1=m0+test[0];
	int n1=n0+test[1];
	Vector4 V0=AGMap.PSI(p,q,m0,n0);  
	Vector4 W1=AGMap.PSI(p,q,m1,n1);
	Vector4 V1=graphDynamics(V0);
	double t=Vector4.dist2(V1,W1);
	if(t<.0000001) return 1;
	return 0;
    }


    public static Vector4 graphDynamics(Vector4 V0) {
	int[] t=AGMap.graphType(V0);
	int m1=t[0];
	int m2=t[1];
	double A=V0.x[3];
        double d0=m1*A+m2+(m2-m1);
	double d1=m1*A+m2-(m2-m1);
	double d2=m1*A+m2-(m2-m1);
	Vector4 V1=Vector4.plus(V0,new Vector4(d0,d1,d2,0));
	V1=AGMap.reduce(V1);
	return V1;
    }




    public static int[] randomGrid() {
	int m=(int)(200*Math.random()-100);
	int n=(int)(200*Math.random()-100);
	int[] mm={m,n};
	return mm;
    }

    public static int[] randomParameter() {
	boolean test=false;
	int[] a={};

	while(test==false) {
	   int c=1+(int)(100*Math.random());
	   int b=1+(int)(Math.min(c,100*Math.random()));  
           a=MathRational.reduce(b,c);
           if((a[0]>=2)&&(a[1]-a[0]>=2)&&(a[0]*a[1]%2==0)) test=true;
	}
	return(a);
    }


}





