import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This tests the orbit equivalence theorem.*/

public class DebugOrbitEquivalence implements Runnable {
    boolean HALT=true;
    int[][] LIST=new int[1000][2];
    int COUNT;
    int win,lose;

    public void run() {
	HALT=false;
	COUNT=0;
	win=0;
	lose=0;
	while(HALT==false) {

            int random=(int)(95*Math.random());

	    Polytope P=AllPolytopes.inCleanPartition(random);
	    Vector4 V=random(P);

	    int test=dynamicsCatch(V);
	    if(test==-1) ++lose;
	    else ++win;
	    Vector4 W=PlaidToGraph.omega(V);
	    int index=AGMap.graphIndex(W);

	    if(win%1000==0) System.out.println("win/lose "+win+" "+lose);

            int[] temp={random,index,test};

	    if(ListHelp.onList(temp,LIST,COUNT)==false) {
		LIST[COUNT]=temp;
		++COUNT;
		printout();
		System.out.println("-----"+COUNT+"-----");
	    }
	}
    }

    public int dynamicsCatch(Vector4 V0) {
	Vector4 W0=PlaidToGraph.omega(V0);
        Vector4 W1=AGMap.graphDynamics(W0);
	Vector4 V1=new Vector4(V0);
	for(int i=0;i<2;++i) {
	   V1=PlaidClassifyFast.plaidDynamics(V1);
	   Vector4 X1=PlaidToGraph.omega(V1);
	   double d=Vector4.dist2(W1,X1);  
	   if(d<.0000001) {
                 return i;
	   }
	}
	return(-1);
    }

    public int dynamicsCatchTemp(Vector4 V0) {
	Vector4 W0=PlaidToGraph.omega(V0);
        Vector4 W1=AGMap.graphDynamics(W0);
	Vector4 V1=new Vector4(V0);
	for(int i=0;i<2;++i) {
	   V1=PlaidClassifyFast.plaidDynamics(V1);
	   Vector4 X1=PlaidToGraph.omega(V1);
	   double d=Vector4.dist2(W1,X1);  
	   if((i==1)&&(d<.0000001)) {
                 return i;
	   }
	}
	return(-1);
    }


    public Vector4 random(Polytope P) {
	int n=P.count;
	double[] d=new double[n];
	double sum=0;
	for(int i=0;i<n;++i) {
            d[i]=Math.random();
	    sum=sum+d[i];
	}
	for(int i=0;i<n;++i) d[i]=d[i]/sum;

	Vector4 SUM=new Vector4();
	for(int i=0;i<n;++i) {
	    SUM=Vector4.plus(SUM,P.V[i].scale(d[i]));
	}
	return SUM;
    }




    public void printout() {
	System.out.println("----------");
	System.out.print("{");

	for(int choice=0;choice<95;++choice) {

	for(int i=0;i<COUNT;++i) {
	    if(LIST[i][0]==choice) {
	      printout(LIST[i]);
	      if(i<COUNT-1) System.out.print(",");
	    }
	}
	}
	System.out.println("");
    }


    public void printout(int[] k) {
	System.out.print("{");
	for(int i=0;i<3;++i) {
             System.out.print(k[i]);
	     if(i<2) System.out.print(",");
	     else System.out.print("}");
	}
    }



}





