import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**We have two ways of computing the plaid model from
the PET.  One way involves mapping into the space,
checking which polytope we land in, and using the
polytope label.  Another way, much faster, involves
mapping into the space and using some
invariants of the partition to guess the label.
In this routine we check that the two methods
produce the same result.*/

public class DebugPlaidClassifier implements Runnable {
    boolean HALT=true;
    int[] TRY=new int[2];

    public void run() {
	HALT=false;
	while(HALT==false) {
	    int t=doTest();
	    ++TRY[t]; 
            if(TRY[1]%100==0) {
		System.out.print("plaid dynamics ");
		System.out.print("win "+TRY[1]+" ");
		System.out.print("lose "+TRY[0]);
		System.out.println("");
	    }
	}
    }


    public static int doTest() {
	Vector4 V=randomPlaid();
	int[] a1=PlaidClassify.plaidType(V);
	int[] a2=PlaidClassifyFast.plaidType(V);
	boolean triv1=false;
	boolean triv2=false;
	if(a1[0]==a1[1]) triv1=true;
	if(a2[0]==a2[1]) triv2=true;
	if(triv1==triv2) return 1;
	if(triv1!=triv2) return 0;
	if(a1[0]!=a2[0]) return 0;
	if(a1[1]!=a2[1]) return 0;
	return 1;
    }


    public static Vector4 randomPlaid() {
	double x=10*Math.random()-5;
	double y=10*Math.random()-5;
	double z=10*Math.random()-5;
	double P=Math.random();
	Vector4 V=new Vector4(x,y,z,P);
	V=PlaidClassifyingMap.reduce(V);
	return V;
    }

}





