import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**This routine checks that the plaid classifying map
conjugates the plaid curve following dynamics to the
plaid PET dynamics.  In this debugger and all others
but one  we use the fast classifying map.  One of the
debugging toutines shows that the two versions of the
classifier are the same.*/

public class DebugPlaidDynamics implements Runnable {
    boolean HALT=true;
    int[] TRY=new int[2];

    public void run() {
	HALT=false;
	while(HALT==false) {
	    int t=doDynamics();
	    ++TRY[t]; 
            if(TRY[1]%1000==0) {
		System.out.print("plaid dynamics ");
		System.out.print("win "+TRY[1]+" ");
		System.out.print("lose "+TRY[0]);
		System.out.println("");
	    }
	}
    }


    public static int doDynamics() {
	int[] a=randomParameter();
	int p=a[0];
	int q=a[1];
	double A=1.0*p/q;
	double P=2*A/(1+A);
	int[] mm=randomGrid();
	double m0=mm[0]+.5;
	double n0=mm[1]+.5;
        Tile T=new Tile(p,q,mm[0],mm[1]);
	int[] I=PlaidClassifyFast.classify(T);
	int[] move={0,0};
	double m1=m0;
	double n1=n0;
	if(I!=null) {
            move=convertType(I[1]);
	    if(I[0]!=I[1]) {
	    m1=m1+move[0];
	    n1=n1+move[1];
	    }
	}
	Vector4 V0=PlaidClassifyingMap.PHI(A,m0,n0);
	Vector4 V1=PlaidClassifyFast.plaidDynamics(V0);
	Vector4 W1=PlaidClassifyingMap.PHI(A,m1,n1);
	double d=Vector4.dist2(V1,W1);
	if(d<.000000001) return 1;
	return 0;
    }


    public static int[] randomGrid() {
	int m=(int)(200*Math.random()-100);
	int n=(int)(200*Math.random()-100);
	int[] mm={m,n};
	return mm;
    }

    public static int[] convertType(int a) {
       int[] move={0,0};
       if(a==0) move[1]=-1;
       if(a==1) move[0]=-1;
       if(a==2) move[1]=+1;
       if(a==3) move[0]=+1;
       return move;
    }




    public static int[] randomParameter() {
	boolean test=false;
	int[] a={};

	while(test==false) {
	   int c=1+(int)(100*Math.random());
	   int b=1+(int)(Math.min(c,100*Math.random()));  
           a=MathRational.reduce(b,c);
           if((a[0]>=2)&&(a[1]-a[0]>=2)&&(a[0]*a[1]%2==0)) test=true;
	}
	return(a);
    }


}





