import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.Arrays;
import java.math.*;

/**This file tests the piecewise affine map
   from the plaid PET to the graph PET.**/

public class DebugPlaidToGraph implements Runnable {
    boolean HALT=true;

    public DebugPlaidToGraph() {
    }

    public void run() {
	mainTest();
    }

    public void printout(double[] d) {
	System.out.println(d[0]+" "+d[1]+" "+d[2]);
    }

    public void mainTest() {
	HALT=false;
	int p=1;
	int q=2;
	while(HALT==false) {
	    testOmega(p,q);
	    ++p;
	    if(p==q) {
		++q;
		p=1;
	    }
	}
    }


    public void testOmega(int p,int q) {

	if(MathRational.GCD(p,q)!=1) return;
	if((p*q)%2==1) return;
	System.out.print("plaid2graph test "+p+"/"+q+"  ");
	int w=p+q;

	double A=1.0*p/q;
	double P=2*A/(1+A);

	for(int i=0;i<2*w*w;++i) {
	    for(int j=0;j<2*w;++j) {
              if(AGLattice.goodPoint(p,q,i+.5,j+.5)==true) {
                Complex u=AGLattice.nearestGrid(p,q,i+.5,j+.5); 
		u=AGTransforms.p2kAffine(p,q,u);
		int m=(int)(Math.floor(u.x+.5));
		int n=(int)(Math.floor(u.y+.5));
		Vector4 d1=AGMap.PSI(p,q,m,n);
		Vector4 U=PlaidClassifyingMap.PHI(A,i+.5,j+.5); 
		Vector4 d2=PlaidToGraph.omega(U);
		double dist=Vector4.dist2(d1,d2);
		if(dist>.0000001) {
                    throw new ProofException("plaid to graph fail");
		}
	      }
	    }
	}
	System.out.println("done");
    }

    public static boolean almostEqual(double[] a,double[] b) {
	for(int i=0;i<3;++i) {
	    if(Math.abs(a[i]-b[i])>.00000001) return(false);
	}
	return(true);
    }

}



