import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;

public class DebugReconstruction implements Runnable {
    boolean HALT=true;


    public void run() {
	HALT=false;
	int p=1;
	int q=2;
	while(HALT==false) {
		graphTest(p,q);
		++p;
		if(p==q) {
		    ++q;
		    p=1;
		}
	}
    }


    /**this tests the graph reconstruction test*/
    public static void graphTest(int p,int q) {
	if(MathRational.GCD(p,q)!=1) return;
	if((p*q)%2==1) return;
	System.out.print("graph reconstruction test "+p+"/"+q+"   ");
	for(int i=0;i<(p+q)*(p+q);++i) {
	    for(int j=0;j<p+q;++j) {   
                if(AGLattice.goodPoint(p,q,i+.5,j+.5)==true) {
		    boolean test=graphTest(p,q,i+.5,j+.5);
		}
	    }
	}
	System.out.println("done");
    }


    /**this tests the plaid reconstruction test*/
    public static void plaidTest(int p,int q) {
	if(MathRational.GCD(p,q)!=1) return;
	if((p*q)%2==1) return;
	System.out.print("plaid reconstruction test "+p+"/"+q+"   ");
	for(int i=0;i<(p+q)*(p+q);++i) {
	    for(int j=0;j<p+q;++j) {   
                if(AGLattice.goodPoint(p,q,i+.5,j+.5)==true) {
		    boolean test=plaidTest(p,q,i+.5,j+.5);
		}
	    }
	}
	System.out.println("done");
    }


    public static boolean graphTest(int p,int q,double x,double y) {
	Complex z1=AGLattice.nearestGrid(p,q,x,y);
	Complex z2=graphFormula(p,q,z1.x,z1.y);
	z1.x=z1.x-Math.floor(z1.x);
	z1.y=z1.y-Math.floor(z1.y);
	z2.y=z2.y-Math.floor(z2.y);
	if(z1.x>.9999999) z1.x=0;
	if(Complex.dist(z1,z2)>.0000001) {
	    throw new ProofException("graph reconstruct fails");
	}
	return true;
    }

    public static Complex graphFormula(int p,int q,double x,double y) {
	double A=1.0*p/q;
	Complex z=new Complex(x,y);
	Complex w=AGTransforms.p2kAffine(p,q,z);
	Vector4 U=AGMap.PSI(p,q,w.x,w.y);
	Complex z1=ReconstructionFormula.graphVersion(U);
	return z1;
    }

    /**x and y are half integers*/

    public static boolean plaidTest(int p,int q,double x,double y) {
	Complex z1=AGLattice.nearestGrid(p,q,x,y);
	Complex z2=plaidFormula(p,q,x,y);
	z1.x=z1.x-Math.floor(z1.x);
	z1.y=z1.y-Math.floor(z1.y);
	z2.y=z2.y-Math.floor(z2.y);
	z2.x=z2.x-Math.floor(z2.x);
	if(Complex.dist(z1,z2)>.0000001) {
	    System.out.println("");
	    z1.print();
	    z2.print();
	    throw new ProofException("plaid reconstruct fails");
	}
	return true;
    }


    public static Complex plaidFormula(int p,int q,double x,double y) {
	double A=1.0*p/q;
	double P=2*A/(1+A);
	Vector4 V=PlaidClassifyingMap.PHI(A,x,y);
	double[] d={V.x[0],V.x[1],V.x[2],V.x[3]};
	if(d[0]<d[1]) {
	    d[0]=d[0]+2;
	    d[1]=d[1]+P;
	    d[2]=d[2]+P;
	}
	return ReconstructionFormula.plaidVersion2(d,A);
    }

}



