import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class DocumentControl {

    public static void main0(DocumentCanvas D) {
	String S="MAIN SWITCH\n\n";
	S=S+"This console panel lets you switch between the 7 main control systems in the program:";

S=S+"\n\nplaid: This controls the plots of planar pictures associated to the plaid model.  To use this feature, click on the 'planar' popup window.\n\narithmetic graph: This controls the plots of planar pictures associated to the arithmetic graph.  The plaid model and arithmetic graph pictures are drawn on the same window, the planar window, so that they can be compares.";

S=S+"\n\ngrid analyzer: This lets you see the arithmetic graph grid for any parameter.  To use this feature, click on the 'grid analyzer' pop-up window.  This launches a window which draws the grid and gives you a slider at the top for changing the parameter.  A second window shows the hitset, which you can read about by selecting the 'grid analyzer' option and then reading the document on the auxiliary control panel which appears.";

S=S+"\n\nplaid PET: This controls the plots made in the plaid PET window.  The plaid PET is the 4D compactification of the plaid model.\n\ngraph PET: This controls the plots made in the graph PET window.  This is the compactification of the arithmetic graph.\n\nspacetime: This draws the spacetime diagrams discussed in the monograph.  Open up the spacetime console to read how to use this feature.  \n\ncube: This draws the 3-dimensional cubical fillings described in the monograph.  You use this in tandem with the PLANAR window.  If you click on a square in the planar window, you will see the cube which has this square as its bottom.  The nature of the cubes is explaned in the monograph.";
S=S+"\n\nsanity checks.  This controls a number of auxiliary plots in the plaid PET window and the graph PET window.  These plots were useful in developing the program, and they serve as checks that the various sets we have defined are correct.\n\ndebug: This launches a number of numerical calculations and checks. Again, these calculations and checks were useful in developing the program and they serve as indicators that our various formulas are correct.\n\nexport: Ihis mode, you can save some of the pictures to PDF files.";

S=S+"\n\nproof: This window launches the various computer-assisted proofs that are mentioned in my paper on the quasi-isomorphism theorem.\n\npresets: This gives you several options for putting the program in a specific state so as to best see certain features.  Before using this option, you should close all the pop-up windows. Alternatively, start the program over and then push one of the presets.";

     setDoc(D,S);
    }


    public static void colors(DocumentCanvas D) {
	String S="COLOR CONSOLE\n\n";
	S=S+"The color console has 3 main components: selector, assigner, and resetter. \n\n1. You can select a color by clicking on the small grid of colored buttons or else dragging the sliders around.\n\n2. Once you have selected a color, you can assign it to the 4x4 grid of colors with the NSEW labelings next to it.  This grid controls the checkerboard partition of the classifying space. (This is explained in the paper.)\n\n3. You can use the orange/blue cluster of 5 buttons to reset the colors on the checkerboard partition to their original values.  The middle button gives multiple colors and the NSEW buttons highlight the parts of the partition which assign tiles that involve the corresponding edge.";

	setDoc(D,S);

    }


    public static void capacity(DocumentCanvas D) {
	String S="CAPACITY LIMITER\n\n";
	S=S+"This switch controls the way the 'grid' and 'light points' features work on the plaid model control panel. When the switch is off, the full grid is drawn and all the light points are drawn.  When this switch is on, you can use the arrow keys to select a capacity limit.  When the capacity limit is set to K, the program only draws the lines of capacity at most K and only shows the light points which are on these lines.  If you set K to be small and make the parameter fairly large and use the red arrow keys at the top left of the control panel, you can get a hint of how the particles work.";

	setDoc(D,S);

    }
    public static void scale(DocumentCanvas D) {
	String S="RESCALE CONSOLE\n\n";
	S=S+"This console has two main features:";

	S=S+"\n\nrescaling: Using the reset button, you control how the pictures in the planar window are scaled. Assuming that you are looking at the plaid polygons, a press of the reset button causes the picture to be scaled to fit exactly in the window.  If the window has been resized so that it is not square, then the fitting will be done as well as possible. When you change parameters the picture is either automatically resetd or not.  If the picture in the planar window disappears for some reason, push the reset button.  This can happen when you change parameters.";

	S=S+"\n\nblock sampling: The fundamental domain for the plaid model is a row of W=p+q blocks.  Initially block 0 is shown.  By using the arrow keys, you can sample the other blocks.  If you press the big red square next to the arrow keys, you return to block 0.  More precisely, block k is defined to be the Nth block in left-to-right linear order, where N=-k(t) mod W.  Here t is quantity `widehat tau' from the monograph.  This is a canonical way to sample the blocks, as explained in the monograph.";

	S=S+"\n\nclose-ups: The 5 red boxes to the left of the reset button govern how you zoom in on the paper as you sample the blocks.  The setting on the left lets you see the whole block.  The remining settings show you various size neighborhoods (1,2,3,4) of the tile you have selected within the plaid model. You should experiment around and see how the picture changes when you sample blocks with respect to the different settings.";

	setDoc(D,S);
    }



    public static void parameter(DocumentCanvas D) {
	String S="PARAMETER SELECTOR";
	S=S+"\n\nThis is the console which lets you choose an even rational parameter. The parameters are all supposed to be of the form\n\np/q in (0,1)\n\npq even \n\nGCD(p,q)=1.\n\nNothing in the program is guaranteed to work if you do not choose p/q with this property. The parameter selector has 3 modes. The row of 3 red squares controls which mode you are in. When the program is launched the initial parameter is 2/9 and the program is in the simple mode.";

	    S=S+"\n\nSome of the features of the program work easily for parameters with large denominators and some do not.  If you want so see all the plaid polygons or all the arithmetic graph polygons, you should choose rationals where the denominator is less than around 100.  Otherwise the program will get hung up. If you are just interested in seeing the first polygons in each case, then you can pick parameters with denominators into the thousands.";

	    S=S+"\n\nThe easiest way to select a new parameter is to push the `random' button.  This will pick a new even rational parameter whose denominator is at most 32.  You can change the allowed maximum value by calling up the parameter control popup window.  The other way to enter a new parameter is simply to click on the display and type in the parameter.";

	    S=S+"\n\nThe parameter console also displays several of the important quantities from the monograph.";

	setDoc(D,S);
    }



    public static void particle(DocumentCanvas D) {
	String S="RESCALING CONSOLE";
	S=S+"\n\nThis console controls 3 features of the plaid polygon window.\n\n1. The plaid polygon window shows one block at a time. If you push the green reset button, it fits the block perfectly inside the window, provided that the window is square.  (You can resize the window by dragging a corner.)  If the window is not square, the fit feature does the best it can.\n\n2. If you click on the red arrow keys, it cycles through the p+q blocks in the fundamental domain.  The blocks are taken in the order of remote adjacency, as explained in the paper.  Here p/q is the paramerer.\n\n3.The red button resets things so that the first block is showing.";

	setDoc(D,S);
    }

    public static void plaid(DocumentCanvas D) {
	String S="PLAID CONTROLS";
	S=S+"\n\nThis console allows you to control the planar plots associated to the plaid model. To see the features mentioned here, you should open up the 'planar' pop-up window. Some of the features do not go so well with others, but you can select any features you like to draw - in any combination. The left buttons on the console control the colors in which things are plotted. The right buttons toggle whether or not the corresponding feature is plotted. Here are the options:";


	S=S+"\n\npolygons: This displays all the plaid polygons within the block.";

	S=S+"\n\nfirst polygon.  This highlights the big polygon which is used in the proof of the Unbounded Orbits Theorem.";


	S=S+"\n\ngrid:  This shows the empty square tiles within a block. Any block is a union of unit squares, p+q on a side.   You can either draw all the grid lines of just those having capacity less than a given cutoff.  You can ttoggle this feature using the 'limit capacity' control panel at the bottom.  When you limit the capacity, you also limit the other displays, such as the light points, the slanting lines, and the directions.";


	S=S+"\n\npolygon tracer.  This highlights individual plaid polygons.  When this feature is on, you activate it by clicking on one of the square tiles in the planar window.";


	S=S+"\n\nlight points: This displays the slanting lines and the light points associated to the plaid model at the selected parameter.   This is the data which goes into the definition of the plaid model.  The tiles in the plaid model are such that their connectors join edges in the tile which have exactly one light point. You can see this by turning on the polygon feature and the light points feature at the same time.";


	S=S+"\n\n(--)slant lines: This displays the negatively sloped slanting lines.";
	S=S+"\n\n(+)slant lines: This displays the positively sloped slanting lines.";

	S=S+"\n\ndirections: This adds arrows which indicate the directions of the slanting lines.  The definition consistency property says that positive and negative slanting lines give the same transverse direction to each light point.  You can check this by turning on this feature and the slanting lines feature.";

	S=S+"\n\nhexagrid: This feature only works when you have brought forth the hexagrid popup window.  When running, it allows you to manage the auxiliary lines which go into the definition of the plaid model.";


	S=S+"\n\nhexagrid: This shows all the lines of the hexagrid.";


	S=S+"\n\noriented tiles: This shows the tiles produced by the tiling description of the plaid model. These oriented tiles are an enhancement of the basic plaid polygons, because they include orientations.";

	setDoc(D,S);
    }





    public static void ag(DocumentCanvas D) {
	String S="ARITHMETIC GRAPH CONTROLS";
	S=S+"\n\nThis console allows you to control the planar plots associated to the arithmetic graph.  You should have the 'planar' pop-up window open to see the features mentioned here.  Some of the features do not go so well with others, but you can select any features you like to draw - in any combination. The leftmost buttons on the console control the colors in which things are plotted. The right buttons toggle whether or not the corresponding feature is plotted. Here are the options:";


	S=S+"\n\npolygons: This displays all the arithmetic graph polygons.";


	S=S+"\n\nfirst polygon.  This highlights the big polygon which is used in the proof of the Unbounded Orbits Theorem for outer billiards on kites.";


	S=S+"\n\ngrid:  This shows the grid of arithmetic graph vertices.  Note that this grid is not the same as the square grid.";

	S=S+"\n\npixel fail:  This colors the squares in the square grid according to one of three colors:\n\nblack: the square does not contain an arithmetic graph lattice point.\n\ndark grey: the square does contain an arithmetic graph lattice point, and the plaid model tile in that square intersects the same edges as the portion of the arithmetic graph in the tile.\n\nlight grey: the square contains an arithmetic graph lattice point, but the crossings are different.";

	S=S+"\n\n1st poly affine: This applies an affine tranformation to the first arithmetic graph polygon so that its vertices are in the integer lattice.  In the original definition of the arithmetic graph, the vertices are integer lattice points.  However, there is a canonical affine transformation which makes the arithmetic graph line up with the plaid model.  This feature undoes this canonical map and restores the original definition.";

	setDoc(D,S);
    }


    public static void hitset(DocumentCanvas D) {
	String S="HITSET DISPLAY";

	S=S+"\n\nLet G denote the arithmetic graph grid (for some parameter).  Let \u03D5 be the plaid classifying map.   The hitset is the set from the monograph which contains \u03D5(G).  This display shows various sets associated to the hitset.";

	S=S+"\n\nhitset: This is the basic set";

	S=S+"\n\n low set: The points of G are classified into two types, low and high, as follows.  Let p=(x,y) be such a point.  Let A=p/q be the parameter. Let A=2A/(1+A).  The point p is called low if [y]<P.  Here [y] is the decimal part of y, namely y-floor(y).  The low set is the subset of the hitset which contains the image of the low points under \u03D5.";

	S=S+"\n\nhigh set: the high points of G are the ones which are not low. The high set is the subset of the hitset corresponding to the high points just as the low set corresponds to the low points.";

	S=S+"\n\nlow set image:  We impose a dynamical system on G, as follows.  Let V = (1,-P).  This is the vector dT(0,1), where T is the canonical affine transformation from the paper and dT is the linear part.  We map each grid point p to p+V.  There is a corresponding subset of the hitset which contains the image of all the low points under this map.  This button shows that image.  On the level of the plaid PET, we are just mapping the low set to its image under the part of the curve following dynamics corresponding to adding the vector (1,-1).   This makes sense because, in the low case, the unit integer square containing p+V is obtained from the one containing p by adding (1,-1).";

	S=S+"\n\nhigh set image:  We do the same things for the high set as we did for the low set.  This time,  the unit integer square containing p+V is obtained from the one containing p by adding (1,0).";

	S=S+"\n\nframe: This shows the slices of the fundamental domains containing the hitset.";

	S=S+"\n\ncursor: This just shows where you click.";

	S=S+"\n\npointer raw: This shows the raw form of the curve following dynamics.  In this high case, we add (2P,2P) to the cursor point.  In the low case, we add (2P-2,2P).  This is consistent with the plaid classifying map:\n\n\u03D5(x,y)=(2Px+2y,2Px,2Px+2Py)\n\nOur display drops off the third coordinate, so just the first two are relevant.";

	S=S+"\n\npointer: This shows the curve following dynamics when the image is coerced to lie back in the fundamental domain.  With both the pointer raw option and the pointer option, you can drag the cursor around and see how the image varies.  Also, in both cases, the lattice of translates of the relevant points are shown.";

	setDoc(D,S);
    }



    public static void spacetime(DocumentCanvas D) {
	String S="SPACETIME DISPLAY";

	S=S+"\n\nYou need to have both the planar window and the spacetime window open to use this feature.  To see a picture in the spacetime window, you click on a grid line (horizontal or vertical) in plaid model (planar) window and then the corresponding diagram will be drawn.  If you change parameters, you will probably want to scale the spacetime picture by pressing the 'r' key.";

	S=S+"\n\nThe spacetime drawing works like this.  First we draw a finite union of particle lines.  The particles associated to a given particle line are the places where the line intersects the horizontal edges in the spacetime window.  We then pixellate these lines.  This control panel lets you hide and display various features of the drawing, and also recolor them.";

	S=S+"\n\nIf you want more control over the pictures you are drawing, you can use the arrow keys and the lever beneath this control panel.  The arrow keys allow you to specify the capacity of the line.  The lever lets you select any of the 4 lines (2 horizontal + 2 vertical) of the given capacity.  Any click on these buttons will draw a picture.  If you fix the capacity and change the lever choice, you can see the Topological Symmetry Conjecture in action.  This was discussed in the monograph.";

	S=S+"\n\nYou can also use the keys to manipulate the picture.  The 'r' key rescales the picture so that the frame fits nicely in the window. The 'a' and 's' keys shift the frame up and down and then do the rescaling.";

	setDoc(D,S);
    }



    public static void particleSlice(DocumentCanvas D) {
	String S="SLICE";

	S=S+"\n\nThis control panel lets you select whether you are plotting the images of the vertical light points or the horizontal light points.";

	setDoc(D,S);
    }


    public static void particleType(DocumentCanvas D) {
	String S="POINT TYPE";

	S=S+"\n\nThis control panel lets you select any of the 4 types of vertical light points in the vertical case and any of the 4 types of horizontal light points in the horizontal type.  To illustrate the naming scheme by way of example, the type (P,west) refers to light points on vertical grid lines which have type P and are oriented west.  This means that the point is contained on a slanting line of slope -P (and having integer y-intercept) which is directed to that it points west.  In general, a negatively sloped line points can point north/west or south/east.";

	setDoc(D,S);
    }

    public static void particlePlot(DocumentCanvas D) {
	String S="PLOT CHOICE";

	S=S+"\n\nThis control panel lets you select the extent to which you make the plot.  With the `symmetric' option you only plot the symmetric instances of the particles.  This corresponds to the result in the Vertical and the Horizontal Lemma. When you choose this option, the plot coordinates are as in those results.\n\n --In the vertical case, you are plotting the picture in the (T,U1) plane.\n\n --In the horizontal case, you are plotting the picture in the (U1,U2) plane.  The colored points lie in one slice and the white points lie in the other.  When the offset is set to `square' the colored points lie in the plane T=1 and the white points lie in the plane T=-1.  With the 'edge' option, the colored points lie in the slice T=0 and the white points lie in the slice T=-2(or 2).  A better interface would let you change the colors of the white points.";

	S=S+"\n\nWith the `all' option, you are plotting all the light points. In this case, the points are plotted in the (U1,U2) plane.  This corresponds to the X-slices on the plaid PET control panel.";

	setDoc(D,S);
    }


    public static void particleOffset(DocumentCanvas D) {
	String S="OFFSET";

	S=S+"\n\nThis control panel lets you select the offset value of the plot. When you choose `square', the following happens:";

	S=S+"\n\n--For vertical light points you are plotting the centers of squares which have the light points on their west edge.\n\n--For horizontal light points you are plotting the centers of squares which have the particles on their south edges.  This is just like what is donein part 2 of the monograph.";

	S=S+"\n\nWhen you choose `edge' you are plotting the centers of the unit integer segments which have the light points on them.  This option gives a more symmetric plot.  The way our proof of the Vertical Lemma and the Horizontal Lemma in the monograph works is that we first make this more symmetric plot and then we translate back.";

	setDoc(D,S);
    }






    public static void plaidPET(DocumentCanvas D) {
	String S="PlaidPET";
	S=S+"\n\nThis window controls the pictures in the plaid PET window.  The plaid PET window needs to be activated for you to see anything. Here are the options:";

	S=S+"\n\nPartition.   This shows the basic partition of the PET. It is the main feature.  You can see the classifying map in action in the following way.  If you turn on the oriented tiles feature on the plaid polygon window, and then click (middle button) on a tile, it will show you the image of the tile in the plaid PET space.  This explains how the choice of tile is determined.";


	S=S+"\n\nhitset. Let G denote the arithmetic graph grid (for some parameter).  Let \u03D5 be the plaid classifying map.   The hitset is the set from the monograph which contains \u03D5(G).  This display shows various sets associated to the hitset.  You have to choose the Z-slice option on the grid PET slicer to see the hitset.  The point is that the hitset for each parameter is the product of a polygon and the Z-axis.";



	setDoc(D,S);
    }




    public static void graphPET(DocumentCanvas D) {
	String S="GRAPH PET CONTROLS";

	S=S+"\n\nThis window controls the pictures in the graph PET window.  The graph PET window needs to be activated for you to see anything. Here are the options:";

	S=S+"\n\nPartition.   This is the partition associated to the Graph Master Picture Theorem. Each arithmetic graph lattice point (in the plane) has 0 or 2 arithmetic graph edges incident to it.  In the case of 0 we think of these as 2 trivial edges. So, in all cases, we speak as if there are two edges.  These two edges are determined by a pair of partitions of the graph PET.  One of the partitions is called the (+) partition and one is called the (--) partition.  One maps the lattice point into the PET space and then notes which pieces of each partition the image lies in.  This determines the local picture.  This option shows the one partition or the other.  You can toggle between the two partitions using the graph PET slicer.";

	S=S+"\n\nPartition select: This option is important for the proof of the quasi-isomorphism theorem. It works in tandem with the partition control popup window.  In the plaid PET documentation I discussed a fine partition of the plaid PET space into 218 polytopes.  These polytopes are mapped into the graph PET space using the canonical map between these two spaces. Call these pieces the graph triples.  So, there are 218 graph triples in the graph PET space. When this option is on, and you have selected a graph triple, this option displays the one or two pieces of the (+/-) partition which contain the given graph triple. Usually there is one (+) piece and one (-) piece, but occasionally there are two of one or the other";

	S=S+"\n\ngraph triples: This displays the 218 graph triples.";

	S=S+"\n\ngr triples select: This feature works in tandem with the partition control popup window.  It displays the selected graph triple. For the quasi-isomorphism proof, it is useful to have the partition select and the triple select option on, and the other options off.  Then you can see the relationship between these two features.";

	S=S+"\n\ngr doubles select:  This feature works in tandem with the partition control window. The 9 doubles are unions of pairs of tiles in the graph partition. There are 4 for the (+) partition and 5 for the (-) partition.  Of the 218 graph triples, 38 of them are not contained in single graph polytopes.  However, each of the 38 exceptions is contained in one of the 9 doubles.  You can see this in action by selecting one of the last 38 triples (numbered 180,...,217) and turing on this feature.  The doubles are also convex polytopes.";

	S=S+"\n\ngr framework: This is a subset of the graph space which only depends on the X and Y coordinates.  One can tell where a point in the planar arithmetic graph lattice lies in the square that contains by looking at its image w.r.t. the framework.  There is an obvious affine map carrying the framework to the unit square, and this map carries the point in the graph space back to the planar lattice point.  This is our Graph Reconstruction Formula.  You can only see this option with the Z-slice option on the graph PET slicer.  This option is adopted to the subsets shown in connection with the edge crossing problems on the partition control window.";

	setDoc(D,S);
    }



    public static void sanity(DocumentCanvas D) {
	String S="SANITY CHECKS";

	S=S+"\n\nThis window controls some auxiliary plots which help check that the various maps defined are correct.  The first 4 plots work in tandem with the plaid PET window and the last one works in tandem with the graph PET window.";

	S=S+"\n\nPlaid class map.   This is one of the most important checks. It tests that we have the plaid partition correct.  In fact, I found the plaid partition experimentally using this map, and then gave a traditional proof in my first paper on the plaid model.   What it does is maps all the centers of the square tiles into the plaid PET space, and colors them according to the color of the oriented plaid tile at the given square.  This picture should match the plaid PET partition, up to vanishingly small errors (in the size of the denominator) which have to do with the way that the picture is drawn.";

	S=S+"\n\nimages by type:  This option illustrates the proof of the Plaid Master Picture Theorem in part 2 of the monograph.  When you bring up this option you can plot the images under the classifying map of grid points associated to any of the 8 types of light points:  horizontal or vertical, P or Q, and the direction.  There is an auxiliary cluster of control panels which allow you to select the type of particle, the offset, and the extent of the plot.  You can read more about the precise nature of the plots by clicking on the question boxes associated to these auxiliary control panels.";

	S=S+"\n\nplaid particles: This exhibits a rather technical point in my proof of the main result of the first paper. A fundamental domain for the plaid model consists of W blocks of size WxW. Here W=p+q, where p/q is the parameter. These blocks are best sampled by skipping t of them where t solves a certain congruence\n\n2ap \u2261 1 (W)\n\nA particle is then a union of P points or a union of Q points which move as little as possible, relatively speaking, when this skipping is done.  This sanity check shows the images of some particles under the plaid classifying map.  The plot isn't very well developed.";

	S=S+"\n\nplaid hit set:. This shows a plot of the hit set defined in the plaid PET window documentation.  You can compare this with the hitset drawn either in the plaid PET window or in the `hitset half' of the grid analyzer windows";

	S=S+"\n\ngraph spider set: This plot is a check that we have correctly defined the sets controlled by the spider display mode on the partition control. The way you see the plot is rather tricky.  You should open up both the partition control and the graph PET window.  The right hand side of the partition control has a 3x3 grid of colored squares.  In the central square of this grid, there is a smaller grid of squares.  This smaller grid controls the plot I am talking about.  To see one of the plots, you should click one of the non-central little squares in this little 3x3 grid.  If you want the plot to go away, you should then click the central little square.  If you want to compare the plot to the corresponding spider set, you shouldset the spider display control panel to `unrestricted', and then click the button on the larger grid of squares that is in the same relative position.  For instance, if you click the upper right little square, then the upper right big green square is in the same relative position.  The picture for this plot looks better than larger the denominator of the rational paramerer.";

	setDoc(D,S);
    }


    public static void debug(DocumentCanvas D) {
	String S="DEBUGGER\n\n";
	S=S+"This console toggles between various tests which help me develop the program. All the options are multithreaded, so that you can stop and start them as you like.  Currently the output of these routines is the command line in the window running the program Here are the options.";

	S=S+"\n\nweak test:  There are 3 kinds of copying theorems proved in my second paper on the plaid model (existence of unbounded orbits.) The copying theorems are called the weak test, the strong test, and the core test.  Each test involves two rational parameters that are related in some way akin to the Farey relation.  Each of the tests can be checked by a finite calculation for any given parameter. This option lets you do the weak test for all rational numbers until you stop the program.  The middle option of the parameter entry system is adapted to this trichotomy.  The first button selects random parameters for the weak test. The second one selects parameters for the strong test. The third button selects parameters for the core test.  The documentation for the parameter entry system has more info on this.";

	S=S+"\n\nstrong test:  this does the same thing for the strong test";

	S=S+"\n\ncore test:  this does the same thing for the core test test";

	S=S+"\n\ngraph reconstruction test: When we map a planar arithmetic graph lattice point into the graph PET space, the map remembers where the lattice point sets inside the integer unit square that contains it.  There is a formula for how to extract the information from the image in the graph PET space. This option checks the formula.";

	S=S+"\n\nplaid2graph map: This is one of the most important checks for the quasi-isomorphism theorem.  There is a canonical piecewise affine map from the plaid PET to the graph PET.  This feature tests this map. The map makes a commuting square.  Each arithmetic graph lattice point lies in the interior of some unique integer square. The center of that square is the partner point.  Let z be the ag lattice point and let w be the partner point.  On the one hand we map z into the graph PET space using the graph PET classifying map.  On the other hand we map w into the plaid PET space and then push it into the graph PET space using our canonical piecewise affine correspondence map. This routine checkx that the two images are the same up to floating point error, for all relevant points and all parameters until you stop the program.";

	S=S+"\n\nplaid triple dyn: As discussed in the plaid PET documentation, there is a partition of the plaid PET space into 218 smaller polytopes which determine the length 3 arcs of the plaid model. This is the triple partition.  The curve following dynamics maps each of these triples over some finite union of other triples.  This routine experimentally determines what gets mapped over what, both in the forwards and the backwards direction. There are 2 green arrow key which pop up when this feature is on, and you can use these arrow keys to select the number of the polytope and also the direction (forwards or backwards.  When you press go, the program finds random points inthe image under the dynamics and sees which polytopes this point lies in. If you run the program for a long time before halting, you should get the complete list. This experimental program plays no role in our formal proof, however.";

	S=S+"\n\nedge crossing: This runs all the 462 edge crossing problems and generates the list of recalcitrant ones -- i.e., the ones which are not handled by any of our methods.  These recalcitrant ones correspond to the catches in the Pixellation Theorem.";
	S=S+"\n\npartition: I generally use this routine to print out the polytopes in the partition, in LaTeX form, for inclusion in my paper.  The routine is in flux. At different times it prints out different things.";

	setDoc(D,S);
    }


    public static void export(DocumentCanvas D) {
	String S="EXPORT CONTROLS";
	S=S+"\n\nThis controls a rather clumsy and complicated scheme I have for exporting pictures into postscript files.  Basically, I convert all the data types into commands acceptable to tcl/tk, then write everything into the file\n\nOutput/graph\n\nThen I run the tcl/tk file \n\nOutput/graph.tcl\n\n and use tk's export feature to get a ps file.  You probably would have no reason to use this feature.  You could just take screenshots.  Anyway, if you want to see how this works, you can toggle what you want to get exported.  I'll leave it to you to figure out which buttons save which kind of images.  Basically, I used this feature to illustrate the paper.";

	setDoc(D,S);
    }


    public static void proof(DocumentCanvas D) {
	String S="PROOFS";
	S=S+"\n\nThis panel launches the proofs associated to my paper on the quasi-isomorphism theorem.  Here are the different routines.";

	S=S+"\n\nplaid-graph corr:  This checks that each plaid triple polytope is mapped into either a single graph polytope in each of the two graph partitions, or else into a single graph polytope in one of the partitions and a union of two graph polytopes in the other partition.  There are 38 exceptional cases like this.";

	S=S+"\n\ndisjointness:  For the plaid partition, the two graph partitions, and the plaid triple partition, this routine checks that the interior of each piece is disjoint from all the other pieces as well as from smallish lattice images of the other pieces.  The check is sufficient to prove the the interior of each piece is disjoint from all the lattice translates of each other piece.";

	S=S+"\n\nclean convex:  This checks that every polytope of interest to us is the convex hull of its vertices, and that every vertex is necessary: The convex hull of any proper subset of the vertices is a proper subset of the polytope.";

	S=S+"\n\nvolume calcs:  For the plaid partition, the two graph partitions, and the plaid triple partition, this routine checks that the sum of the volumes equals the volume of the relevant classifying space. This combines with the disjointness check to prove that we really have partitions in all cases.";

	S=S+"\n\ndynamics: For each piece of the plaid triple partition, and each partition, this routine rigorously finds the list of other triple partition pieces the given piece maps over. This is a very slow routine. You should run it and then get a cup of coffee while it is working.  You could compare the output to what we have stored in the file DataTripleDynamics.java.";

	S=S+"\n\nedge crossing: This essentially does the same as the edge crossing debugger. It processes the 462 edge crossing problems and solves all but 46 of them with the methods discussed in the quasi-isomorphism paper.  You can survey the edge crossing problems by hitting the plaid-graph corr button on the 'preset' window and reading the instructions.";


	S=S+"\n\nerrant edges: This goes through the whole plaid-graph correspondence and checks that an errant edge never appears as an assignment.  This is part of the Pixellation Theorem in the quasi-isomorphism paper.";

	S=S+"\n\ncatch position:  This performs the several tests associated to our analysis of the 46 exceptional edge crossing problems.  In each case, we show that the relevant polytope is contained on side of the relevant hyperplane.  These tests correspond to our proof of Statement 5 of the Pixellation Theorem.";

	setDoc(D,S);
    }

    public static void preset(DocumentCanvas D) {
	String S="PRESETS";

	S=S+"\n\nThis control panel has 4 preset options which allow you to see some of the main features of the program.  When you push one of the preset buttons, some auxiliary pop-up windows are called up.  If you press these buttons when some of these windows are already alive, you will get some duplication and then the program will have problems. So, you should close all the auxiliary windows first.  Here are the preset options.  Keep this window open if you want instructions on how to use the presets.";

	S=S+"\n\nquasi-isomorphism theorem:  When you click this button, it brings up the 'planar' window, in which both the arithmetic graph and the plaid model are drawn.  This lets you see the theorem in action:  The theorem gives a quasi-isomorphism between the two curve families.  If you use the parameter console at top right you can change the parameter.  If you use the big red arrow keys, you can sample the whole fundamental domain while keeping the parameter the same.";

	S=S+"\n\nplaid master picture theorem:  When you click this button, it brings up the planar window, the plaid PET display, and the plaid PET slicer.  The planar window shows the oriented tiles, each colored in a way that corresponds to the labeling on the plaid PET, and also colored in a way that reflects the nature of the tile. Thus, for instance, the dark blue tiles always have the connector pointing east to west.  If you click the middle mouse button on an oriented tile, you can see the image of your selected point under the plaid classifying map. Note that the color of the polytope containing the image matches the color of the tile. This is the content of the plaid master picture theorem.";

	S=S+"\n\ngraph master picture theorem:  When you click this button, it brings up the planar window, the graph PET display, the graph PET slicer, and the graph interpreter  The planar window shows the arithmetic graph.  When you click on an arithmetic graph point, you can see the image of your selected point under the graph classifying map. The image is contained in one polytope from the (+) partition and one from the (-) partition.  Each one determines an edge of the arithmetic graph.  The graph PET slicer shows the determined edge. You can toggle back and forth between the two partitions using the graph PET slicer controls, and in this way you can survey both assigned edges.  You can see that these edges match the two edges of the arithmetic graph incident to the point you selected. This is the content of the graph master picture theorem.";


    S=S+"\n\ngraph plaid corr:  When you click this button, it brings up all the graph PET windows, all the paid PET windows, and the partition control.  The partition control has a left side and a right side. The left side gives you a way to survey the plaid triple partition.  The blue arrows let you cycle through all 218 pieces of the plaid triple partition.  When you select one of these, the bottom left portion shows the arithmetic graph edge assignments associated to this piece.  The edge assignments come about as follows:  We map the plaid triple polytope into the graph space using the projective intertwiner and we see which pieces of the graph partitions it lands in.  We call the image of the plaid triple  the 'graph triple'.   After you use the blue arrow keys, you need to move the basepoint around on the graph PET slicer so that you are in a base point lying below a fiber which interesects the graph triple.  Once you do this, you can see which pieces of the (+) and (-) graph partitionc contain it.";

    S=S+"\n\nThe right hand side of the partition control has some green arrows.  These let you cycle through the 462 edge crossing problems.  When you click on the green arrows, the plaid and graph PET windows, if possible, display the auxiliary markings which show the solution of the edge crossing problem.  This happens in all but 46 cases.  When you hit one of the recalcitrant cases, the green arrows turn red.  If you like, you can click the smaller red arrows directly, and this will show just the 46 recalcitrant cases.  The green buttons above the arrow keys allow you to access the list in a different way.  The edge problems are sorted according to type of edge, and you can jump to the beginning of any edge type you like.";

S=S+"\n\nIf you bring up the 'polytope info' pop-up window, and you click on the big number on the left hand side of the partition control, you can see the vertices of both the plaid triple and the graph triple which correspond to that number.";
	setDoc(D,S);
    }





    public static void setDoc(DocumentCanvas D,String S) {
        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }




}

