import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class DocumentGraph {

    public static void slice(DocumentCanvas D) {
	String S="SLICE SELECTOR\n\n";
	S=S+"The graph PET is a partition of a 4 dimensional flat torus into convex polytopes.  The coordinates for the space are (X,Y,Z,A), where A is the parameter. The A coordinate is always represented by the vertical direction on the pink rectangle. This window controls how you slice through this space.  If you select the X-slice, then points on the pink rectangle represent slices where the coordinates X and A are held fixed.  The picture drawn in the graph PET window is the corresponding YZ plane.   Similar remarks apply to the Y slice option and the Z slice option.  You move through the PET by dragging the mouse on the pink rectangle.";

	S=S+"\n\nThe Z slice is the one I drew in my book, Outer Billiards on Kites. However, for the purpose of the quasi-isomorphism theorem, the X slice is the most important.  The Y slice is, in all cases, completely irrelevant.";

	S=S+"\n\nHere is a more technical discussion of the X-slice.  Technically, the YZ planes make a dense foliation of each A-slice of the PET, at least when the parameter A is irrational.  So, what we are really doing is lifting the partition of the PET to the universal cover and drawing a few images of a slice by the appropropriate YZ plane.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void lock(DocumentCanvas D) {
	String S="LOCK SELECTOR\n\n";
	S=S+"The graph PET is a partition of a 4 dimensional flat torus into convex polytopes.  The coordinates for the space are (X,Y,Z,A), where A is the parameter. The A coordinate is always represented by the vertical direction on the pink rectangle. This control panel lets you decide whether you are allowed to change the A coordinate or not.  When you have selected `locked' you cannot change it.  When you have selected `free' you can change it.";

	S=S+"\n\nIn case you have selected the free option, and you want to restore the position to the A-parameter listed on the parameter selector, you should push the pink square button on the top right of this window.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void partition(DocumentCanvas D) {
	String S="PARTITION SELECTOR\n\n";
	S=S+"The graph PET is a partition of a 4 dimensional flat torus into convex polytopes. Actually, there are two such partitions, which we call (+) and (-).  These two partitions together determine the local picture of the arithmetic graph at each vertex.  This control panel lets you toggle between the two options.";

	S=S+"\n\nEach partition is 9-colored.  The colors correspond to different lattice vectors in the arithmetic graph lattice.  The arithmetic graph lattice has a natural basis w1,w2.  The each color stands for a pair (a1,a2), where these numbers are in {-1,0,1}.  The corresponding lattice vector is a1 v2+a2 v2.";

	S=S+"\n\nHere is an extensive example which illustrates the scheme:";
	S=S+"\n\n1. Activate on the planar window, the PET color control window, and the partition control window.";

	S=S+"\n\n2. Set the parameter to 2/9.";
	S=S+"\n\n3. Turn on the arithmetic graph polygons.";
	S=S+"\n\n4. On the rescale window push the red square and the rescale button.";
        S=S+"\n\n5. Click on the square of the planar window which is just above the bottom left square.  Click it several times to be sure that the click registers";
	S=S+"\n\n6. Observe that the corresponding point in the graph PET space lies in a dark blue polytope for the (+) partition and dark magents polytope for the (-) partition.";
	S=S+"\n\n7. On the upper right hand side of the partition control window, you will see a 3x3 grid of colored square.  These squares have the same colors as the colors on the graph PET.  Click on dark blue and dark magenta.";
	S=S+"7. \n\n8. Now look at the bottom right of the partition control window and observe that the pair of vectors shown matches the shape of the arithmetic graph in the square you have chosen.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void tiling(DocumentCanvas D) {
	String S="TILING EXTENT\n\n";
	S=S+"The graph PET is a partition of a 4 dimensional flat torus into convex polytopes.  Really, what we plot is the lift to the universal cover of this partition.  This row of squares lets you control how many images in the universal cover we plot.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}




