import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class DocumentPlaid {

    public static void slice(DocumentCanvas D) {
	String S="SLICE SELECTOR\n\n";
	S=S+"The plaid PET is a partition of a 4 dimensional flat torus into convex polytopes.  The coordinates for the space are (X,Y,Z,P), where\n\nP=2A/(1+A),\n\nand A=p/q is the parameter. The P coordinate is always represented by the vertical direction on the blue rectangle. This window controls how you slice through this space.  If you select the X-slice, then points on the blue rectangle represent slices where the coordinates X and P are held fixed.  The picture drawn in the graph PET window is the corresponding YZ plane.   Similar remarks apply to the Y slice option and the Z slice option.  You move through the PET by dragging the mouse on the blue rectangle.";

	S=S+"\n\nThe X slice is the one I focused on in my first two papers on the plaid model.  However, the Z slice is most relevant for the proof of the quasi-isomorphism theorem. The Y slice is irrelevant in all cases.";

	S=S+"\n\nHere is a more technical discussion of the Z-slice.  Technically, the XY planes make a dense foliation of each P-slice of the PET, at least when the parameter A is irrational.  So, what we are really doing is lifting the partition of the PET to the universal cover and drawing a few images of a slice by the appropropriate XY plane.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void lock(DocumentCanvas D) {
	String S="LOCK SELECTOR\n\n";
	S=S+"The plaid PET is a partition of a 4 dimensional flat torus into convex polytopes.  The coordinates for the space are (X,Y,Z,P), where\n\nP=2A/(1+A),\n\nand A=p/q is the parameter. The P coordinate is always represented by the vertical direction on the blue rectangle. This control panel lets you decide whether you are allowed to change the P coordinate or not.  When you have selected `locked' you cannot change it.  When you have selected `free' you can change it.";

	S=S+"\n\nIn case you have selected the free option, and you want to restore the position to the P-parameter listed on the parameter selector, you should push the blue square button on the top right of this window.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void partition(DocumentCanvas D) {
	String S="DYNAMICS SELECTOR\n\n";
	S=S+"The plaid PET is a partition of a 4 dimensional flat torus into convex polytopes. The plaid PET partition determines the local structure of the plaid model. This control panel lets you see the images of the partition under the forward and backwards curve following dynamics.  Below is an explanation of what this means.";

	S=S+"\n\nFirst of all, we explain the way the plaid PET determines the structure of the plaid model. This is the content of my first paper on the plaid model.  There is a locally affine map F from the set of centers of square tiles into the plaid PET space.  This map F is called the classifying map. The domain of F is the set of centers of the square tiles. The range of F is the plaid PET space.";

S=S+"\n\nThe plaid PET partition is 16-colored. The colors correspond to different ordered pairs of edges in a square.  If you open up the PET color control, you can see the correspondence.  For instance, the light blue color corresponds to the pair (West, East).  When you click on a square in the planar window, the local picture for the plaid model is determined by the color of the partition in the plaid model which contains the image of the square center under the classifying map.  For instance, if the center were to map into a light blue polytope, the corresponding plaid tile would point from West to East.";

	S=S+"\n\nOne has the canonical curve following dynamics on the plaid PET.  Here is a description. Suppose that c0 is a square center in the plaid model.  The corresponding plaid tile is a directed edge pointing into an adjacent square.  Let c1 be the center of this adjacent square.  The map c0->c1 is the curve following map.  At the same time, there is a map F from the set of square centers into the plaid PET space.  The curve following dynamics makes the obvious square commute.  That is, the curve following dynamics in the PET model carries F(c0) to F(c1).";


        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }

    public static void tiling(DocumentCanvas D) {
	String S="TILING EXTENT\n\n";
	S=S+"The plaid PET is a partition of a 4 dimensional flat torus into convex polytopes.  Really, what we plot is the lift to the universal cover of this partition.  This row of squares lets you control how many images in the universal cover we plot.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}




