import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ExportRoutines {


    public static void drawTiles(Manager M,Output OUT) {
	int[] L=M.P.getLimits();
	int p=M.p();
	int q=M.q();
	int k=p+q;
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=0;j<k;++j) {
		T=new Tile(p,q,i,j);
  	        T.type();
   	        gp=T.getSquare();
		OUT.lineWrite0(gp,new Color(200,200,200));
	    }
	}

    }




    public static void drawLines(Manager M,Output OUT) {
	int p=M.p();
	int q=M.q();
	int k=p+q;
	int NUM=M.C.SCA.S.val;
	double P=2.0*p/(p+q);
	double Q=2.0*q/(p+q);

	for(int i=0;i<3*(p+q);++i) {
	    double x1=0;
	    double y1=i;
	    double x2=p+q;
	    double y2=i-P*(p+q);
	    Complex[] Z={new Complex(x1,y1),new Complex(x2,y2)};
	    //Z=Tile.trim(p,q,Z);
	    if(Z!=null) OUT.segmentWrite(Z[0].x,Z[0].y,Z[1].x,Z[1].y,new Color(180,180,180));
	}

	for(int i=0;i<3*(p+q);++i) {
	    double x1=0;
	    double y1=i;
	    double x2=p+q;
	    double y2=i-Q*(p+q);
            Complex[] Z={new Complex(x1,y1),new Complex(x2,y2)};
	    //Z=Tile.trim(p,q,Z);
	    if(Z!=null) OUT.segmentWrite(Z[0].x,Z[0].y,Z[1].x,Z[1].y,new Color(100,100,100));

	}
	OUT.segmentWrite(0,p+q,p+q,q-p,new Color(180,180,180));
    }




    /**This draws the paths from the center of the tile to the
       light points*/


    public static void drawPoints(Manager M,Output OUT) {
	int[] L=M.P.getLimits();
	int p=M.p();
	int q=M.q();
	int k=p+q;
	Tile T=new Tile();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=0;j<k;++j) {
		T=new Tile(p,q,i,j);
   	        Complex[] Z=PlaidModel.getLightPoints(T);
		for(int ss=0;ss<Z.length;++ss) {
		    OUT.segmentWrite(Z[ss].x,Z[ss].y,i+.5,j+.5,new Color(150,150,150));
		}
	    }
	}
    }




    public static void drawModel(Manager M,Output OUT) {
	int[] L=M.P.getLimits();
	System.out.println(L[0]+" "+L[1]);
	int p=M.p();
	int q=M.q();
	int k=p+q;
	Tile T=new Tile();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=0;j<k;++j) {
		T=new Tile(p,q,i,j);
		T.type();
		if(T.type!=0) {
		    int c1=T.TYPE[0];
		    int c2=T.TYPE[1];
	            Complex Z0=new Complex(i+.5,j+ 0);
	            Complex Z1=new Complex(i +0,j+.5);
	            Complex Z2=new Complex(i+.5,j+ 1);
	            Complex Z3=new Complex(i+ 1,j+.5);
	            Complex[] Z={Z0,Z1,Z2,Z3};
		    OUT.segmentWrite(Z[c1].x,Z[c1].y,Z[c2].x,Z[c2].y,Color.black);
		}
	    }
	}
    }





    public static void drawFirstPlaid(Manager M,Output OUT) {
	int p=M.p();
	int q=M.q();
	int t=MathRational.tune(p,q,1);
	Tile T=new Tile(p,q,0,t);
	Path2D.Double gp=TileTracer.plaidPolygon(T);
	OUT.lineWrite0(gp,Color.black);
    }


    public static void drawAG(Manager M,Output OUT) {
	int p=M.p();
	int q=M.q();
 	double A=1.0*p/q;
	int[] LL=M.P.getLimits();
	int k=LL[0]/(LL[1]-LL[0]);
	Path2D.Double BOX=AGPlot.periodBox(p,q,k);
	int[] L2=GraphicsHelp.getLimits(BOX);
	Path2D.Double gp=new Path2D.Double();

	for(int i=L2[0]-4;i<L2[2]+4;++i) {
	    for(int j=L2[1]-4;j<L2[3]+4;++j) {
		if(BOX.contains(i,j)==true) {
                  int[] test1=AGMap.forwardMap(p,q,i,j);
		   gp.reset();
		   Complex z1=AGTransforms.k2pAffine(p,q,new Complex(i,j));
		   int ii=i+test1[0];
		   int jj=j+test1[1];
		   Complex z2=AGTransforms.k2pAffine(p,q,new Complex(ii,jj));
		   gp.moveTo(z1.x,z1.y);
		   gp.lineTo(z2.x,z2.y);
  	           OUT.lineWrite0(gp,new Color(135,135,135));
		}
	    }
	}
    }

    public static void drawPolygon(Manager M,Output OUT) {
	int i=(int)(Math.floor(M.P.SOURCE.x));
	int j=(int)(Math.floor(M.P.SOURCE.y));
	int p=M.p();
	int q=M.q();
	Tile T=new Tile(p,q,i,j);
	Path2D.Double gp=TileTracer.plaidPolygon(T);
	OUT.lineWrite0(gp,Color.black);
    }



    public static void drawPartialHexagrid(Manager M,Output OUT) {
	int p=M.p();
	int q=M.q();
	int a=MathRational.tune(p,q,p+q-1);
	int[] L=M.P.getLimits();
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<15;++i) {

	    if(M.H.Z[0].L[i].on==1) {
		System.out.println("used "+i);
		gp=M.H.getH(p,q,L,i);
                Color C=M.H.Z[0].M[i].C;  
                OUT.lineWrite0(gp,new Color(150,150,150));
	    }

	    if(M.H.Z[1].L[i].on==1) {
		gp=M.H.getV(p,q,L,i);
                Color C=M.H.Z[1].M[i].C;
                OUT.lineWrite0(gp,new Color(150,150,150));
	    }

	    if(M.H.Z[2].L[i].on==1) {
		gp=M.H.getSlant(0,p,q,L,i);
                Color C=M.H.Z[2].M[i].C;
		if(gp!=null) {
                OUT.lineWrite0(gp,new Color(150,150,150));
		}
	    }

	    if(M.H.Z[3].L[i].on==1) {
		gp=M.H.getSlant(1,p,q,L,i);
                Color C=M.H.Z[3].M[i].C;
		if(gp!=null) {
                OUT.lineWrite0(gp,new Color(150,150,150));
		}
	    }
	}
    }



    /**This draws the hitset*/

    public static void hitSet(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=GH.hitset(i,j);
	        Path2D.Double gp=X.toPath2D(); 
                OUT.polyWrite(gp,new Color(200,200,200),Color.black);
	    }
	}
    }

    public static void frame(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
	for(int i=-4;i<5;++i) {
	    for(int j=-4;j<5;++j) {
		PolygonWrapper X=GH.frame(i,j);
	        Path2D.Double gp=X.toPath2D(); 
                OUT.lineWrite0(gp,Color.black);
	    }
	}
    }

    public static void lowSet(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
	for(int i=-4;i<5;++i) {
	    for(int j=-4;j<5;++j) {
		PolygonWrapper X=GH.lowSet(i,j);
	        Path2D.Double gp=X.toPath2D(); 
                OUT.polyWrite(gp,new Color(140,140,140),Color.black);
	    }
	}
    }

    public static void highSet(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
	for(int i=-4;i<5;++i) {
	    for(int j=-4;j<5;++j) {
		PolygonWrapper X=GH.highSet(i,j);
	        Path2D.Double gp=X.toPath2D(); 
                OUT.polyWrite(gp,new Color(200,200,200),Color.black);
	    }
	}
    }

    public static void lowSetImage(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
 	int p=M.p();
	int q=M.q();
	double P=2.0*p/(p+q);
	for(int i=-4;i<5;++i) {
	    for(int j=-4;j<5;++j) {
		PolygonWrapper X=GH.lowSet(i,j);
  	        X=X.translate(new Complex(2*P-2,2*P));
	        Path2D.Double gp=X.toPath2D(); 
                OUT.polyWrite(gp,new Color(140,140,140),Color.black);
	    }
	}
    }

    public static void highSetImage(Manager M,Output OUT) {
	GridHitset GH=new GridHitset();
	GH.M=M;
	int p=M.p();
	int q=M.q();
	double P=2.0*p/(p+q);
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=GH.highSet(i,j); 
                X=X.translate(new Complex(2*P,2*P));
	        Path2D.Double gp=X.toPath2D(); 
                OUT.polyWrite(gp,new Color(200,200,200),Color.black);
	    }
	}
    }


    /**This draws the spacetime diagrams*/


    public static void spacetime(Manager M,Output OUT) {

	int CHOICE=1; //this could be 1 or 2.
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int offset=M.C.FRAME.val;
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<=CHOICE*w;++i) {
	    gp.reset();
	    gp.moveTo(0,i+offset);
	    gp.lineTo(w,i+offset); 
            OUT.lineWrite0(gp,new Color(180,180,180));
	}


	for(int i=0;i<=w;++i) {
	    gp.reset();
	    gp.moveTo(i,offset);
	    gp.lineTo(i,CHOICE*w+offset);
            OUT.lineWrite0(gp,new Color(180,180,180));
	}  


	AffineTransform AFF=AffineTransform.getTranslateInstance(0,CHOICE*w);
	int choice=M.ST.horizontalOrVertical(M.ST.Z);
	Complex[][] LINES=new Complex[0][0];
	int n1=(int)(Math.floor(M.ST.Z.y+.5));
	int n2=(int)(Math.floor(M.ST.Z.x+.5));
	if(choice==0) LINES=Spacetime.getLinesH(p,q,n1);
	if(choice==1) LINES=Spacetime.getLinesV(p,q,n2);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<CHOICE*w;++j) {
		if(choice==0) gp=Spacetime.tileHPath(p,q,LINES,i,j);
		if(choice==1) gp=Spacetime.tileVPath(p,q,LINES,i,j); 
		if(j<offset) gp.transform(AFF); 
                OUT.lineWrite0(gp,Color.black);
	    }
	}
    }






}








