import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class GraphPETCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Point JX;
    int[] type=new int[2];

    public GraphPETCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(100,300,180);
	 type[0]=1;
	 type[1]=1;	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g); 
      if(M.C.GRAPH.L[0].on==1) drawPartition(g,false);
    
      if(M.C.GRAPH.L[1].on==1) {
	  drawPartition(g,true);
      }

      if(M.C.GRAPH.L[2].on==1) {
         renderLattice(g);
         renderLattice(g,type[0],type[1]);
      }
      drawImage(g);
   }

    public void renderLattice(Graphics2D g) {
	g.setColor(new Color(0,0,0));
	g.fillRect(0,0,100,100);
	g.setColor(new Color(120,130,140));
	g.drawRect(0,0,100,100);
	AffineTransform AFF0=AffineTransform.getScaleInstance(25,-25);
	AffineTransform AFF1=AffineTransform.getTranslateInstance(50,50);
	int p=M.p();
	int q=M.q();
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		gp.reset();
	        Complex Z=AGLattice.shortVector(p,q,i-1,j-1);
	        gp.moveTo(0,0);
	        gp.lineTo(Z.x,Z.y);
                gp.transform(AFF0);
	        gp.transform(AFF1);
	        g.setColor(new Color(80,90,100));
	        g.draw(gp);  
	    }
	}
    }



    public void renderLattice(Graphics2D g,int i,int j) {

	int p=M.p();
	int q=M.q();
	Path2D.Double gp=new Path2D.Double();
	Complex Z=AGLattice.shortVector(p,q,i-1,j-1);
	gp.moveTo(0,0);
	gp.lineTo(Z.x,Z.y);

	AffineTransform AFF0=AffineTransform.getScaleInstance(25,-25);
	AffineTransform AFF1=AffineTransform.getTranslateInstance(50,50);	       gp.transform(AFF0);
	gp.transform(AFF1);
	g.setColor(GraphPETColors.COLOR[i][j]);
	g.setStroke(new BasicStroke(3));
	g.draw(gp);  
        g.setStroke(new BasicStroke(1));
    }


    /**This draws the current selected point
       in the PET*/

    public void drawImage(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(SOURCE.x,SOURCE.y);
	gp.lineTo(SOURCE.x,SOURCE.y);
	gp=transform(gp);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(5));
	g.fill(gp);
	g.draw(gp);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.fill(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,0));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawPartition(Graphics2D g,boolean select) {
	int s=M.GS.DIRECTION.mode; 
	int dyn=M.GS.PARTITION.mode;
        double t=M.GS.S[s];
	double A=M.GS.PAR;
	int lim=M.GS.TILE.val;
	for(int k=0;k<28;++k) {
	    for(int a1=-lim;a1<=lim;++a1) {
	    for(int a2=-lim;a2<=lim;++a2) {
	    for(int a3=-lim;a3<=lim;++a3) {
	      Polytope P=AllPolytopes.graph(k);
	      P=GraphPolytopeMoves.shift(2*a1,a2,a3,P);
	      //shift for the backward partition
	      if(dyn==0) {
		  if(k<14)  P=GraphPolytopeMoves.shift(+1,1,1,P);
	         if(k>13) P=GraphPolytopeMoves.shift(-1,0,0,P);
	      }


              PolygonWrapper SP=P.slice(s,t,A);
	      if(SP!=null) { 
                 int t1=P.type[1];
                 int t2=P.type[2];
	         Color C=GraphPETColors.COLOR[t1+1][t2+1];
		 if(select==true) {
		     int m=M.C.GRAPH_HIGHLIGHT.val;
		     C=new Color(30,40,50);
		     if(k==m) C=Color.yellow;
		 }
	         Path2D.Double gp=SP.toPath2D();
	         fillPoly(g,gp,C);
	         polyInfo(gp,a1,a2,a3,k);
	         polyInterpret(gp,a1,a2,a3,k);
	      }
	    }}}
	}
    }


    public boolean match(int[] J,int[] K) {
	for(int i=0;i<4;++i) {
	    if(J[i]!=K[i]) return false;
	}
	return true;
    }

    public void drawPoly(Graphics2D g,Path2D.Double gp,Color C) {
       gp=transform(gp);
       g.setColor(C);
       g.draw(gp);
    }

    public void fillPoly(Graphics2D g,Path2D.Double gp,Color C) {
       gp=transform(gp);
       g.setColor(C);
       g.fill(gp);  
       g.setColor(Color.white);
       g.draw(gp);
    }

    /**This is for displaying the polytope vertices*/

    public void polyInfo(Path2D.Double gp,int q1,int q2,int q3,int k) {
	if(gp.contains(SOURCE.x,SOURCE.y)==true) {
	    try{   
		int p0=M.GS.PARTITION.mode;
		int[] ty=DataGraphPolytopes.type(k);
                int[] S={q1,q2,q3,p0,ty[0],ty[1]};
		int[] LIST={0};
		M.I.LIST=LIST;
		M.I.POLY[0]=k;
		M.I.DATA=S;
	    }
	    catch(Exception e) {}
	}
    }

    /**This communicates with the interpreter*/
    public void polyInterpret(Path2D.Double gp,int q1,int q2,int q3,int k) {
	if(gp.contains(SOURCE.x,SOURCE.y)==true) {
	    try{   
  	        int[] ty=DataGraphPolytopes.type(k);
		type[0]=ty[0]+1;
		type[1]=ty[1]+1;
	    }
	    catch(Exception e) {}
	}
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2) {
	    SOURCE=unTransform(JX);
	}
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=J.X;
     }

   
     public void mouseDragged(MouseEvent e) {
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

