import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class GraphPETSlicer extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    int X,Y;
    double[] S=new double[3];
    double PAR;
    ControlPanel DIRECTION,LOCK,PARTITION;
    Path2D.Double[] SLICE=new Path2D.Double[3];
    ListenSquare CONTROL;
    ListenSquare GETPAR; 
    Lever TILE;


    public GraphPETSlicer() {
	addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	CONTROL=new ListenSquare(0,0,400,70);
	GETPAR=new ListenSquare(310,6,20,20);
	setScales(80,267,190);
	setPanels();
	PAR=2.0/9;
	double t=.5+1.0/9;
	S[0]=.5;
	S[1]=t;
	S[2]=t;  
        TILE=new Lever(230,20,0,3);

    }

    public double getSlice() {
	int mode=DIRECTION.mode;
	return(S[mode]);
    }

    public double getParameter() {
	return PAR;
    }

    public void setPanels() {
         Color[] C0={new Color(80,140,255),
         Color.white,Color.white,Color.black,Color.red};
	 Color c=Color.white;

	 String[] DirectionString={
	     "X","Y","Z","slice"};
	 int[] DirectionState={0,0,1};
         DIRECTION=new ControlPanel(C0,DirectionString,DirectionState,3);
	 DIRECTION.mode=2;

	 String[] PartitionString={
	     "backward","forward","partition"};
	 int[] PartitionState={0,1};
         PARTITION=new ControlPanel(C0,PartitionString,PartitionState,2);
	 PARTITION.mode=1;

	 String[] LockString={"locked","free","parameter"};
	 int[] LockState={0,1};
         LOCK=new ControlPanel(C0,LockString,LockState,2);
	 LOCK.mode=1;
    }




    public Path2D.Double makeSlider(double s,double a,double[] w) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(w[0],0);
	gp.lineTo(w[1],0);
	gp.lineTo(w[1],1);
	gp.lineTo(w[0],1);
	gp.closePath();
	gp.moveTo(s,-1);
	gp.lineTo(s,2);
	gp.moveTo(-2,a);
	gp.lineTo(3,a);
	return(gp);
    }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawSlicer(g);
      drawControls(g);
   }

    public void drawSlicer(Graphics2D g) {
	g.setColor(new Color(0,100,200));
	g.fillRect(0,0,getWidth(),getHeight());
	int p=M.p();
	int q=M.q();
	double A=1.0*p/q;
	double[][] w={{0,2},{-1,A},{0,1+A}};
	int c=DIRECTION.mode;
	Path2D.Double gp=makeSlider(S[c],PAR,w[c]);
	gp=transform(gp);
	g.setColor(new Color(200,0,200));
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public void drawControls(Graphics2D g) {
	CONTROL.render(g,new Color(0,0,100));
	DIRECTION.render(g,0,0,45);
	PARTITION.render(g,130,0,75);
	LOCK.render(g,50,0,75);
	TILE.render(g,"tiling extent",Color.blue);
	GETPAR.render(g,new Color(255,0,255));
	g.setColor(Color.white);
	g.drawString("grab",338,12);
	g.drawString("parameter",338,27);
    }

    public void grabParameter() {
	int p=M.p();
	int q=M.q();
	PAR=1.0*p/q;
    }


    public PolygonWrapper project(Polytope P) {
        int s=DIRECTION.mode;
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.z[i]=new Complex(P.V[i].x[s],P.V[i].x[3]);
	}
	Q=PolygonWrapper.cheapHull(Q);
	return(Q);
    }

    public void documentStuff(Point X) {
	if(DIRECTION.L[20].inside(X)==1) DocumentGraph.slice(M.D);
	if(LOCK.L[20].inside(X)==1) DocumentGraph.lock(M.D);

    }




    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	DIRECTION.switchMode(J.X);
	PARTITION.switchMode(J.X);
	TILE.process(J.X);
	LOCK.switchMode(J.X);
	if(GETPAR.inside(J.X)==1) grabParameter();
	if(CONTROL.inside(J.X)==0) {
          if(J.mode==1)  scaleUp(J.X,0);
          if(J.mode==2)  {
	      int c=DIRECTION.mode;
              Complex z=unTransform(J.X);
	      S[c]=z.x;
	      if((LOCK.mode==1)&&(z.y>0)&&(z.y<1)) PAR=z.y;
	  }
          if(J.mode==3)  scaleUp(J.X,1);
	}
	documentStuff(J.X);
	M.repaint();
    }

    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==0) {
	  int c=DIRECTION.mode;
          Complex z=unTransform(J.X);
	  S[c]=z.x; 
          if((LOCK.mode==1)&&(z.y>0)&&(z.y<1)) PAR=z.y;
	}
	repaint();
	M.G.repaint();
    }


    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {}


    public void keyTyped(KeyEvent e) {}
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}


