import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class allows for the motion of
   polytopes associated to the graph PET.*/

public class GraphPolytopeMoves {

    /**This reflects in the center of the fundamental domain*/


    /**This adjusts the image of a polytope by a shift so that its center
       lies in the fundamental domain.*/

    public static Polytope adjustByShifting(Polytope P,Vector4 Y) {
	double A=Y.x[3];
	double d0=Y.x[0];
	double d1=Y.x[1]+d0;
	double d2=Y.x[2]+d0;
	d1=d1/(1+A);
	d2=d2-d1*(1-A);
	d2=d2/(1+A);
	int n0=recognizeInt(d0);
	int n1=recognizeInt(d1);
	int n2=recognizeInt(d2);
	Polytope Q=shift(n0,n1,n2,P);
	return(Q);
    }

    public static int recognizeInt(double d) {
	return (int)(Math.floor(d+.5));
    }


    /**this is the action of the lattice on polytopes.  The lattice is the one in
       my monograph.  It is a discrete Abelian group generated by three elements
       gamma1,gamma2,gamma3.  If we specify the integers q1,q2,q3, then the
       final shift vector is the linear combination 

           q1 gamma1 + q2 gamma2 + q3 gamma 3  
    **/


    public static Polytope shift(int q1,int q2,int q3,Polytope P) {
	Polytope Q=new Polytope(P);
	Q=shift1(q1,Q);
	Q=shift2(q2,Q);
	Q=shift3(q3,Q);
	for(int i=0;i<6;++i) Q.code[i]=P.code[i];
	return(Q);
    }

    public static Polytope shift1(int h,Polytope P) {
	Polytope Q=new Polytope();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=Vector4.plus(P.V[i],new Vector4(h,-h,-h,0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }

    public static Polytope shift2(int h,Polytope P) {
	Polytope Q=new Polytope();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    double A=P.V[i].x[3];
	    Q.V[i]=Vector4.plus(P.V[i],new Vector4(0,h*(1+A),h*(1-A),0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }


    public static Polytope shift3(int h,Polytope P) {
	Polytope Q=new Polytope();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) { 
            double A=P.V[i].x[3];
	    Q.V[i]=Vector4.plus(P.V[i],new Vector4(0,0,h*(1+A),0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }



    public static Polytope dynamics(Polytope P) {
	Polytope Q=new Polytope(P);
	int m1=P.type[1];
	int m2=P.type[2];
	for(int i=0;i<P.count;++i) {
	    double d=P.V[i].x[3];
	    double d0=m1*d+m2+(m2-m1);
	    double d1=m1*d+m2-(m2-m1);
	    double d2=m1*d+m2-(m2-m1);
	    Q.V[i]=Vector4.plus(P.V[i],new Vector4(d,d,d,0));
	}
	return Q;
    }



}