import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GridAnalyzer extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {

     Manager M;
     double PAR_A;
     double PAR_P;
     ListenSquare CONTROL;
     ListenSquare L;
     ListenSquare GRAB;
     int X0,Y0;
     ListenSquare INFO;
     Point JX;

     public GridAnalyzer() {
	addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	CONTROL=new ListenSquare(0,0,399,50);
	L=new ListenSquare(0,0,399,50);
	setScales(200,200,50);
	X0=0;
	Y0=0;
	PAR_A=2.0/9;
	PAR_P=4.0/11;
	GRAB=new ListenSquare(0,12,12,12);
	INFO=new ListenSquare(0,0,12,12);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
             
      RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);   
      drawSquares(g);
      drawSquareSelect(g);
      drawGrid(g);
      drawControls(g);
      drawTrail(g);
   }

   public void drawBG(Graphics2D g) {
       g.setColor(Color.black);
     g.fillRect(0,0,this.getWidth(),this.getHeight());
   }


   public void drawControls(Graphics2D g) {
       int W=getWidth();
       CONTROL.w=W-1;
       L.w=W-1;
       CONTROL.render(g,new Color(200,0,200));
       L.render(g,new Color(200,0,200));
       Path2D.Double gp=new Path2D.Double();
       gp.moveTo(W*PAR_A,0);
       gp.lineTo(W*PAR_A,50);
       g.setColor(Color.white);
       g.draw(gp);
       gp.reset();
       gp.moveTo(W*PAR_P,10);
       gp.lineTo(W*PAR_P,40);
       g.setColor(Color.yellow);
       GRAB.render(g,Color.red);
       INFO.infoRender(g);
       g.draw(gp);

   }

   public void drawSquares(Graphics2D g) {
      Path2D.Double gp=new Path2D.Double();

       for(int i=-40;i<40;++i) {
	       gp.reset();
	       gp.moveTo(-40,i);
	       gp.lineTo(40,i);
	       gp.moveTo(i,-40);
	       gp.lineTo(i,40);
	       gp=transform(gp);
	       g.setColor(new Color(255,255,255,100));
	       if(i==0) g.setColor(Color.yellow);
	       g.draw(gp);
       }
    }

   public void drawSquareSelect(Graphics2D g) {
      Path2D.Double gp=new Path2D.Double();
      gp.moveTo(SOURCE.x-.5,SOURCE.y-.5);
      gp.lineTo(SOURCE.x-.5,SOURCE.y+.5);
      gp.lineTo(SOURCE.x+.5,SOURCE.y+.5);
      gp.lineTo(SOURCE.x+.5,SOURCE.y-.5);
      gp.closePath();
      g.setColor(Color.white);
      g.setStroke(new BasicStroke(3));
      gp=transform(gp);
      g.draw(gp);
      g.setStroke(new BasicStroke(1));
    }




   public void drawGrid(Graphics2D g) {
       Path2D.Double gp=new Path2D.Double();
       double A=PAR_A; 
       g.setColor(Color.white);

       for(int i=-30;i<30;++i) {
	   for(int j=-30;j<30;++j) {
	       gp.reset();
	       Complex z=getGrid(i,j);
	       gp.moveTo(z.x,z.y);
	       gp.lineTo(z.x,z.y);
	       gp=transform(gp);
               g.setStroke(new BasicStroke(3)); 
               g.setColor(new Color(55,255,255));
	       if((i==X0)&&(j==Y0)) {
                    g.setStroke(new BasicStroke(8));
		    g.setColor(getColor(0,z));
	       }
	       if((i==X0)&&(j==Y0+1)) {
                    g.setStroke(new BasicStroke(8));
		    g.setColor(getColor(0,z));
	       }
	       g.fill(gp);
	       g.draw(gp);
	   }
       }  
       g.setStroke(new BasicStroke(1));
   }

	public Complex getGrid(int i,int j) {
	    double A=PAR_A;
            Complex z0=new Complex(.5+.5*A,.5-.5*A);
	    Complex dz=AGTransforms.k2pLinear(A,new Complex(i,j));
	    Complex z=Complex.plus(dz,z0);
	    return(z);
	}






   public Color getColor(int choice,Complex z) {
      double test=z.y-Math.floor(z.y);
      if(test<PAR_P) return M.C.HITSET.M[1+2*choice].C;
      if(test>PAR_P) return M.C.HITSET.M[2+2*choice].C;
      return(Color.white);
   }

   public void drawTrail(Graphics2D g) {
       int i=X0;
       int j=Y0;  
       Path2D.Double gp=new Path2D.Double();
       for(int k=0;k<1000;++k) {
	   double A=1.0*k/1000;
           Complex z0=new Complex(.5+.5*A,.5-.5*A);
           Complex dz=AGTransforms.k2pLinear(A,new Complex(i,j));
	   Complex z=Complex.plus(dz,z0);
	   if(k==0) gp.moveTo(z.x,z.y);
	   if(k!=0) gp.lineTo(z.x,z.y);
       }
       gp=transform(gp);
       g.setColor(Color.yellow);
       g.draw(gp);
   }


	public void sendPoint() {
           double P=PAR_P;
	   double A=P/(2-P);
	   tunePoint();
	   Vector4 V=PlaidClassifyingMap.PHI(A,SOURCE.x,SOURCE.y);
	   M.X.SOURCE=new Complex(V.x[0],V.x[1]);
	}

	public void recognizePoint(Point X) {
	    Complex z=unTransform(X);
	    nearestGrid(z);
	    double x=Math.floor(z.x)+.5;
	    double y=Math.floor(z.y)+.5;
	    SOURCE=new Complex(x,y);
	}

	public void tunePoint() {
	    Complex z=getGrid(X0,Y0);
	    double x=Math.floor(z.x)+.5;
	    double y=Math.floor(z.y)+.5;
	    SOURCE=new Complex(x,y);
	}


	public void nearestGrid(Complex z) {
	    double A=PAR_A;
            Complex z0=new Complex(.5+.5*A,.5-.5*A);
	    Complex z1=Complex.minus(z,z0);
	    Complex z2=AGTransforms.p2kLinear(A,z1);
	    X0=(int)(Math.floor(z2.x+.5));
	    Y0=(int)(Math.floor(z2.y+.5));
	}

	public void doDoc(Point X) {
	    if(INFO.inside(X)==1) {
		try{DocumentGrid.grid(M.D);}
		catch(Exception e) {}
	    }
	}




    public void mouseClicked(MouseEvent e) {
	double W=L.w+1;
        MouseData J=MouseData.process(e);  
	int c1=CONTROL.inside(J.X);
	int c2=GRAB.inside(J.X);
	int c3=INFO.inside(J.X);
	if((c1==1)&&(c2==0)&&(c3==0)) {
	    if(L.inside(J.X)==1) {
                 PAR_A=J.X.x/W;
		 PAR_P=2.0*PAR_A/(1+PAR_A);
	    }
	}

	if(c2==1) {
	    int p=M.p();
	    int q=M.q();
	    PAR_A=1.0*p/q;
	    PAR_P=2.0*p/(p+q);
	}

	if(CONTROL.inside(J.X)==0) {
	  if(J.mode==1) scaleUp(J.X,-1);
	  if(J.mode==3) scaleUp(J.X,+1);
	  if(J.mode==2) recognizePoint(J.X);
	}
	doDoc(J.X);
	sendPoint();
	M.repaint();
    }

    public void doMouseClick(int mode) {
	double W=L.w+1;
	int c1=CONTROL.inside(JX);
	int c2=GRAB.inside(JX);
	int c3=INFO.inside(JX);
	if((c1==1)&&(c2==0)&&(c3==0)) {
	    if(L.inside(JX)==1) {
                 PAR_A=JX.x/W;
		 PAR_P=2.0*PAR_A/(1+PAR_A);
	    }
	}

	if(c2==1) {
	    int p=M.p();
	    int q=M.q();
	    PAR_A=1.0*p/q;
	    PAR_P=2.0*p/(p+q);
	}

	if(CONTROL.inside(JX)==0) {
	  if(mode==1) scaleUp(JX,-1);
	  if(mode==3) scaleUp(JX,+1);
	  if(mode==2) recognizePoint(JX);
	}
	doDoc(JX);
	sendPoint();
	M.repaint();
    }



    public void mouseDragged(MouseEvent e) {
	double W=L.w+1;
        MouseData J=MouseData.process(e);  
	if(CONTROL.inside(J.X)==1) {
	     if(L.inside(J.X)==1) {
                 PAR_A=J.X.x/W;
		 PAR_P=2.0*PAR_A/(1+PAR_A);
	    }

	}
	sendPoint();
	M.repaint();
    }




    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {
        MouseData J=MouseData.process(e); 
	JX=J.X;
    }



    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}





    }