import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    public class GridHitset extends ScaleCanvas implements MouseListener,MouseMotionListener {

     Manager M;
	ListenSquare DISPLAY;

     public GridHitset() {
	addMouseListener(this);
	addMouseMotionListener(this);
	setScales(200,200,150);
	DISPLAY=new ListenSquare(0,0,400,30);
     }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
             
      RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(M.C.HITSET.L[0].on==1) hitSet(g);
      if(M.C.HITSET.L[1].on==1) lowSet(g);
      if(M.C.HITSET.L[2].on==1) highSet(g);
      if(M.C.HITSET.L[3].on==1) lowSetImage(g);
      if(M.C.HITSET.L[4].on==1) highSetImage(g);
      if(M.C.HITSET.L[5].on==1) frame(g);
      if(M.C.HITSET.L[6].on==1) cursor(g);
      if(M.C.HITSET.L[7].on==1) pointerRaw(g);
      if(M.C.HITSET.L[8].on==1) pointer(g);
   }

   public void drawBG(Graphics2D g) {
       g.setColor(new Color(180,0,180));
       g.fillRect(0,0,this.getWidth(),this.getHeight());
       Path2D.Double gp=new Path2D.Double();
       gp.moveTo(-1,-1);
       gp.lineTo(-1,1);
       gp.lineTo(1,1);
       gp.lineTo(1,-1);
       gp.closePath();
       gp=transform(gp);
       g.setColor(new Color(255,255,255,100));
       g.draw(gp);
    
   }



   public void cursor(Graphics2D g) { 
       double P=M.Y.PAR_P;
       int test=hiOrLo(SOURCE);
       Path2D.Double gp=new Path2D.Double();
       Color C=Color.black;
       fillPoint(g,SOURCE,.04,C,Color.white,16);
   }


   public void mesh(Graphics2D g) { 
       double P=M.Y.PAR_P;
       int test=hiOrLo(SOURCE);
       Complex z=new Complex(SOURCE);
       if(test==1) z=Complex.plus(z,new Complex(2*P-2,2*P));
       if(test==2) z=Complex.plus(z,new Complex(2*P,2*P));
	   for(int i=-3;i<3;++i) {
	       for(int j=-3;j<3;++j) {
		   Complex w1=Complex.plus(z,new Complex(2*i,P*i+2*j));
		   Complex w2=Complex.plus(SOURCE,new Complex(2*i,P*i+2*j));
                   fillPoint(g,w1,.03,Color.green,Color.white,16); 
                   fillPoint(g,w2,.05,Color.magenta,Color.white,16); 
	       }
	   }
       g.setStroke(new BasicStroke(1));
   }

   public void pointerRaw(Graphics2D g) { 
       double P=M.Y.PAR_P;
       int test=hiOrLo(SOURCE);
       Complex z=new Complex(SOURCE);
       if(test==1) z=Complex.plus(z,new Complex(2*P-2,2*P));
       if(test==2) z=Complex.plus(z,new Complex(2*P,2*P));
       Path2D.Double gp=new Path2D.Double();
       gp.moveTo(SOURCE.x,SOURCE.y);
       gp.lineTo(z.x,z.y);
       gp=transform(gp);
       g.setStroke(new BasicStroke(2));
       g.draw(gp);
       mesh(g);
       g.setStroke(new BasicStroke(1));
   }

   public void pointer(Graphics2D g) { 
       double P=M.Y.PAR_P;
       int test=hiOrLo(SOURCE);
       Complex z=new Complex(SOURCE);
       if(test==1) z=Complex.plus(z,new Complex(2*P-2,2*P));
       if(test==2) z=Complex.plus(z,new Complex(2*P,2*P));
       Path2D.Double gp=new Path2D.Double();
       Complex w1=reduce(SOURCE);
       Complex w2=reduce(z);
       gp.moveTo(w1.x,w1.y);
       gp.lineTo(w2.x,w2.y);
       gp=transform(gp);
       g.setStroke(new BasicStroke(2));
       g.draw(gp);
       mesh(g);
       g.setStroke(new BasicStroke(1)); 
       DISPLAY.render(g,Color.black);
       String Sx=recognize(w2.x-w1.x);
       String Sy=recognize(w2.y-w1.y);
       String S=delta(w1,w2);
       g.setColor(Color.white);  
       g.setFont(new Font("Helvetica",Font.PLAIN,14));
       g.drawString(Sx,35,25);
       g.drawString(Sy,115,25);
       g.drawString(S,195,25);
   }


    public Complex reduce(Complex z) { 
       double P=M.Y.PAR_P;
       for(int i=-5;i<5;++i) {
          for(int j=-5;j<5;++j) {
             Complex w=Complex.plus(z,new Complex(2*i,P*i+2*j));
	     if((Math.abs(w.x)<1)&&(Math.abs(w.y)<1)) return w;
	  }
       }
       return z;
    }

    public String recognize(double d) {
       double P=M.Y.PAR_P;
       int i0=0;
       int j0=0;
       double min=100;
       for(int i=-5;i<5;++i) {
	   for(int j=-5;j<5;++j) {
	       double d2=i*P+j;
	       double test=Math.abs(d-d2);
	       if(test<min) {
		   min=test;
		   i0=i;
		   j0=j;
	       }
	   }
       }
       Integer I0=new Integer(i0);
       Integer J0=new Integer(j0);
       String S=I0.toString()+" P + "+J0.toString();
       return S;
    }


    public String delta(Complex z1,Complex z2) {
	int a1=-1;
	int a2=-1;
	if(z1.x<z1.y) a1=1;
	if(z2.x<z2.y) a2=1;
	Integer I=new Integer(a2-a1);
	return "("+I.toString()+")";
    }


   public int hiOrLo(Complex z) {
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X1=lowSet(i,j);
		PolygonWrapper X2=highSet(i,j);
	        Path2D.Double gp1=X1.toPath2D();
	        Path2D.Double gp2=X2.toPath2D();
		if(gp1.contains(z.x,z.y)==true) return 1;
		if(gp2.contains(z.x,z.y)==true) return 2;
	    }
	}
	return -1;
   }





    public void fillPoly(Graphics2D g,Path2D.Double gp,Color C) {
       gp=transform(gp);
       g.setColor(C);
       g.fill(gp);  
       g.setColor(Color.white);
       g.draw(gp);
    }

    public void frame(Graphics2D g) {
 	g.setStroke(new BasicStroke(2));
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=frame(i,j);
	        Path2D.Double gp=X.toPath2D();
		gp=transform(gp);
		g.setColor(M.C.HITSET.M[5].C);
		g.draw(gp);
	    }
	}
        g.setStroke(new BasicStroke(2));
    }

    public void hitSet(Graphics2D g) {
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=hitset(i,j);
	        Path2D.Double gp=X.toPath2D();
		fillPoly(g,gp,M.C.HITSET.M[0].C);
	    }
	}
    }

    public void lowSet(Graphics2D g) {	
        double P=M.Y.PAR_P;
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=lowSet(i,j);
	        Path2D.Double gp=X.toPath2D();
		fillPoly(g,gp,M.C.HITSET.M[1].C);
	    }
	}
    }

    public void highSet(Graphics2D g) {	
        double P=M.Y.PAR_P;
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=highSet(i,j);
	        Path2D.Double gp=X.toPath2D();
		fillPoly(g,gp,M.C.HITSET.M[2].C);
	    }
	}
    }

    public void lowSetImage(Graphics2D g) {	
        double P=M.Y.PAR_P;
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=lowSet(i,j);
		X=X.translate(new Complex(2*P-2,2*P));
	        Path2D.Double gp=X.toPath2D();
		fillPoly(g,gp,M.C.HITSET.M[3].C);
	    }
	}
    }

    public void highSetImage(Graphics2D g) {	
        double P=M.Y.PAR_P;
	for(int i=-4;i<5;++i) {
	    for(int j=-1;j<2;++j) {
		PolygonWrapper X=highSet(i,j);
		X=X.translate(new Complex(2*P,2*P));
	        Path2D.Double gp=X.toPath2D();
		fillPoly(g,gp,M.C.HITSET.M[4].C);
	    }
	}
    }



    public PolygonWrapper hitset(int i,int j) {
	double P=4.0/11;
	try{
	  P=M.Y.PAR_P;
	}
	catch(Exception e) {}

	double[][] d={{-1,-1},{-1+P,-1+P},{1-P,-1},{1,-1+P},
                      {1,1},{1-P,1-P},{-1+P,1},{-1,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=8;
	for(int k=0;k<8;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,2*j+i*P));
	}
				 
	return X;
    }

    public PolygonWrapper frame(int i,int j) {
	double P=M.Y.PAR_P;
	double[][] d={{-1,-1},{-1,1},{1,1},{1,-1}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,2*j+i*P));
	}
				 
	return X;
    }



	public PolygonWrapper lowSet(int i,int j) {
	double P=M.Y.PAR_P;


	double[][] d={{1-3*P,1-3*P},{1-P,1-P},{-1+P,1},{-1-P,1-2*P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,2*j+i*P));
	}
				 
	return X;
    }



    public PolygonWrapper highSet(int i,int j) {
	double P=M.Y.PAR_P;

	double[][] d={{-1+P,-1+P},{1-P,-1},{3-3*P,1-2*P},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,2*j+i*P));
	}
				 
	return X;
    }


    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);  
	if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,+1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
    }



    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);  
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
    }




    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {}


    }