import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    public class HexagridControl extends ScaleCanvas implements MouseListener,MouseMotionListener {

    Manager M;
    ControlPanelColor[] Z=new ControlPanelColor[6];
    ListenSquare[] CLEAR=new ListenSquare[6];
    ListenSquare[] EXTRA=new ListenSquare[6];
    Lever[] SIGN=new Lever[6];
    SelectInteger[] WEIGHT=new SelectInteger[6];

	public HexagridControl() {
	    addMouseListener(this);
	    addMouseMotionListener(this);
	setPanels();
	for(int i=0;i<6;++i) {
             CLEAR[i]=new ListenSquare(50*i,333,50,20);
             EXTRA[i]=new ListenSquare(50*i,267,12,12);
	     SIGN[i]=new Lever(50*i,286,0,2);
	     EXTRA[i].on=0;
	}
	for(int i=0;i<2;++i) {
	     WEIGHT[i]=new SelectInteger(50*i,305,27,14,16,0,100,2);
	}

	for(int i=2;i<6;++i) {
	     WEIGHT[i]=new SelectInteger(50*i,305,27,14,17,0,100,2);
	}
    }

    public void setPanels() {
	Color[] C0={new Color(60,0,60),
         Color.white,Color.white,Color.white,Color.orange};
	 Color[] C1={
	 Color.white,
	 Color.white,
	 new Color(255,100,200),
	 new Color(255,100,200),
	 new Color(255,255,0),
	 new Color(255,255,0),
	 new Color(0,200,0),
	 new Color(0,200,0),
	 new Color(60,160,255),
	 new Color(60,160,255),
	 new Color(155,110,255),
	 new Color(155,110,255),
	 new Color(170,130,100),
	 new Color(170,130,100),
	 new Color(100,130,170),
	 new Color(100,130,170),
         Color.red,
         Color.red,
         Color.red,
         Color.red,
         Color.red,
	 Color.red,
	 Color.red};

	 int[][] ZState=new int[6][20];

	 String[] ZString1=new String[20];
	 for(int i=0;i<20;++i) {
	     int j=2*(i/2);
	     Integer I=new Integer(j);
	     String S=I.toString();
	     if(i%2==1) S="";
	     ZString1[i]=new String(S);
	 }

	 String[] ZString2=new String[20];
	 for(int i=0;i<20;++i) {
	     int j=2*(i/2)+1;
	     Integer I=new Integer(j); 
             String S=I.toString();
	     if(i%2==1) S="";
	     ZString2[i]=S;
	 }


	 Z[0]=new ControlPanelColor(C0,ZString1,ZState[0],16,C1);
	 Z[1]=new ControlPanelColor(C0,ZString1,ZState[1],16,C1);
	 Z[2]=new ControlPanelColor(C0,ZString2,ZState[2],16,C1);
	 Z[3]=new ControlPanelColor(C0,ZString2,ZState[3],16,C1);
	 Z[4]=new ControlPanelColor(C0,ZString2,ZState[4],16,C1);
	 Z[5]=new ControlPanelColor(C0,ZString2,ZState[5],16,C1);

	 Z[0].S[16]="H";
	 Z[1].S[16]="V";
	 Z[2].S[16]="P-";
	 Z[3].S[16]="Q-";
	 Z[4].S[16]="P+";
	 Z[5].S[16]="Q-";
	 for(int i=0;i<2;++i) {
	     for(int j=0;j<4;++j) {
		 Z[i].L[j].on=1;
	     }
	 }
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      render(g);
   }




    public void render(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,300,400);
	g.setColor(Color.white);
	g.drawRect(0,0,300,400);
	for(int i=0;i<6;++i) {
	    Z[i].render(g,i*50,0,50);
	    CLEAR[i].render(g,"clear",new Color(60,0,60));
	    EXTRA[i].render(g,new Color(0,180,0),Color.yellow,Color.white);
	    SIGN[i].render(g,"",Color.blue);
	    WEIGHT[i].render(g,Color.blue,Color.white,Color.white);
	}
    }

    public void documentStuff(Point X) {
	for(int i=0;i<6;++i) {
            if(Z[i].L[20].inside(X)==1) DocumentHexagrid.basic(M.D);
	    if(SIGN[i].L[2].inside(X)==1) DocumentHexagrid.advanced(M.D);
	}
    }

    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);  
	for(int i=0;i<6;++i) {
           Z[i].process(J.X,M.color());
	   if(CLEAR[i].inside(J.X)==1) reset(i);
	   if(EXTRA[i].inside(J.X)==1) EXTRA[i].on=1-EXTRA[i].on;
	   SIGN[i].process(J.X);
	   WEIGHT[i].modify(J.X);
	}
	documentStuff(J.X);
        M.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }


    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {}


    /**resets*/
    public void reset(int j) {
	for(int i=0;i<16;++i) Z[j].L[i].on=0;
    }


    /**generating the lines*/

    public static Path2D.Double getH(int p,int q,int[] L,int i) {
	if(i%2==0) return getHPlus(p,q,L,i/2);
	return getHMinus(p,q,L,i/2);
    }

    public static Path2D.Double getV(int p,int q,int[] L,int i) {
	if(i%2==0) return getVPlus(p,q,L,i/2);
	return getVMinus(p,q,L,i/2);
    }


    public static Path2D.Double getSlant(int choice,int p,int q,int[] L,int i) {
	int w=p+q;
	int j=2*(i/2)+1;
	if(i%2==1) j=-j;
	double S=-2.0*p/(w);
	if(choice==1) S=-2.0*q/(w);
	if(choice==2) S=+2.0*p/(w);
	if(choice==3) S=+2.0*q/(w);
	return getSlant0(S,p,q,L,j);
    }


    public static Path2D.Double getHMinus(int p,int q,int[] L,int i) {
	int a=MathRational.tune(p,q,p+q-1);
	int t=(i*a)%(p+q);
	if(i==0) t=p+q;
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(L[0],t);
	gp.lineTo(L[1],t);
	return(gp);
    }

    public static Path2D.Double getHPlus(int p,int q,int[] L,int i) {
	int a=MathRational.tune(p,q,1);
	int t=(i*a)%(p+q);
	if(i==0) t=0;
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(L[0],t);
	gp.lineTo(L[1],t);
	return(gp);
    }  


    public static Path2D.Double getVMinus(int p,int q,int[] L,int i) {
	int a=MathRational.tune(p,q,p+q-1);
	int t=(i*a)%(p+q);
	if(i==0) t=p+q;	
        Path2D.Double gp=new Path2D.Double();
	gp.moveTo(L[0]+t,0);
	gp.lineTo(L[0]+t,p+q);
	return(gp);
    }



    public static Path2D.Double getVPlus(int p,int q,int[] L,int i) {
	int a=MathRational.tune(p,q,p+q-1);
	int t=(i*a)%(p+q);
	if(i==0) t=p+q;
 	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(L[1]-t,0);
	gp.lineTo(L[1]-t,p+q);
	return(gp);
    }

    public static Path2D.Double getSlant0(double slope,int p,int q,int[] L,int i) {
	double a=MathRational.slant(p,q,i);
	double y=-slope*L[0];
	y=(p+q)*Math.floor(y/(p+q));
	a=a+y;
	Path2D.Double gp=new Path2D.Double();
	for(int j=-5;j<5;++j) {

	    Complex z0=new Complex(L[0],slope*L[0]+a+j*(p+q));
	    Complex z1=new Complex(L[1],slope*L[1]+a+j*(p+q));
	    Complex[] Z={z0,z1};
	    Complex b0=new Complex(L[0],0);
	    Complex b1=new Complex(L[1],p+q);
	    Z=GraphicsHelp.trim(b0,b1,Z);
	    if(Z!=null) {
	      gp.moveTo(Z[0].x,Z[0].y);
	      gp.lineTo(Z[1].x,Z[1].y);
	    }
	}
	return(gp);
    }  


}





